/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl.platform.ios;

import com.sun.media.jfxmedia.MediaError;
import com.sun.media.jfxmedia.MediaException;
import com.sun.media.jfxmedia.effects.AudioEqualizer;
import com.sun.media.jfxmedia.effects.AudioSpectrum;
import com.sun.media.jfxmedia.effects.EqualizerBand;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmediaimpl.NativeMediaPlayer;
import com.sun.media.jfxmediaimpl.platform.ios.IOSMedia;
import java.util.HashMap;
import java.util.Map;

public final class IOSMediaPlayer
extends NativeMediaPlayer {
    private IOSMedia iosMedia;
    private final NullAudioEQ audioEqualizer;
    private final NullAudioSpectrum audioSpectrum;
    private float mutedVolume = 1.0f;
    private boolean muteEnabled;

    private IOSMediaPlayer(IOSMedia sourceMedia) {
        super(sourceMedia);
        this.iosMedia = sourceMedia;
        this.init();
        this.handleError(this.iosInitPlayer(this.iosMedia.getNativeMediaRef()));
        this.audioEqualizer = new NullAudioEQ();
        this.audioSpectrum = new NullAudioSpectrum();
    }

    IOSMediaPlayer(Locator source) {
        this(new IOSMedia(source));
    }

    @Override
    public AudioEqualizer getEqualizer() {
        return this.audioEqualizer;
    }

    @Override
    public AudioSpectrum getAudioSpectrum() {
        return this.audioSpectrum;
    }

    private void handleError(int err) throws MediaException {
        if (0 != err) {
            MediaError me = MediaError.getFromCode(err);
            throw new MediaException("Media error occurred", null, me);
        }
    }

    @Override
    protected long playerGetAudioSyncDelay() throws MediaException {
        long[] audioSyncDelay = new long[1];
        this.handleError(this.iosGetAudioSyncDelay(this.iosMedia.getNativeMediaRef(), audioSyncDelay));
        return audioSyncDelay[0];
    }

    @Override
    protected void playerSetAudioSyncDelay(long delay) throws MediaException {
        this.handleError(this.iosSetAudioSyncDelay(this.iosMedia.getNativeMediaRef(), delay));
    }

    @Override
    protected void playerPlay() throws MediaException {
        this.handleError(this.iosPlay(this.iosMedia.getNativeMediaRef()));
    }

    @Override
    protected void playerStop() throws MediaException {
        this.handleError(this.iosStop(this.iosMedia.getNativeMediaRef()));
    }

    @Override
    protected void playerPause() throws MediaException {
        this.handleError(this.iosPause(this.iosMedia.getNativeMediaRef()));
    }

    @Override
    protected float playerGetRate() throws MediaException {
        float[] rate = new float[1];
        this.handleError(this.iosGetRate(this.iosMedia.getNativeMediaRef(), rate));
        return rate[0];
    }

    @Override
    protected void playerSetRate(float rate) throws MediaException {
        this.handleError(this.iosSetRate(this.iosMedia.getNativeMediaRef(), rate));
    }

    @Override
    protected double playerGetPresentationTime() throws MediaException {
        double[] presentationTime = new double[1];
        this.handleError(this.iosGetPresentationTime(this.iosMedia.getNativeMediaRef(), presentationTime));
        return presentationTime[0];
    }

    @Override
    protected boolean playerGetMute() throws MediaException {
        return this.muteEnabled;
    }

    @Override
    protected synchronized void playerSetMute(boolean enable) throws MediaException {
        if (enable != this.muteEnabled) {
            if (enable) {
                float currentVolume = this.getVolume();
                this.playerSetVolume(0.0f);
                this.muteEnabled = true;
                this.mutedVolume = currentVolume;
            } else {
                this.muteEnabled = false;
                this.playerSetVolume(this.mutedVolume);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected float playerGetVolume() throws MediaException {
        IOSMediaPlayer iOSMediaPlayer = this;
        synchronized (iOSMediaPlayer) {
            if (this.muteEnabled) {
                return this.mutedVolume;
            }
        }
        float[] volume = new float[1];
        this.handleError(this.iosGetVolume(this.iosMedia.getNativeMediaRef(), volume));
        return volume[0];
    }

    @Override
    protected synchronized void playerSetVolume(float volume) throws MediaException {
        if (!this.muteEnabled) {
            int err = this.iosSetVolume(this.iosMedia.getNativeMediaRef(), volume);
            if (0 != err) {
                this.handleError(err);
            } else {
                this.mutedVolume = volume;
            }
        } else {
            this.mutedVolume = volume;
        }
    }

    @Override
    protected float playerGetBalance() throws MediaException {
        float[] balance = new float[1];
        this.handleError(this.iosGetBalance(this.iosMedia.getNativeMediaRef(), balance));
        return balance[0];
    }

    @Override
    protected void playerSetBalance(float balance) throws MediaException {
        this.handleError(this.iosSetBalance(this.iosMedia.getNativeMediaRef(), balance));
    }

    @Override
    protected double playerGetDuration() throws MediaException {
        double[] durationArr = new double[1];
        this.handleError(this.iosGetDuration(this.iosMedia.getNativeMediaRef(), durationArr));
        double duration = durationArr[0] == -1.0 ? Double.POSITIVE_INFINITY : durationArr[0];
        return duration;
    }

    @Override
    protected void playerSeek(double streamTime) throws MediaException {
        this.handleError(this.iosSeek(this.iosMedia.getNativeMediaRef(), streamTime));
    }

    @Override
    protected void playerInit() throws MediaException {
    }

    @Override
    protected void playerFinish() throws MediaException {
        this.handleError(this.iosFinish(this.iosMedia.getNativeMediaRef()));
    }

    @Override
    protected void playerDispose() {
        this.iosDispose(this.iosMedia.getNativeMediaRef());
        this.iosMedia = null;
    }

    public void setOverlayX(double x) {
        this.handleError(this.iosSetOverlayX(this.iosMedia.getNativeMediaRef(), x));
    }

    public void setOverlayY(double y) {
        this.handleError(this.iosSetOverlayY(this.iosMedia.getNativeMediaRef(), y));
    }

    public void setOverlayVisible(boolean visible) {
        this.handleError(this.iosSetOverlayVisible(this.iosMedia.getNativeMediaRef(), visible));
    }

    public void setOverlayWidth(double width) {
        this.handleError(this.iosSetOverlayWidth(this.iosMedia.getNativeMediaRef(), width));
    }

    public void setOverlayHeight(double height) {
        this.handleError(this.iosSetOverlayHeight(this.iosMedia.getNativeMediaRef(), height));
    }

    public void setOverlayPreserveRatio(boolean preserveRatio) {
        this.handleError(this.iosSetOverlayPreserveRatio(this.iosMedia.getNativeMediaRef(), preserveRatio));
    }

    public void setOverlayOpacity(double opacity) {
        this.handleError(this.iosSetOverlayOpacity(this.iosMedia.getNativeMediaRef(), opacity));
    }

    public void setOverlayTransform(double mxx, double mxy, double mxz, double mxt, double myx, double myy, double myz, double myt, double mzx, double mzy, double mzz, double mzt) {
        this.handleError(this.iosSetOverlayTransform(this.iosMedia.getNativeMediaRef(), mxx, mxy, mxz, mxt, myx, myy, myz, myt, mzx, mzy, mzz, mzt));
    }

    private native int iosInitPlayer(long var1);

    private native int iosGetAudioSyncDelay(long var1, long[] var3);

    private native int iosSetAudioSyncDelay(long var1, long var3);

    private native int iosPlay(long var1);

    private native int iosPause(long var1);

    private native int iosStop(long var1);

    private native int iosGetRate(long var1, float[] var3);

    private native int iosSetRate(long var1, float var3);

    private native int iosGetPresentationTime(long var1, double[] var3);

    private native int iosGetVolume(long var1, float[] var3);

    private native int iosSetVolume(long var1, float var3);

    private native int iosGetBalance(long var1, float[] var3);

    private native int iosSetBalance(long var1, float var3);

    private native int iosGetDuration(long var1, double[] var3);

    private native int iosSeek(long var1, double var3);

    private native void iosDispose(long var1);

    private native int iosFinish(long var1);

    private native int iosSetOverlayX(long var1, double var3);

    private native int iosSetOverlayY(long var1, double var3);

    private native int iosSetOverlayVisible(long var1, boolean var3);

    private native int iosSetOverlayWidth(long var1, double var3);

    private native int iosSetOverlayHeight(long var1, double var3);

    private native int iosSetOverlayPreserveRatio(long var1, boolean var3);

    private native int iosSetOverlayOpacity(long var1, double var3);

    private native int iosSetOverlayTransform(long var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19, double var21, double var23, double var25);

    private static final class NullEQBand
    implements EqualizerBand {
        private double center;
        private double bandwidth;
        private double gain;

        NullEQBand(double center, double bandwidth, double gain) {
            this.center = center;
            this.bandwidth = bandwidth;
            this.gain = gain;
        }

        @Override
        public double getCenterFrequency() {
            return this.center;
        }

        @Override
        public void setCenterFrequency(double centerFrequency) {
            this.center = centerFrequency;
        }

        @Override
        public double getBandwidth() {
            return this.bandwidth;
        }

        @Override
        public void setBandwidth(double bandwidth) {
            this.bandwidth = bandwidth;
        }

        @Override
        public double getGain() {
            return this.gain;
        }

        @Override
        public void setGain(double gain) {
            this.gain = gain;
        }
    }

    private static final class NullAudioSpectrum
    implements AudioSpectrum {
        private boolean enabled = false;
        private int bandCount = 128;
        private double interval = 0.1;
        private int threshold = 60;
        private float[] fakeData;

        private NullAudioSpectrum() {
        }

        @Override
        public boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public int getBandCount() {
            return this.bandCount;
        }

        @Override
        public void setBandCount(int bands) {
            this.bandCount = bands;
            this.fakeData = new float[this.bandCount];
        }

        @Override
        public double getInterval() {
            return this.interval;
        }

        @Override
        public void setInterval(double interval) {
            this.interval = interval;
        }

        @Override
        public int getSensitivityThreshold() {
            return this.threshold;
        }

        @Override
        public void setSensitivityThreshold(int threshold) {
            this.threshold = threshold;
        }

        @Override
        public float[] getMagnitudes(float[] mag) {
            int size = this.fakeData.length;
            if (mag == null || mag.length < size) {
                mag = new float[size];
            }
            System.arraycopy(this.fakeData, 0, mag, 0, size);
            return mag;
        }

        @Override
        public float[] getPhases(float[] phs) {
            int size = this.fakeData.length;
            if (phs == null || phs.length < size) {
                phs = new float[size];
            }
            System.arraycopy(this.fakeData, 0, phs, 0, size);
            return phs;
        }
    }

    private static final class NullAudioEQ
    implements AudioEqualizer {
        private boolean enabled = false;
        private Map<Double, EqualizerBand> bands = new HashMap<Double, EqualizerBand>();

        private NullAudioEQ() {
        }

        @Override
        public boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public void setEnabled(boolean bEnable) {
            this.enabled = bEnable;
        }

        @Override
        public EqualizerBand addBand(double centerFrequency, double bandwidth, double gain) {
            Double key = new Double(centerFrequency);
            if (this.bands.containsKey(key)) {
                this.removeBand(centerFrequency);
            }
            NullEQBand newBand = new NullEQBand(centerFrequency, bandwidth, gain);
            this.bands.put(key, newBand);
            return newBand;
        }

        @Override
        public boolean removeBand(double centerFrequency) {
            Double key = new Double(centerFrequency);
            if (this.bands.containsKey(key)) {
                this.bands.remove(key);
                return true;
            }
            return false;
        }
    }
}

