/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font.freetype;

import com.sun.javafx.font.Disposer;
import com.sun.javafx.font.FontStrikeDesc;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.PrismFontFile;
import com.sun.javafx.font.PrismFontStrike;
import com.sun.javafx.font.freetype.FTDisposer;
import com.sun.javafx.font.freetype.FTFactory;
import com.sun.javafx.font.freetype.FTFontStrike;
import com.sun.javafx.font.freetype.FTGlyph;
import com.sun.javafx.font.freetype.FT_Bitmap;
import com.sun.javafx.font.freetype.FT_GlyphSlotRec;
import com.sun.javafx.font.freetype.FT_Glyph_Metrics;
import com.sun.javafx.font.freetype.FT_Matrix;
import com.sun.javafx.font.freetype.OSFreetype;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.transform.BaseTransform;

class FTFontFile
extends PrismFontFile {
    private long library;
    private long face;
    private FTDisposer disposer;

    FTFontFile(String name, String filename, int fIndex, boolean register, boolean embedded, boolean copy, boolean tracked) throws Exception {
        super(name, filename, fIndex, register, embedded, copy, tracked);
        this.init();
    }

    private synchronized void init() throws Exception {
        long[] ptr = new long[1];
        int error = OSFreetype.FT_Init_FreeType(ptr);
        if (error != 0) {
            throw new Exception("FT_Init_FreeType Failed error " + error);
        }
        this.library = ptr[0];
        if (FTFactory.LCD_SUPPORT) {
            OSFreetype.FT_Library_SetLcdFilter(this.library, 1);
        }
        String file = this.getFileName();
        int fontIndex = this.getFontIndex();
        byte[] buffer = (file + "\u0000").getBytes();
        error = OSFreetype.FT_New_Face(this.library, buffer, fontIndex, ptr);
        if (error != 0) {
            throw new Exception("FT_New_Face Failed error " + error + " Font File " + file + " Font Index " + fontIndex);
        }
        this.face = ptr[0];
        if (!this.isRegistered()) {
            this.disposer = new FTDisposer(this.library, this.face);
            Disposer.addRecord(this, this.disposer);
        }
    }

    @Override
    protected PrismFontStrike<?> createStrike(float size, BaseTransform transform, int aaMode, FontStrikeDesc desc) {
        return new FTFontStrike(this, size, transform, aaMode, desc);
    }

    @Override
    protected synchronized int[] createGlyphBoundingBox(int gc) {
        int flags = 1;
        OSFreetype.FT_Load_Glyph(this.face, gc, flags);
        int[] bbox = new int[4];
        FT_GlyphSlotRec glyphRec = OSFreetype.getGlyphSlot(this.face);
        if (glyphRec != null && glyphRec.metrics != null) {
            FT_Glyph_Metrics gm = glyphRec.metrics;
            bbox[0] = (int)gm.horiBearingX;
            bbox[1] = (int)(gm.horiBearingY - gm.height);
            bbox[2] = (int)(gm.horiBearingX + gm.width);
            bbox[3] = (int)gm.horiBearingY;
        }
        return bbox;
    }

    synchronized Path2D createGlyphOutline(int gc, float size) {
        int size26dot6 = (int)(size * 64.0f);
        OSFreetype.FT_Set_Char_Size(this.face, 0L, size26dot6, 72, 72);
        int flags = 2058;
        OSFreetype.FT_Load_Glyph(this.face, gc, flags);
        return OSFreetype.FT_Outline_Decompose(this.face);
    }

    synchronized void initGlyph(FTGlyph glyph, FTFontStrike strike) {
        byte[] buffer;
        float size = strike.getSize();
        if (size == 0.0f) {
            glyph.buffer = new byte[0];
            glyph.bitmap = new FT_Bitmap();
            return;
        }
        int size26dot6 = (int)(size * 64.0f);
        OSFreetype.FT_Set_Char_Size(this.face, 0L, size26dot6, 72, 72);
        boolean lcd = strike.getAAMode() == 1 && FTFactory.LCD_SUPPORT;
        int flags = 14;
        FT_Matrix matrix = strike.matrix;
        if (matrix != null) {
            OSFreetype.FT_Set_Transform(this.face, matrix, 0L, 0L);
        } else {
            flags |= 0x800;
        }
        flags = lcd ? (flags |= 0x30000) : (flags |= 0);
        int glyphCode = glyph.getGlyphCode();
        int error = OSFreetype.FT_Load_Glyph(this.face, glyphCode, flags);
        if (error != 0) {
            if (PrismFontFactory.debugFonts) {
                System.err.println("FT_Load_Glyph failed " + error + " glyph code " + glyphCode + " load falgs " + flags);
            }
            return;
        }
        FT_GlyphSlotRec glyphRec = OSFreetype.getGlyphSlot(this.face);
        if (glyphRec == null) {
            return;
        }
        FT_Bitmap bitmap = glyphRec.bitmap;
        if (bitmap == null) {
            return;
        }
        byte pixelMode = bitmap.pixel_mode;
        int width = bitmap.width;
        int height = bitmap.rows;
        int pitch = bitmap.pitch;
        if (pixelMode != 2 && pixelMode != 5) {
            if (PrismFontFactory.debugFonts) {
                System.err.println("Unexpected pixel mode: " + pixelMode + " glyph code " + glyphCode + " load falgs " + flags);
            }
            return;
        }
        if (width != 0 && height != 0) {
            buffer = OSFreetype.getBitmapData(this.face);
            if (buffer != null && pitch != width) {
                byte[] newBuffer = new byte[width * height];
                int src = 0;
                int dst = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        newBuffer[dst + x] = buffer[src + x];
                    }
                    dst += width;
                    src += pitch;
                }
                buffer = newBuffer;
            }
        } else {
            buffer = new byte[]{};
        }
        glyph.buffer = buffer;
        glyph.bitmap = bitmap;
        glyph.bitmap_left = glyphRec.bitmap_left;
        glyph.bitmap_top = glyphRec.bitmap_top;
        glyph.advanceX = (float)glyphRec.advance_x / 64.0f;
        glyph.advanceY = (float)glyphRec.advance_y / 64.0f;
        glyph.userAdvance = (float)glyphRec.linearHoriAdvance / 65536.0f;
        glyph.lcd = lcd;
    }
}

