/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs.remember;

import net.sourceforge.jnlp.security.dialogs.remember.ExecuteAppletAction;

public class SavedRememberAction {
    private final ExecuteAppletAction action;
    private final String savedValue;

    public SavedRememberAction(ExecuteAppletAction action, String savedValue) {
        this.action = action;
        this.savedValue = savedValue;
    }

    public ExecuteAppletAction getAction() {
        return this.action;
    }

    public String getSavedValue() {
        return this.savedValue;
    }

    public String toString() {
        return this.toShortString();
    }

    public String toLongString() {
        String s = this.sanitizeSavedValue();
        return this.action.toString() + "{" + s + "}";
    }

    private String sanitizeSavedValue() {
        String s = this.savedValue;
        if (this.savedValue == null || this.savedValue.trim().isEmpty()) {
            s = "";
        }
        return s;
    }

    public String toShortString() {
        String s = this.sanitizeSavedValue();
        return this.action.toChar() + "{" + s + "}";
    }

    public boolean isRemember() {
        return this.action == ExecuteAppletAction.ALWAYS || this.action == ExecuteAppletAction.NEVER;
    }
}

