/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.parosproxy.paros.core.scanner.MultipartParam;
import org.parosproxy.paros.network.HttpMessage;

public class MultipartFormParser {
    public static final String WWW_MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    private String boundary = null;
    private String encoding = "ISO-8859-1";
    private BufferedReader br = null;

    private MultipartFormParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MultipartFormParser(HttpMessage msg) throws IOException {
        String line;
        String contentType = msg.getRequestHeader().getHeader("Content-Type");
        if (contentType == null || !contentType.startsWith(WWW_MULTIPART_FORM_DATA)) throw new IOException("The request is not a multipart/form-data content");
        this.boundary = this.extractBoundary(contentType);
        if (this.boundary == null) throw new IOException("No boundary defined in the Content-type header");
        this.br = new BufferedReader(new StringReader(msg.getRequestBody().toString()));
        do {
            if ((line = this.br.readLine()) != null) continue;
            throw new IOException("Corrupt form data: premature ending");
        } while (!line.startsWith(this.boundary));
    }

    public String getBoundary() {
        return this.boundary;
    }

    public MultipartParam getNextParam() throws IOException {
        String line = this.br.readLine();
        if (line == null) {
            return null;
        }
        if (line.length() == 0) {
            return null;
        }
        MultipartParam param = new MultipartParam();
        while (line != null && line.length() > 0) {
            String nextLine = null;
            boolean getNextLine = true;
            while (getNextLine) {
                nextLine = this.br.readLine();
                if (nextLine != null && (nextLine.startsWith(" ") || nextLine.startsWith("\t"))) {
                    line = line + nextLine;
                    continue;
                }
                getNextLine = false;
            }
            param.addHeader(line);
            line = nextLine;
        }
        if (line == null) {
            return null;
        }
        line = this.br.readLine();
        StringBuilder value = new StringBuilder();
        boolean isNotFirst = false;
        while (!line.startsWith(this.boundary)) {
            if (isNotFirst) {
                value.append("\r\n");
            } else {
                isNotFirst = true;
            }
            value.append(line);
            line = this.br.readLine();
        }
        param.setContent(value.toString());
        return param;
    }

    private String extractBoundary(String line) {
        int index = line.lastIndexOf("boundary=");
        if (index == -1) {
            return null;
        }
        String token = line.substring(index + 9);
        if (token.charAt(0) == '\"') {
            index = token.lastIndexOf(34);
            token = token.substring(1, index);
        }
        token = "--" + token;
        return token;
    }
}

