/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.StringParameter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Security {
    public static final int secTypeInvalid = 0;
    public static final int secTypeNone = 1;
    public static final int secTypeVncAuth = 2;
    public static final int secTypeRA2 = 5;
    public static final int secTypeRA2ne = 6;
    public static final int secTypeSSPI = 7;
    public static final int secTypeSSPIne = 8;
    public static final int secTypeTight = 16;
    public static final int secTypeUltra = 17;
    public static final int secTypeTLS = 18;
    public static final int secTypeVeNCrypt = 19;
    public static final int secTypePlain = 256;
    public static final int secTypeTLSNone = 257;
    public static final int secTypeTLSVnc = 258;
    public static final int secTypeTLSPlain = 259;
    public static final int secTypeX509None = 260;
    public static final int secTypeX509Vnc = 261;
    public static final int secTypeX509Plain = 262;
    public static final int secTypeIdent = 265;
    public static final int secTypeTLSIdent = 266;
    public static final int secTypeX509Ident = 267;
    public static final int secResultOK = 0;
    public static final int secResultFailed = 1;
    public static final int secResultTooMany = 2;
    private List<Integer> enabledSecTypes = new ArrayList<Integer>();
    static LogWriter vlog = new LogWriter("Security");

    public Security() {
    }

    public Security(StringParameter stringParameter) {
        String string = stringParameter.getData();
        this.enabledSecTypes = Security.parseSecTypes(string);
        string = null;
    }

    public final List<Integer> GetEnabledSecTypes() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int n : this.enabledSecTypes) {
            if (n < 256) continue;
            arrayList.add(19);
            break;
        }
        for (int n : this.enabledSecTypes) {
            if (n >= 256) continue;
            arrayList.add(n);
        }
        return arrayList;
    }

    public final List<Integer> GetEnabledExtSecTypes() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int n : this.enabledSecTypes) {
            if (n == 19) continue;
            arrayList.add(n);
        }
        return arrayList;
    }

    public final void EnableSecType(int n) {
        Iterator<Integer> iterator = this.enabledSecTypes.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != n) continue;
            return;
        }
        this.enabledSecTypes.add(n);
    }

    public boolean IsSupported(int n) {
        Iterator<Integer> iterator = this.enabledSecTypes.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != n) continue;
            return true;
        }
        return n == 19;
    }

    public String ToString() {
        String string = new String("");
        boolean bl = true;
        Iterator<Integer> iterator = this.enabledSecTypes.iterator();
        while (iterator.hasNext()) {
            String string2 = Security.secTypeName(iterator.next());
            if (string2.startsWith("[")) continue;
            if (!bl) {
                string = string.concat(",");
            } else {
                bl = false;
            }
            string = string.concat(string2);
        }
        return string;
    }

    public void DisableSecType(int n) {
        this.enabledSecTypes.remove((Object)n);
    }

    public static int secTypeNum(String string) {
        if (string.equalsIgnoreCase("None")) {
            return 1;
        }
        if (string.equalsIgnoreCase("VncAuth")) {
            return 2;
        }
        if (string.equalsIgnoreCase("Tight")) {
            return 16;
        }
        if (string.equalsIgnoreCase("RA2")) {
            return 5;
        }
        if (string.equalsIgnoreCase("RA2ne")) {
            return 6;
        }
        if (string.equalsIgnoreCase("SSPI")) {
            return 7;
        }
        if (string.equalsIgnoreCase("SSPIne")) {
            return 8;
        }
        if (string.equalsIgnoreCase("VeNCrypt")) {
            return 19;
        }
        if (string.equalsIgnoreCase("Plain")) {
            return 256;
        }
        if (string.equalsIgnoreCase("Ident")) {
            return 265;
        }
        if (string.equalsIgnoreCase("TLSNone")) {
            return 257;
        }
        if (string.equalsIgnoreCase("TLSVnc")) {
            return 258;
        }
        if (string.equalsIgnoreCase("TLSPlain")) {
            return 259;
        }
        if (string.equalsIgnoreCase("TLSIdent")) {
            return 266;
        }
        if (string.equalsIgnoreCase("X509None")) {
            return 260;
        }
        if (string.equalsIgnoreCase("X509Vnc")) {
            return 261;
        }
        if (string.equalsIgnoreCase("X509Plain")) {
            return 262;
        }
        if (string.equalsIgnoreCase("X509Ident")) {
            return 267;
        }
        return 0;
    }

    public static String secTypeName(int n) {
        switch (n) {
            case 1: {
                return "None";
            }
            case 2: {
                return "VncAuth";
            }
            case 16: {
                return "Tight";
            }
            case 5: {
                return "RA2";
            }
            case 6: {
                return "RA2ne";
            }
            case 7: {
                return "SSPI";
            }
            case 8: {
                return "SSPIne";
            }
            case 19: {
                return "VeNCrypt";
            }
            case 256: {
                return "Plain";
            }
            case 265: {
                return "Ident";
            }
            case 257: {
                return "TLSNone";
            }
            case 258: {
                return "TLSVnc";
            }
            case 259: {
                return "TLSPlain";
            }
            case 266: {
                return "TLSIdent";
            }
            case 260: {
                return "X509None";
            }
            case 261: {
                return "X509Vnc";
            }
            case 262: {
                return "X509Plain";
            }
            case 267: {
                return "X509Ident";
            }
        }
        return "[unknown secType]";
    }

    public static final List<Integer> parseSecTypes(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            int n = Security.secTypeNum(stringArray[i]);
            if (n == 0) continue;
            arrayList.add(n);
        }
        return arrayList;
    }

    public final void SetSecTypes(List<Integer> list) {
        this.enabledSecTypes = list;
    }
}

