/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;
import org.sejda.io.BaseSeekableSource;
import org.sejda.io.SeekableSource;
import org.sejda.io.SeekableSourceView;
import org.sejda.util.RequireUtils;

public class ByteArraySeekableSource
extends BaseSeekableSource {
    private byte[] bytes;
    private long position;

    public ByteArraySeekableSource(byte[] bytes) {
        super(Optional.ofNullable(bytes).map(UUID::nameUUIDFromBytes).map(UUID::toString).orElseThrow(() -> new IllegalArgumentException("Input byte array cannot be null")));
        this.bytes = bytes;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public SeekableSource position(long position) {
        RequireUtils.requireArg(position >= 0L, "Cannot set position to a negative value");
        this.position = Math.min(position, this.size());
        return this;
    }

    @Override
    public long size() {
        return this.bytes.length;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.requireOpen();
        if (this.position < this.size()) {
            int toCopy = (int)Math.min((long)dst.remaining(), this.size() - this.position);
            dst.put(this.bytes, (int)this.position, toCopy);
            this.position += (long)toCopy;
            return toCopy;
        }
        return -1;
    }

    @Override
    public int read() throws IOException {
        this.requireOpen();
        if (this.position < this.size()) {
            return this.bytes[(int)this.position++] & 0xFF;
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.bytes = new byte[0];
    }

    @Override
    public SeekableSource view(long startingPosition, long length) throws IOException {
        this.requireOpen();
        return new SeekableSourceView(() -> new ByteArraySeekableSource(this.bytes), this.id(), startingPosition, length);
    }
}

