/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.constraints.impl;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.validator.constraints.SafeHtml;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafeHtmlValidator
implements ConstraintValidator<SafeHtml, CharSequence> {
    private Whitelist whitelist;

    public void initialize(SafeHtml constraintAnn) {
        switch (constraintAnn.whitelistType()) {
            case BASIC: {
                this.whitelist = Whitelist.basic();
                break;
            }
            case BASIC_WITH_IMAGES: {
                this.whitelist = Whitelist.basicWithImages();
                break;
            }
            case NONE: {
                this.whitelist = Whitelist.none();
                break;
            }
            case RELAXED: {
                this.whitelist = Whitelist.relaxed();
                break;
            }
            case SIMPLE_TEXT: {
                this.whitelist = Whitelist.simpleText();
            }
        }
        this.whitelist.addTags(constraintAnn.additionalTags());
    }

    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        return Jsoup.isValid((String)((Object)value).toString(), (Whitelist)this.whitelist);
    }
}

