/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.prefix.processor;

import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.core.support.prefix.processor.PrefixProcessor;

class BaseBookmarkPrefixProcessor
implements PrefixProcessor {
    private String prefixNameRegex;
    private String toBeReplacedRegex;

    BaseBookmarkPrefixProcessor(String prefixNameRegex, String toBeReplacedRegex) {
        this.prefixNameRegex = prefixNameRegex;
        this.toBeReplacedRegex = toBeReplacedRegex;
    }

    @Override
    public String process(String inputPrefix, NameGenerationRequest request) {
        String bookmarkName;
        String retVal = inputPrefix;
        if (request != null && StringUtils.isNotBlank((CharSequence)request.getBookmark()) && StringUtils.isNotBlank((CharSequence)(bookmarkName = request.getBookmark().replaceAll(this.toBeReplacedRegex, "")))) {
            return retVal.replaceAll(this.prefixNameRegex, Matcher.quoteReplacement(bookmarkName));
        }
        return retVal;
    }
}

