##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Auxiliary

  def initialize
    super(
      'Name'         => 'VSploit Mariposa DNS Query Module',
      'Description'  => 'This module queries known Mariposa Botnet DNS records.',
      'Author'       => 'MJC',
      'License'      => MSF_LICENSE,
      'References'   =>
        [
          [ 'URL', 'http://www.defintel.com/docs/Mariposa_Analysis.pdf']
        ]
    )
    register_options(
      [
        OptString.new('DNS_SERVER',[false, "Specifies a DNS Server"]),
        OptInt.new('COUNT', [false, "Number of intervals to loop",1]),
        OptInt.new('DELAY', [false, "Delay in seconds between intervals",3])
    ])
  end

  def run
    @res = Net::DNS::Resolver.new()

    domain = [
    "lalundelau.sinip.es","bf2back.sinip.es","thejacksonfive.mobi",
    "thejacksonfive.us","thejacksonfive.biz","butterfly.BigMoney.biz",
    "bfisback.sinip.es","bfisback.no-ip.org","qwertasdfg.sinip.es",
    "shv4b.getmyip.com","shv4.no-ip.biz","butterfly.sinip.es",
    "defintelsucks.sinip.es","defintelsucks.net","defintelsucks.com",
    "gusanodeseda.sinip.es","gusanodeseda.net","legion.sinip.es",
    "booster.estr.es","sexme.in","extraperlo.biz",
    "legionarios.servecounterstrike.com","thesexydude.com",
    "yougotissuez.com","gusanodeseda.mobi","tamiflux.org",
    "tamiflux.net","binaryfeed.in","youare.sexidude.com",
    "mierda.notengodominio.com",
    ]

    if datastore['DNS_SERVER']
      @res.nameservers = datastore['DNS_SERVER']
    end

    count = 0

    while count < datastore['COUNT']

      domain.each do |name|
        query = @res.query(name, "A")
        time = Time.new
        time = time.strftime("%Y-%m-%d %H:%M:%S")
        print_status("#{time} - DNS Query sent for => #{name}")
        if query.answer.length == 0
          print_error("#{time} - #{name} => No Record Found")
        else
          a = query.answer[0].to_s.split(/[\s,]+/)
          print_good("#{time} - #{name} => #{a[-1]}")
        end
      end
      unless count == (datastore['COUNT'] - 1)
        time = Time.new
        time = time.strftime("%Y-%m-%d %H:%M:%S")
        print_status("#{time} - Waiting #{datastore['DELAY']} seconds to query")
        select(nil, nil, nil, datastore['DELAY'])
      end
      count += 1
    end
  end
end
