/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinClassStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.Utils;

public class KtClassElementType
extends KtStubElementType<KotlinClassStub, KtClass> {
    public KtClassElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            KtClassElementType.$$$reportNull$$$0(0);
        }
        super(debugName, KtClass.class, KotlinClassStub.class);
    }

    @Override
    @NotNull
    public KtClass createPsi(@NotNull KotlinClassStub stub) {
        if (stub == null) {
            KtClassElementType.$$$reportNull$$$0(1);
        }
        KtClass ktClass = !stub.isEnumEntry() ? new KtClass(stub) : new KtEnumEntry(stub);
        if (ktClass == null) {
            KtClassElementType.$$$reportNull$$$0(2);
        }
        return ktClass;
    }

    @Override
    @NotNull
    public KtClass createPsiFromAst(@NotNull ASTNode node) {
        if (node == null) {
            KtClassElementType.$$$reportNull$$$0(3);
        }
        KtClass ktClass = node.getElementType() != KtStubElementTypes.ENUM_ENTRY ? new KtClass(node) : new KtEnumEntry(node);
        if (ktClass == null) {
            KtClassElementType.$$$reportNull$$$0(4);
        }
        return ktClass;
    }

    @Override
    @NotNull
    public KotlinClassStub createStub(@NotNull KtClass psi, StubElement parentStub) {
        if (psi == null) {
            KtClassElementType.$$$reportNull$$$0(5);
        }
        FqName fqName2 = KtPsiUtilKt.safeFqNameForLazyResolve(psi);
        boolean isEnumEntry = psi instanceof KtEnumEntry;
        List<String> superNames = KtPsiUtilKt.getSuperNames(psi);
        KotlinClassStubImpl kotlinClassStubImpl = new KotlinClassStubImpl(KtClassElementType.getStubType(isEnumEntry), parentStub, StringRef.fromString(fqName2 != null ? fqName2.asString() : null), StringRef.fromString(psi.getName()), Utils.INSTANCE.wrapStrings(superNames), psi.isInterface(), isEnumEntry, psi.isLocal(), psi.isTopLevel());
        if (kotlinClassStubImpl == null) {
            KtClassElementType.$$$reportNull$$$0(6);
        }
        return kotlinClassStubImpl;
    }

    @Override
    public void serialize(@NotNull KotlinClassStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            KtClassElementType.$$$reportNull$$$0(7);
        }
        if (dataStream == null) {
            KtClassElementType.$$$reportNull$$$0(8);
        }
        dataStream.writeName(stub.getName());
        FqName fqName2 = stub.getFqName();
        dataStream.writeName(fqName2 == null ? null : fqName2.asString());
        dataStream.writeBoolean(stub.isInterface());
        dataStream.writeBoolean(stub.isEnumEntry());
        dataStream.writeBoolean(stub.isLocal());
        dataStream.writeBoolean(stub.isTopLevel());
        List<String> superNames = stub.getSuperNames();
        dataStream.writeVarInt(superNames.size());
        for (String name : superNames) {
            dataStream.writeName(name);
        }
    }

    @Override
    @NotNull
    public KotlinClassStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            KtClassElementType.$$$reportNull$$$0(9);
        }
        StringRef name = dataStream.readName();
        StringRef qualifiedName = dataStream.readName();
        boolean isTrait = dataStream.readBoolean();
        boolean isEnumEntry = dataStream.readBoolean();
        boolean isLocal = dataStream.readBoolean();
        boolean isTopLevel = dataStream.readBoolean();
        int superCount = dataStream.readVarInt();
        StringRef[] superNames = StringRef.createArray(superCount);
        for (int i = 0; i < superCount; ++i) {
            superNames[i] = dataStream.readName();
        }
        KotlinClassStubImpl kotlinClassStubImpl = new KotlinClassStubImpl(KtClassElementType.getStubType(isEnumEntry), parentStub, qualifiedName, name, superNames, isTrait, isEnumEntry, isLocal, isTopLevel);
        if (kotlinClassStubImpl == null) {
            KtClassElementType.$$$reportNull$$$0(10);
        }
        return kotlinClassStubImpl;
    }

    @Override
    public void indexStub(@NotNull KotlinClassStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            KtClassElementType.$$$reportNull$$$0(11);
        }
        if (sink == null) {
            KtClassElementType.$$$reportNull$$$0(12);
        }
        StubIndexService.getInstance().indexClass(stub, sink);
    }

    public static KtClassElementType getStubType(boolean isEnumEntry) {
        return isEnumEntry ? KtStubElementTypes.ENUM_ENTRY : KtStubElementTypes.CLASS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/stubs/elements/KtClassElementType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/stubs/elements/KtClassElementType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPsi";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPsiFromAst";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPsiFromAst";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

