'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeInterpreter = undefined;

var _regenerator = require('babel-runtime/regenerator');

var _regenerator2 = _interopRequireDefault(_regenerator);

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _asyncToGenerator2 = require('babel-runtime/helpers/asyncToGenerator');

var _asyncToGenerator3 = _interopRequireDefault(_asyncToGenerator2);

var initializeInterpreter = exports.initializeInterpreter = function () {
  var _ref = (0, _asyncToGenerator3.default)( /*#__PURE__*/_regenerator2.default.mark(function _callee2(kfetch, typesRegistry, functionsRegistry) {
    var _this = this;

    var serverFunctionList, types, _serializeProvider, serialize, batch, interpretAst;

    return _regenerator2.default.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return kfetch({ pathname: _consts.FUNCTIONS_URL });

          case 2:
            serverFunctionList = _context2.sent;
            types = typesRegistry.toJS();
            _serializeProvider = (0, _serialize.serializeProvider)(types), serialize = _serializeProvider.serialize;
            batch = (0, _batched_fetch.batchedFetch)({ kfetch: kfetch, serialize: serialize });

            // For every sever-side function, register a client-side
            // function that matches its definition, but which simply
            // calls the server-side function endpoint.

            Object.keys(serverFunctionList).forEach(function (functionName) {
              functionsRegistry.register(function () {
                return (0, _extends3.default)({}, serverFunctionList[functionName], {
                  fn: function fn(context, args) {
                    return batch({ functionName: functionName, args: args, context: context });
                  }
                });
              });
            });

            interpretAst = function () {
              var _ref2 = (0, _asyncToGenerator3.default)( /*#__PURE__*/_regenerator2.default.mark(function _callee(ast, context, handlers) {
                var interpretFn;
                return _regenerator2.default.wrap(function _callee$(_context) {
                  while (1) {
                    switch (_context.prev = _context.next) {
                      case 0:
                        _context.next = 2;
                        return (0, _interpret.interpreterProvider)({
                          types: typesRegistry.toJS(),
                          handlers: (0, _extends3.default)({}, handlers, (0, _create_handlers.createHandlers)()),
                          functions: functionsRegistry.toJS()
                        });

                      case 2:
                        interpretFn = _context.sent;
                        return _context.abrupt('return', interpretFn(ast, context));

                      case 4:
                      case 'end':
                        return _context.stop();
                    }
                  }
                }, _callee, _this);
              }));

              return function interpretAst(_x4, _x5, _x6) {
                return _ref2.apply(this, arguments);
              };
            }();

            return _context2.abrupt('return', { interpretAst: interpretAst });

          case 9:
          case 'end':
            return _context2.stop();
        }
      }
    }, _callee2, this);
  }));

  return function initializeInterpreter(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}(); /*
      * Licensed to Elasticsearch B.V. under one or more contributor
      * license agreements. See the NOTICE file distributed with
      * this work for additional information regarding copyright
      * ownership. Elasticsearch B.V. licenses this file to you under
      * the Apache License, Version 2.0 (the "License"); you may
      * not use this file except in compliance with the License.
      * You may obtain a copy of the License at
      *
      *    http://www.apache.org/licenses/LICENSE-2.0
      *
      * Unless required by applicable law or agreed to in writing,
      * software distributed under the License is distributed on an
      * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
      * KIND, either express or implied.  See the License for the
      * specific language governing permissions and limitations
      * under the License.
      */

var _interpret = require('../common/interpreter/interpret');

var _serialize = require('../common/lib/serialize');

var _create_handlers = require('./create_handlers');

var _batched_fetch = require('./batched_fetch');

var _consts = require('./consts');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }