/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.connection;

import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.connection.GradleConnection;
import org.gradle.tooling.connection.ModelResults;
import org.gradle.tooling.internal.connection.DefaultCompositeModelBuilder;
import org.gradle.tooling.internal.connection.GradleConnectionBuildLauncher;
import org.gradle.tooling.internal.consumer.CompositeConnectionParameters;
import org.gradle.tooling.internal.consumer.async.AsyncConsumerActionExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGradleConnection
implements GradleConnection {
    private final AsyncConsumerActionExecutor asyncConnection;
    private final CompositeConnectionParameters parameters;

    DefaultGradleConnection(AsyncConsumerActionExecutor asyncConnection, CompositeConnectionParameters parameters) {
        this.asyncConnection = asyncConnection;
        this.parameters = parameters;
    }

    @Override
    public <T> ModelResults<T> getModels(Class<T> modelType) throws GradleConnectionException, IllegalStateException {
        return this.models(modelType).get();
    }

    @Override
    public <T> void getModels(Class<T> modelType, ResultHandler<? super ModelResults<T>> handler) throws IllegalStateException {
        this.models(modelType).get(handler);
    }

    @Override
    public <T> ModelBuilder<ModelResults<T>> models(Class<T> modelType) {
        this.checkSupportedModelType(modelType);
        return new DefaultCompositeModelBuilder<T>(modelType, this.asyncConnection, this.parameters);
    }

    @Override
    public BuildLauncher newBuild() {
        return new GradleConnectionBuildLauncher(this.asyncConnection, this.parameters);
    }

    private <T> void checkSupportedModelType(Class<T> modelType) {
        if (!modelType.isInterface()) {
            throw new IllegalArgumentException(String.format("Cannot fetch a model of type '%s' as this type is not an interface.", modelType.getName()));
        }
    }

    @Override
    public void close() {
        this.asyncConnection.stop();
    }
}

