/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.io.File;
import java.util.Collections;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.process.internal.JavaForkOptionsInternal;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.KeepAliveMode;

public class DaemonForkOptionsBuilder {
    private final JavaForkOptionsInternal javaForkOptions;
    private final JavaForkOptionsFactory forkOptionsFactory;
    private Iterable<File> classpath = Collections.emptyList();
    private Iterable<String> sharedPackages = Collections.emptyList();
    private KeepAliveMode keepAliveMode = KeepAliveMode.DAEMON;

    public DaemonForkOptionsBuilder(JavaForkOptionsFactory forkOptionsFactory) {
        this.forkOptionsFactory = forkOptionsFactory;
        this.javaForkOptions = forkOptionsFactory.newJavaForkOptions();
    }

    public DaemonForkOptionsBuilder classpath(Iterable<File> classpath) {
        this.classpath = classpath;
        return this;
    }

    public DaemonForkOptionsBuilder sharedPackages(Iterable<String> sharedPackages) {
        this.sharedPackages = sharedPackages;
        return this;
    }

    public DaemonForkOptionsBuilder keepAliveMode(KeepAliveMode keepAliveMode) {
        this.keepAliveMode = keepAliveMode;
        return this;
    }

    public DaemonForkOptionsBuilder javaForkOptions(JavaForkOptions javaForkOptions) {
        javaForkOptions.copyTo((JavaForkOptions)this.javaForkOptions);
        return this;
    }

    public DaemonForkOptions build() {
        return new DaemonForkOptions(this.buildJavaForkOptions(), this.classpath, this.sharedPackages, this.keepAliveMode);
    }

    private JavaForkOptionsInternal buildJavaForkOptions() {
        return this.forkOptionsFactory.immutableCopy(this.javaForkOptions);
    }
}

