/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.ide.highlighter.JShellFileType;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.java.JShellLanguage;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiEmptyStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJShellFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJShellHolderMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiJShellRootClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiJavaFileBaseImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JShellElementType;
import org.jetbrains.kotlin.com.intellij.util.SmartList;

public class JShellFileImpl
extends PsiJavaFileBaseImpl
implements PsiJShellFile {
    private static final Condition<PsiElement> EXECUTABLE_PREDICATE = elem -> elem != null && !(elem instanceof PsiWhiteSpace) && !(elem instanceof PsiEmptyStatement) && !(elem instanceof PsiComment);

    public JShellFileImpl(FileViewProvider viewProvider) {
        super(JShellElementType.FILE, JShellElementType.FILE, viewProvider);
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JShellLanguage jShellLanguage = JShellLanguage.INSTANCE;
        if (jShellLanguage == null) {
            JShellFileImpl.$$$reportNull$$$0(0);
        }
        return jShellLanguage;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        JShellFileType jShellFileType = JShellFileType.INSTANCE;
        if (jShellFileType == null) {
            JShellFileImpl.$$$reportNull$$$0(1);
        }
        return jShellFileType;
    }

    @Override
    public boolean isPhysical() {
        return this.getViewProvider().isPhysical();
    }

    @Override
    public Collection<PsiElement> getExecutableSnippets() {
        SmartList<PsiElement> result2 = new SmartList<PsiElement>();
        JShellFileImpl.collectExecutableSnippets(this, result2);
        return result2;
    }

    private static void collectExecutableSnippets(PsiElement container2, Collection<? super PsiElement> result2) {
        for (PsiElement child = container2.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiJShellRootClass) {
                JShellFileImpl.collectExecutableSnippets(child, result2);
                continue;
            }
            if (!JShellFileImpl.isExecutable(child)) continue;
            result2.add(child);
        }
    }

    private static boolean isExecutable(PsiElement element) {
        if (element instanceof PsiJShellHolderMethod) {
            for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!EXECUTABLE_PREDICATE.value(child)) continue;
                return true;
            }
            return false;
        }
        return EXECUTABLE_PREDICATE.value(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/JShellFileImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

