# Upgrading to Sidekiq 3.0

Sidekiq 3.0 brings several new features but also removes old APIs and
changes a few data elements in Redis.  To upgrade cleanly:

* Upgrade to the latest Sidekiq 2.x and run it for a few weeks.
  `gem 'sidekiq', '< 3'`
  This is only needed if you have retries pending.
* 3rd party gems which use **client-side middleware** will need to update
  due to an API change.  The Redis connection for a particular job is
  passed thru the middleware to handle sharding where jobs can
  be pushed to different redis server instances.

  `def call(worker_class, msg, queue, redis_pool)`

  Client-side middleware should use `redis_pool.with { |conn| ... }` to
  perform Redis operations and **not** `Sidekiq.redis`.
* If you used the capistrano integration, you'll need to pull in the
  new [capistrano-sidekiq](https://github.com/seuros/capistrano-sidekiq)
  gem and use it in your deploy.rb.
* API changes:
  - `Sidekiq::Client.registered_workers` replaced by `Sidekiq::Workers.new`
  - `Sidekiq::Client.registered_queues` replaced by `Sidekiq::Queue.all`
  - `Sidekiq::Worker#retries_exhausted` replaced by `Sidekiq::Worker.sidekiq_retries_exhausted`
  - `Sidekiq::Workers#each` has changed significantly with a reworking
    of Sidekiq's internal process/thread data model.
* `sidekiq/api` is no longer automatically required.  If your code uses
  the API, you will need to require it.
* Redis-to-Go is no longer transparently activated on Heroku so as to not play
  favorites with any particular Redis service. You need to set a config option
  for your app:
  `heroku config:set REDIS_PROVIDER=REDISTOGO_URL`.  You may also use 
  the generic `REDIS_URL`.  See
  [Advanced Options: Setting the Location of your Redis server][1]
  for details.
* Anyone using Airbrake, Honeybadger, Exceptional or ExceptionNotifier
  will need to update their error gem version to the latest to pull in
  Sidekiq support.  Sidekiq will not provide explicit support for these
  services so as to not play favorites with any particular error service.
* MRI 1.9 is no longer officially supported.  Sidekiq's official
  support policy is to support the current and previous major releases
  of MRI and Rails.  As of February 2014, that's MRI 2.1, MRI 2.0, JRuby 1.7, Rails 4.0
  and Rails 3.2.  I will consider PRs to fix issues found by users for
  other platforms/versions.

## Error Service Providers

If you previously provided a middleware to capture job errors, you
should instead provide a global error handler with Sidekiq 3.0.  This
ensures **any** error within Sidekiq will be logged appropriately, not
just during job execution.

```ruby
if Sidekiq::VERSION < '3'
  # old behavior
  Sidekiq.configure_server do |config|
    config.server_middleware do |chain|
      chain.add MyErrorService::Middleware
    end
  end
else
  Sidekiq.configure_server do |config|
    config.error_handlers << proc {|ex,context| MyErrorService.notify(ex, context) }
  end
end
```

Your error handler must respond to `call(exception, context_hash)`.

[1]: https://github.com/mperham/sidekiq/wiki/Advanced-Options#via-env-variable
