/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.filters.plugin.graph;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.gephi.filters.plugin.graph.NeighborsBuilder;
import org.openide.util.NbBundle;

public class NeighborsPanel
extends JPanel {
    private NeighborsBuilder.NeighborsFilter neighborsFilter;
    private JComboBox depthComboBox;
    private JLabel labelDepth;
    private JCheckBox withSelfCheckbox;

    public NeighborsPanel() {
        this.initComponents();
        this.depthComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int depth = -1;
                int index = NeighborsPanel.this.depthComboBox.getSelectedIndex();
                depth = index == NeighborsPanel.this.depthComboBox.getModel().getSize() - 1 ? Integer.MAX_VALUE : index + 1;
                if (!NeighborsPanel.this.neighborsFilter.getDepth().equals(depth)) {
                    NeighborsPanel.this.neighborsFilter.getProperties()[0].setValue((Object)depth);
                }
            }
        });
        this.withSelfCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!NeighborsPanel.this.neighborsFilter.isSelf() == NeighborsPanel.this.withSelfCheckbox.isSelected()) {
                    NeighborsPanel.this.neighborsFilter.getProperties()[1].setValue((Object)NeighborsPanel.this.withSelfCheckbox.isSelected());
                }
            }
        });
    }

    public void setup(NeighborsBuilder.NeighborsFilter neighborsFilter) {
        this.neighborsFilter = neighborsFilter;
        int depth = neighborsFilter.getDepth();
        if (depth == Integer.MAX_VALUE) {
            this.depthComboBox.setSelectedIndex(this.depthComboBox.getModel().getSize() - 1);
        } else {
            this.depthComboBox.setSelectedIndex(depth - 1);
        }
        this.withSelfCheckbox.setSelected(neighborsFilter.isSelf());
    }

    private void initComponents() {
        this.labelDepth = new JLabel();
        this.depthComboBox = new JComboBox();
        this.withSelfCheckbox = new JCheckBox();
        this.labelDepth.setText(NbBundle.getMessage(NeighborsPanel.class, (String)"NeighborsPanel.labelDepth.text"));
        this.depthComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "Max"}));
        this.withSelfCheckbox.setText(NbBundle.getMessage(NeighborsPanel.class, (String)"NeighborsPanel.withSelfCheckbox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.labelDepth).addGap(23, 23, 23).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.withSelfCheckbox).addComponent(this.depthComboBox, -2, 70, -2)).addContainerGap(112, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.depthComboBox, -2, -1, -2).addComponent(this.labelDepth)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.withSelfCheckbox).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

