/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.lib.gleem.linalg;

import org.gephi.lib.gleem.linalg.IntersectionPoint;
import org.gephi.lib.gleem.linalg.MathUtil;
import org.gephi.lib.gleem.linalg.Vec2f;
import org.gephi.lib.gleem.linalg.Vec3f;

public class PlaneUV {
    private Vec3f origin = new Vec3f();
    private Vec3f normal = new Vec3f();
    private Vec3f uAxis = new Vec3f();
    private Vec3f vAxis = new Vec3f();

    public PlaneUV() {
        this.setEverything(new Vec3f(0.0f, 1.0f, 0.0f), new Vec3f(0.0f, 0.0f, 0.0f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(0.0f, 0.0f, -1.0f));
    }

    public PlaneUV(Vec3f normal, Vec3f origin) {
        this.setOrigin(origin);
        this.setNormal(normal);
    }

    public PlaneUV(Vec3f normal, Vec3f origin, Vec3f uAxis) {
        this.setOrigin(origin);
        this.setNormalAndU(normal, uAxis);
    }

    public PlaneUV(Vec3f normal, Vec3f origin, Vec3f uAxis, Vec3f vAxis) {
        this.setEverything(normal, origin, uAxis, vAxis);
    }

    public void setOrigin(Vec3f origin) {
        this.origin.set(origin);
    }

    public Vec3f getOrigin() {
        return new Vec3f(this.origin);
    }

    public void setNormalAndUV(Vec3f normal, Vec3f uAxis, Vec3f vAxis) {
        this.setEverything(normal, this.origin, uAxis, vAxis);
    }

    public void setNormal(Vec3f normal) {
        Vec3f uAxis = new Vec3f();
        MathUtil.makePerpendicular(normal, uAxis);
        Vec3f vAxis = normal.cross(uAxis);
        this.setEverything(normal, this.origin, uAxis, vAxis);
    }

    public void setNormalAndU(Vec3f normal, Vec3f uAxis) {
        Vec3f vAxis = normal.cross(uAxis);
        this.setEverything(normal, this.origin, uAxis, vAxis);
    }

    public Vec3f getNormal() {
        return this.normal;
    }

    public Vec3f getUAxis() {
        return this.uAxis;
    }

    public Vec3f getVAxis() {
        return this.vAxis;
    }

    public void projectPoint(Vec3f point, Vec3f projPt, Vec2f uvCoords) {
        projPt.sub(point, this.origin);
        float dotp = this.normal.dot(projPt);
        Vec3f tmpDir = new Vec3f();
        tmpDir.set(this.normal);
        tmpDir.scale(dotp);
        projPt.sub(projPt, tmpDir);
        uvCoords.set(projPt.dot(this.uAxis), projPt.dot(this.vAxis));
        projPt.add(this.origin);
    }

    public boolean intersectRay(Vec3f rayStart, Vec3f rayDirection, IntersectionPoint intPt, Vec2f uvCoords) {
        float denom = rayDirection.dot(this.normal);
        if (denom == 0.0f) {
            return false;
        }
        Vec3f tmpDir = new Vec3f();
        tmpDir.sub(this.origin, rayStart);
        float t = tmpDir.dot(this.normal) / denom;
        Vec3f tmpPt = new Vec3f();
        tmpPt.set(rayDirection);
        tmpPt.scale(t);
        tmpPt.add(rayStart);
        intPt.setIntersectionPoint(tmpPt);
        intPt.setT(t);
        tmpDir.sub(intPt.getIntersectionPoint(), this.origin);
        uvCoords.set(tmpDir.dot(this.uAxis), tmpDir.dot(this.vAxis));
        return true;
    }

    private void setEverything(Vec3f normal, Vec3f origin, Vec3f uAxis, Vec3f vAxis) {
        this.normal.set(normal);
        this.origin.set(origin);
        this.uAxis.set(uAxis);
        this.vAxis.set(vAxis);
        this.normal.normalize();
        this.uAxis.normalize();
        this.vAxis.normalize();
    }
}

