define(["require","globalize","appSettings","apphost","focusManager","loading","connectionManager","subtitleAppearanceHelper","dom","events","listViewStyle","emby-select","emby-input","emby-checkbox","flexStyles"],function(require,globalize,appSettings,appHost,focusManager,loading,connectionManager,subtitleAppearanceHelper,dom,events){"use strict";function populateLanguages(select,languages){var html="";html+="<option value=''>"+globalize.translate("AnyLanguage")+"</option>";for(var i=0,length=languages.length;i<length;i++){var culture=languages[i];html+="<option value='"+culture.ThreeLetterISOLanguageName+"'>"+culture.DisplayName+"</option>"}select.innerHTML=html}function getSubtitleAppearanceObject(context){var appearanceSettings={};return appearanceSettings.textSize=context.querySelector("#selectTextSize").value,appearanceSettings.dropShadow=context.querySelector("#selectDropShadow").value,appearanceSettings.textBackground=context.querySelector("#inputTextBackground").value,appearanceSettings.textColor=context.querySelector("#inputTextColor").value,appearanceSettings}function loadForm(context,user,userSettings,appearanceSettings,apiClient){apiClient.getCultures().then(function(allCultures){appHost.supports("subtitleburnsettings")&&user.Policy.EnableVideoPlaybackTranscoding&&context.querySelector(".fldBurnIn").classList.remove("hide");var selectSubtitleLanguage=context.querySelector("#selectSubtitleLanguage");populateLanguages(selectSubtitleLanguage,allCultures),selectSubtitleLanguage.value=user.Configuration.SubtitleLanguagePreference||"",context.querySelector("#selectSubtitlePlaybackMode").value=user.Configuration.SubtitleMode||"",context.querySelector("#selectSubtitlePlaybackMode").dispatchEvent(new CustomEvent("change",{})),context.querySelector("#selectTextSize").value=appearanceSettings.textSize||"",context.querySelector("#selectDropShadow").value=appearanceSettings.dropShadow||"",context.querySelector("#inputTextBackground").value=appearanceSettings.textBackground||"transparent",context.querySelector("#inputTextColor").value=appearanceSettings.textColor||"#ffffff",context.querySelector("#selectSubtitleBurnIn").value=appSettings.get("subtitleburnin")||"",onAppearanceFieldChange({target:context.querySelector("#selectTextSize")}),loading.hide()})}function saveUser(context,user,userSettingsInstance,appearanceKey,apiClient){var appearanceSettings=userSettingsInstance.getSubtitleAppearanceSettings(appearanceKey);return appearanceSettings=Object.assign(appearanceSettings,getSubtitleAppearanceObject(context)),userSettingsInstance.setSubtitleAppearanceSettings(appearanceSettings,appearanceKey),user.Configuration.SubtitleLanguagePreference=context.querySelector("#selectSubtitleLanguage").value,user.Configuration.SubtitleMode=context.querySelector("#selectSubtitlePlaybackMode").value,apiClient.updateUserConfiguration(user.Id,user.Configuration)}function save(instance,context,userId,userSettings,apiClient,enableSaveConfirmation){loading.show(),appSettings.set("subtitleburnin",context.querySelector("#selectSubtitleBurnIn").value),apiClient.getUser(userId).then(function(user){saveUser(context,user,userSettings,instance.appearanceKey,apiClient).then(function(){loading.hide(),enableSaveConfirmation&&require(["toast"],function(toast){toast(globalize.translate("SettingsSaved"))}),events.trigger(instance,"saved")},function(){loading.hide()})})}function onSubmit(e){var self=this,apiClient=connectionManager.getApiClient(self.options.serverId),userId=self.options.userId,userSettings=self.options.userSettings;return userSettings.setUserInfo(userId,apiClient).then(function(){var enableSaveConfirmation=self.options.enableSaveConfirmation;save(self,self.options.element,userId,userSettings,apiClient,enableSaveConfirmation)}),e&&e.preventDefault(),!1}function onSubtitleModeChange(e){for(var view=dom.parentWithClass(e.target,"subtitlesettings"),subtitlesHelp=view.querySelectorAll(".subtitlesHelp"),i=0,length=subtitlesHelp.length;i<length;i++)subtitlesHelp[i].classList.add("hide");view.querySelector(".subtitles"+this.value+"Help").classList.remove("hide")}function onAppearanceFieldChange(e){var view=dom.parentWithClass(e.target,"subtitlesettings"),appearanceSettings=getSubtitleAppearanceObject(view),elements={window:view.querySelector(".subtitleappearance-preview-window"),text:view.querySelector(".subtitleappearance-preview-text")};subtitleAppearanceHelper.applyStyles(elements,appearanceSettings)}function embed(options,self){require(["text!./subtitlesettings.template.html"],function(template){options.element.classList.add("subtitlesettings"),options.element.innerHTML=globalize.translateDocument(template,"sharedcomponents"),options.element.querySelector("form").addEventListener("submit",onSubmit.bind(self)),options.element.querySelector("#selectSubtitlePlaybackMode").addEventListener("change",onSubtitleModeChange),options.element.querySelector("#selectTextSize").addEventListener("change",onAppearanceFieldChange),options.element.querySelector("#selectDropShadow").addEventListener("change",onAppearanceFieldChange),options.element.querySelector("#inputTextColor").addEventListener("change",onAppearanceFieldChange),options.element.querySelector("#inputTextBackground").addEventListener("change",onAppearanceFieldChange),options.enableSaveButton&&options.element.querySelector(".btnSave").classList.remove("hide"),appHost.supports("subtitleappearancesettings")&&options.element.querySelector(".subtitleAppearanceSection").classList.remove("hide"),self.loadData(),options.autoFocus&&focusManager.autoFocus(options.element)})}function SubtitleSettings(options){this.options=options,embed(options,this)}return SubtitleSettings.prototype.loadData=function(){var self=this,context=self.options.element;loading.show();var userId=self.options.userId,apiClient=connectionManager.getApiClient(self.options.serverId),userSettings=self.options.userSettings;apiClient.getUser(userId).then(function(user){userSettings.setUserInfo(userId,apiClient).then(function(){self.dataLoaded=!0;var appearanceSettings=userSettings.getSubtitleAppearanceSettings(self.options.appearanceKey);loadForm(context,user,userSettings,appearanceSettings,apiClient)})})},SubtitleSettings.prototype.submit=function(){onSubmit.call(this)},SubtitleSettings.prototype.destroy=function(){this.options=null},SubtitleSettings});