/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.ui.palette.customize.PaletteCustomizerDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.common.snippets.core.ISnippetProvider;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItem;
import org.eclipse.wst.common.snippets.internal.ui.SnippetsView;
import org.eclipse.wst.common.snippets.internal.util.SnippetProviderManager;
import org.eclipse.wst.common.snippets.internal.util.UserDrawerSelector;

public class AddToSnippetsEditorActionDelegate
implements IEditorActionDelegate,
IViewActionDelegate {
    private IEditorPart fEditorPart;
    private ISnippetProvider snippetProvider;

    public IDocument getDocument() {
        return this.getTextEditor().getDocumentProvider().getDocument((Object)this.fEditorPart.getEditorInput());
    }

    protected ITextSelection getSelection() {
        ISelection selection;
        ITextEditor editor = this.getTextEditor();
        if (editor != null && (selection = editor.getSelectionProvider().getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return new TextSelection(0, 0);
    }

    protected ITextEditor getTextEditor() {
        ITextEditor editor = null;
        IEditorPart activePart = this.fEditorPart;
        if (activePart == null) {
            activePart = this.fEditorPart;
        }
        if (activePart instanceof ITextEditor) {
            editor = (ITextEditor)activePart;
        }
        if (editor == null) {
            editor = (ITextEditor)activePart.getAdapter(ITextEditor.class);
        }
        return editor;
    }

    protected PaletteDrawer getUserDrawer() {
        UserDrawerSelector selector = new UserDrawerSelector(this.fEditorPart.getEditorSite().getShell());
        PaletteDrawer drawer = selector.getUserDrawer();
        return drawer;
    }

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        PaletteDrawer drawer = this.getUserDrawer();
        if (drawer != null) {
            if (this.snippetProvider == null) {
                this.snippetProvider = SnippetProviderManager.getApplicableProvider(this.fEditorPart);
                if (this.snippetProvider == null) {
                    return;
                }
            }
            try {
                SnippetPaletteItem item = this.snippetProvider.createSnippet((PaletteEntry)drawer);
                IViewPart snippets = this.fEditorPart.getEditorSite().getPage().showView("org.eclipse.wst.common.snippets.internal.ui.SnippetsView");
                PaletteCustomizerDialog dialog = ((SnippetsView)snippets).getViewer().getCustomizerDialog();
                dialog.setDefaultSelection((PaletteEntry)item);
                dialog.open();
            }
            catch (PartInitException e) {
                Logger.logException(e);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection != null && this.fEditorPart != null && this.snippetProvider != null) {
            action.setEnabled(this.snippetProvider.isActionEnabled(selection));
        } else {
            action.setEnabled(false);
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.fEditorPart = targetEditor;
        action.setEnabled(this.fEditorPart != null);
        this.snippetProvider = this.fEditorPart != null ? SnippetProviderManager.getApplicableProvider(this.fEditorPart) : null;
    }
}

