/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.templates;

import java.io.IOException;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.templates.ICodeTemplateAccess;
import org.eclipse.dltk.ui.text.templates.ITemplateAccess;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;

public abstract class CodeTemplateAccess
implements ICodeTemplateAccess,
ITemplateAccess.ITemplateAccessInternal {
    private final String preferenceQualifier;
    private final String preferenceKey;
    private final IPreferenceStore preferenceStore;
    private ContextTypeRegistry fCodeTemplateContextTypeRegistry;
    private TemplateStore fCodeTemplateStore;

    protected CodeTemplateAccess(String preferenceQualifier, String preferenceKey, IPreferenceStore preferenceStore) {
        this.preferenceQualifier = preferenceQualifier;
        this.preferenceKey = preferenceKey;
        this.preferenceStore = preferenceStore;
    }

    @Override
    public TemplateStore getTemplateStore() {
        if (this.fCodeTemplateStore == null) {
            this.fCodeTemplateStore = new ContributionTemplateStore(this.getContextTypeRegistry(), this.preferenceStore, this.preferenceKey);
            try {
                this.fCodeTemplateStore.load();
            }
            catch (IOException e) {
                DLTKUIPlugin.log(e);
            }
            this.fCodeTemplateStore.startListeningForPreferenceChanges();
        }
        return this.fCodeTemplateStore;
    }

    @Override
    public IPreferenceStore getTemplatePreferenceStore() {
        return this.preferenceStore;
    }

    @Override
    public String getPreferenceQualifier() {
        return this.preferenceQualifier;
    }

    @Override
    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    @Override
    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.fCodeTemplateContextTypeRegistry == null) {
            this.fCodeTemplateContextTypeRegistry = this.createContextTypeRegistry();
        }
        return this.fCodeTemplateContextTypeRegistry;
    }

    protected abstract ContextTypeRegistry createContextTypeRegistry();

    @Override
    public void dispose() {
        if (this.fCodeTemplateStore != null) {
            this.fCodeTemplateStore.stopListeningForPreferenceChanges();
            this.fCodeTemplateStore = null;
        }
    }
}

