/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.launching;

import org.eclipse.cdt.debug.internal.ui.dialogfields.ComboDialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.debug.internal.ui.dialogfields.LayoutUtil;
import org.eclipse.cdt.debug.internal.ui.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.StringDialogField;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.GdbDebuggerPage;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.LaunchUIMessages;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.SerialPortSettingsBlock;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.TCPSettingsBlock;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class GdbServerDebuggerPage
extends GdbDebuggerPage {
    private static final String CONNECTION_TCP = LaunchUIMessages.getString("GDBServerDebuggerPage.0");
    private static final String CONNECTION_SERIAL = LaunchUIMessages.getString("GDBServerDebuggerPage.1");
    private ComboDialogField fConnectionField;
    protected SelectionButtonDialogField fRemoteTimeoutEnabledField;
    protected StringDialogField fRemoteTimeoutValueField;
    private String[] fConnections = new String[]{CONNECTION_TCP, CONNECTION_SERIAL};
    private TCPSettingsBlock fTCPBlock;
    private SerialPortSettingsBlock fSerialBlock;
    private Composite fConnectionStack;
    private boolean fIsInitializing = false;

    public GdbServerDebuggerPage() {
        this.fConnectionField = this.createConnectionField();
        this.fTCPBlock = new TCPSettingsBlock();
        this.fSerialBlock = new SerialPortSettingsBlock();
        this.fTCPBlock.addObserver(this);
        this.fSerialBlock.addObserver(this);
        this.createRemoteTimeoutFields();
    }

    protected void createConnectionTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(LaunchUIMessages.getString("GDBServerDebuggerPage.10"));
        Composite comp1 = ControlFactory.createCompositeEx((Composite)tabFolder, (int)1, (int)1808);
        ((GridLayout)comp1.getLayout()).makeColumnsEqualWidth = false;
        comp1.setFont(tabFolder.getFont());
        tabItem.setControl((Control)comp1);
        Composite comp = ControlFactory.createCompositeEx((Composite)comp1, (int)3, (int)1808);
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        comp.setFont(comp1.getFont());
        this.fConnectionField.doFillIntoGrid(comp, 3);
        ((GridData)this.fConnectionField.getComboControl(null).getLayoutData()).horizontalAlignment = 1;
        this.fRemoteTimeoutEnabledField.doFillIntoGrid(comp, 1);
        this.fRemoteTimeoutEnabledField.getSelectionButton(comp).setToolTipText(LaunchUIMessages.getString("GDBServerDebuggerPage.12"));
        this.fRemoteTimeoutValueField.doFillIntoGrid(comp, 2);
        ((GridData)this.fRemoteTimeoutValueField.getTextControl(null).getLayoutData()).horizontalAlignment = 1;
        PixelConverter converter = new PixelConverter((Control)comp);
        LayoutUtil.setWidthHint((Control)this.fRemoteTimeoutValueField.getTextControl(null), (int)converter.convertWidthInCharsToPixels(10));
        this.fRemoteTimeoutValueField.getLabelControl(comp).setToolTipText(LaunchUIMessages.getString("GDBServerDebuggerPage.12"));
        this.fRemoteTimeoutValueField.getTextControl(comp).setToolTipText(LaunchUIMessages.getString("GDBServerDebuggerPage.12"));
        this.fConnectionStack = ControlFactory.createCompositeEx((Composite)comp, (int)1, (int)1808);
        StackLayout stackLayout = new StackLayout();
        this.fConnectionStack.setLayout((Layout)stackLayout);
        ((GridData)this.fConnectionStack.getLayoutData()).horizontalSpan = 3;
        this.fTCPBlock.createBlock(this.fConnectionStack);
        this.fSerialBlock.createBlock(this.fConnectionStack);
    }

    private ComboDialogField createConnectionField() {
        ComboDialogField field = new ComboDialogField(12);
        field.setLabelText(LaunchUIMessages.getString("GDBServerDebuggerPage.9"));
        field.setItems(this.fConnections);
        field.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField f) {
                if (!GdbServerDebuggerPage.this.isInitializing()) {
                    GdbServerDebuggerPage.this.connectionTypeChanged();
                }
            }
        });
        return field;
    }

    private void createRemoteTimeoutFields() {
        this.fRemoteTimeoutEnabledField = new SelectionButtonDialogField(32);
        this.fRemoteTimeoutEnabledField.setLabelText(LaunchUIMessages.getString("GDBServerDebuggerPage.11"));
        this.fRemoteTimeoutEnabledField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField f) {
                GdbServerDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.fRemoteTimeoutValueField = new StringDialogField();
        this.fRemoteTimeoutValueField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField f) {
                GdbServerDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.fRemoteTimeoutEnabledField.attachDialogField((DialogField)this.fRemoteTimeoutValueField);
    }

    protected void connectionTypeChanged() {
        this.connectionTypeChanged0();
        this.updateLaunchConfigurationDialog();
    }

    private void connectionTypeChanged0() {
        ((StackLayout)this.fConnectionStack.getLayout()).topControl = null;
        int index = this.fConnectionField.getSelectionIndex();
        if (index >= 0 && index < this.fConnections.length) {
            String[] connTypes = this.fConnectionField.getItems();
            if (CONNECTION_TCP.equals(connTypes[index])) {
                ((StackLayout)this.fConnectionStack.getLayout()).topControl = this.fTCPBlock.getControl();
            } else if (CONNECTION_SERIAL.equals(connTypes[index])) {
                ((StackLayout)this.fConnectionStack.getLayout()).topControl = this.fSerialBlock.getControl();
            }
        }
        this.fConnectionStack.layout();
    }

    @Override
    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (super.isValid(launchConfig)) {
            this.setErrorMessage(null);
            this.setMessage(null);
            int index = this.fConnectionField.getSelectionIndex();
            if (index >= 0 && index < this.fConnections.length) {
                String[] connTypes = this.fConnectionField.getItems();
                if (CONNECTION_TCP.equals(connTypes[index])) {
                    if (!this.fTCPBlock.isValid(launchConfig)) {
                        this.setErrorMessage(this.fTCPBlock.getErrorMessage());
                        return false;
                    }
                } else if (CONNECTION_SERIAL.equals(connTypes[index]) && !this.fSerialBlock.isValid(launchConfig)) {
                    this.setErrorMessage(this.fSerialBlock.getErrorMessage());
                    return false;
                }
            }
            if (this.fRemoteTimeoutEnabledField.isSelected() && this.fRemoteTimeoutValueField.getText().trim().isEmpty()) {
                this.setErrorMessage(LaunchUIMessages.getString("GDBServerDebuggerPage.13"));
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setInitializing(true);
        super.initializeFrom(configuration);
        boolean isTcp = true;
        try {
            isTcp = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TCP", true);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.fTCPBlock.initializeFrom(configuration);
        this.fSerialBlock.initializeFrom(configuration);
        this.fConnectionField.selectItem(isTcp ? 0 : 1);
        this.initializeRemoteTimeout(configuration);
        this.connectionTypeChanged0();
        this.setInitializing(false);
    }

    private void initializeRemoteTimeout(ILaunchConfiguration configuration) {
        if (this.fRemoteTimeoutEnabledField != null && this.fRemoteTimeoutValueField != null) {
            try {
                this.fRemoteTimeoutEnabledField.setSelection(configuration.getAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TIMEOUT_ENABLED", LaunchUtils.getRemoteTimeoutEnabledDefault()));
                this.fRemoteTimeoutValueField.setText(configuration.getAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TIMEOUT_VALUE", LaunchUtils.getRemoteTimeoutValueDefault()));
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        if (this.fConnectionField != null) {
            configuration.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TCP", this.fConnectionField.getSelectionIndex() == 0);
        }
        this.fTCPBlock.performApply(configuration);
        this.fSerialBlock.performApply(configuration);
        if (this.fRemoteTimeoutEnabledField != null) {
            configuration.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TIMEOUT_ENABLED", this.fRemoteTimeoutEnabledField.isSelected());
        }
        if (this.fRemoteTimeoutValueField != null) {
            configuration.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TIMEOUT_VALUE", this.fRemoteTimeoutValueField.getText().trim());
        }
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TCP", true);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TIMEOUT_ENABLED", LaunchUtils.getRemoteTimeoutEnabledDefault());
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TIMEOUT_VALUE", LaunchUtils.getRemoteTimeoutValueDefault());
        this.fTCPBlock.setDefaults(configuration);
        this.fSerialBlock.setDefaults(configuration);
    }

    @Override
    protected boolean isInitializing() {
        return this.fIsInitializing;
    }

    private void setInitializing(boolean isInitializing) {
        this.fIsInitializing = isInitializing;
    }

    @Override
    public void createTabs(TabFolder tabFolder) {
        super.createTabs(tabFolder);
        this.createConnectionTab(tabFolder);
    }
}

