/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.traces;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IErrorBarPolicy;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePainter;
import info.monitorenter.gui.chart.TracePoint2D;
import info.monitorenter.gui.chart.traces.painters.TracePainterPolyline;
import info.monitorenter.util.MathUtil;
import info.monitorenter.util.StringUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.ChangeListener;
import javax.swing.event.SwingPropertyChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ATrace2D
implements ITrace2D,
Comparable<ITrace2D> {
    private static int instanceCount = 0;
    private List<ChangeListener> m_changeListeners = new LinkedList<ChangeListener>();
    private Color m_color = Color.black;
    protected List<ITrace2D> m_computingTraces = new LinkedList<ITrace2D>();
    private Set<IErrorBarPolicy> m_errorBarPolicies = new TreeSet<IErrorBarPolicy>();
    private boolean m_firsttime = true;
    protected double m_maxX;
    protected double m_maxXErrorBar = -1.7976931348623157E308;
    protected double m_maxY;
    protected double m_maxYErrorBar = -1.7976931348623157E308;
    protected double m_minX;
    protected double m_minXErrorBar = Double.MAX_VALUE;
    protected double m_minY;
    protected double m_minYErrorBar = Double.MAX_VALUE;
    protected String m_name = "";
    protected String m_physicalUnitsX = "";
    protected String m_physicalUnitsY = "";
    protected PropertyChangeSupport m_propertyChangeSupport = new SwingPropertyChangeSupport(this);
    protected Object m_renderer = new Object();
    private transient Stroke m_stroke;
    private Set<ITracePainter> m_tracePainters;
    private boolean m_visible = true;
    private Integer m_zIndex = 100;

    public ATrace2D() {
        ++instanceCount;
        this.m_tracePainters = new TreeSet<ITracePainter>();
        this.m_tracePainters.add(new TracePainterPolyline());
        this.m_stroke = new BasicStroke(1.0f);
    }

    public static int getInstanceCount() {
        return instanceCount;
    }

    @Override
    public void addComputingTrace(ITrace2D trace) {
        this.m_computingTraces.add(trace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean addErrorBarPolicy(IErrorBarPolicy errorBarPolicy) {
        boolean result = false;
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                result = this.m_errorBarPolicies.add(errorBarPolicy);
                if (result) {
                    errorBarPolicy.setTrace(this);
                    errorBarPolicy.addPropertyChangeListener("IErrorBarPolicy.PROPERTY_CONFIGURATION", this);
                    this.expandErrorBarBounds();
                    this.firePropertyChange("ITrace2D.PROPERTY_ERRORBARPOLICY", null, errorBarPolicy);
                }
            }
        }
        return result;
    }

    @Override
    public final boolean addPoint(double x, double y) {
        TracePoint2D p = new TracePoint2D(x, y);
        return this.addPoint(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean addPoint(TracePoint2D p) {
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                boolean accepted = this.addPointInternal(p);
                if (accepted) {
                    this.expandErrorBarBounds();
                    this.firePointAdded(p);
                    p.setListener(this);
                    if (this.m_computingTraces.size() > 0) {
                        for (ITrace2D trace : this.m_computingTraces) {
                            trace.addPoint(p);
                        }
                    }
                }
                if (this.m_firsttime) {
                    this.m_minX = p.getX();
                    this.m_minY = p.getY();
                    this.m_maxX = p.getX();
                    this.m_maxY = p.getY();
                    Double zero = new Double(0.0);
                    this.firePropertyChange("ITrace2D.PROPERTY_MIN_X", zero, new Double(this.m_minX));
                    this.firePropertyChange("ITrace2D.PROPERTY_MIN_Y", zero, new Double(this.m_minY));
                    this.m_firsttime = false;
                }
                return accepted;
            }
        }
    }

    @Override
    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.m_propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addTracePainter(ITracePainter painter) {
        boolean result = false;
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                result = this.m_tracePainters.add(painter);
                if (result) {
                    this.firePropertyChange("ITrace2D.PROPERTY_PAINTERS", null, painter);
                }
            }
        }
        return result;
    }

    @Override
    public int compareTo(ITrace2D o) {
        String me = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        String it = o.getClass().getName() + "@" + Integer.toHexString(o.hashCode());
        return me.compareTo(it);
    }

    @Override
    public boolean containsTracePainter(ITracePainter painter) {
        return this.m_tracePainters.contains(painter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void firePointChanged(TracePoint2D changed, int state) {
        double tmpx = changed.getX();
        double tmpy = changed.getY();
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                if (1 == state) {
                    if (tmpx > this.m_maxX) {
                        this.m_maxX = tmpx;
                        this.expandMaxXErrorBarBounds();
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_X", null, new Double(this.m_maxX));
                    } else if (tmpx < this.m_minX) {
                        this.m_minX = tmpx;
                        this.expandMinXErrorBarBounds();
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_X", null, new Double(this.m_minX));
                    }
                    if (tmpy > this.m_maxY) {
                        this.m_maxY = tmpy;
                        this.expandMaxYErrorBarBounds();
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_Y", null, new Double(this.m_maxY));
                    } else if (tmpy < this.m_minY) {
                        this.m_minY = tmpy;
                        this.expandMinYErrorBarBounds();
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_Y", null, new Double(this.m_minY));
                    }
                }
                if (2 == state) {
                    if (tmpx >= this.m_maxX) {
                        tmpx = this.m_maxX;
                        this.maxXSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_X", new Double(tmpx), new Double(this.m_maxX));
                    } else if (tmpx <= this.m_minX) {
                        tmpx = this.m_minX;
                        this.minXSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_X", new Double(tmpx), new Double(this.m_minX));
                    }
                    if (tmpy >= this.m_maxY) {
                        tmpy = this.m_maxY;
                        this.maxYSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_Y", new Double(tmpy), new Double(this.m_maxY));
                    } else if (tmpy <= this.m_minY) {
                        tmpy = this.m_minY;
                        this.minYSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_Y", new Double(tmpy), new Double(this.m_minY));
                    }
                    if (this.getSize() == 0) {
                        this.m_firsttime = true;
                    }
                }
                if (state == 4) {
                    double oldMinY;
                    double oldMaxY;
                    double oldMinX;
                    double oldMaxX;
                    if (tmpx < this.m_maxX) {
                        oldMaxX = this.m_maxX;
                        this.maxXSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_X", new Double(oldMaxX), new Double(this.m_maxX));
                    } else if (tmpx > this.m_maxX) {
                        oldMaxX = this.m_maxX;
                        this.m_maxX = tmpx;
                        this.expandMaxXErrorBarBounds();
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_X", new Double(oldMaxX), new Double(this.m_maxX));
                    }
                    if (tmpx > this.m_minX) {
                        oldMinX = this.m_minX;
                        this.minXSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_X", new Double(oldMinX), new Double(this.m_minX));
                    } else if (tmpx < this.m_minX) {
                        oldMinX = this.m_minX;
                        this.m_minX = tmpx;
                        this.expandMinXErrorBarBounds();
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_X", new Double(oldMinX), new Double(this.m_minX));
                    }
                    if (tmpy < this.m_maxY) {
                        oldMaxY = this.m_maxY;
                        this.maxYSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_Y", new Double(oldMaxY), new Double(this.m_maxY));
                    } else if (tmpy > this.m_maxY) {
                        oldMaxY = this.m_maxY;
                        this.m_maxY = tmpy;
                        this.expandMaxYErrorBarBounds();
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_Y", new Double(oldMaxY), new Double(this.m_maxY));
                    }
                    if (tmpy > this.m_minY) {
                        oldMinY = this.m_minY;
                        this.minYSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_Y", new Double(oldMinY), new Double(this.m_minY));
                    } else if (tmpy < this.m_minY) {
                        oldMinY = this.m_minY;
                        this.m_minY = tmpy;
                        this.expandMinYErrorBarBounds();
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_Y", new Double(oldMinY), new Double(this.m_minY));
                    }
                    this.firePropertyChange("ITrace2D.PROPERTY_POINT_CHANGED", null, changed);
                }
            }
        }
    }

    public List<ChangeListener> getChangeListeners() {
        return new LinkedList<ChangeListener>(this.m_changeListeners);
    }

    @Override
    public final Color getColor() {
        return this.m_color;
    }

    @Override
    public Number getComparableProperty() {
        return this.m_zIndex;
    }

    @Override
    public final Set<IErrorBarPolicy> getErrorBarPolicies() {
        return this.m_errorBarPolicies;
    }

    @Override
    public final boolean getHasErrorBars() {
        boolean result;
        block1: {
            IErrorBarPolicy errorBarPolicy;
            result = false;
            if (this.m_errorBarPolicies.size() <= 0) break block1;
            Iterator<IErrorBarPolicy> i$ = this.m_errorBarPolicies.iterator();
            while (!(!i$.hasNext() || (errorBarPolicy = i$.next()).getErrorBarPainters().size() > 0 && ((result |= errorBarPolicy.isShowNegativeXErrors()) || (result |= errorBarPolicy.isShowPositiveXErrors()) || (result |= errorBarPolicy.isShowNegativeYErrors()) || (result |= errorBarPolicy.isShowPositiveYErrors())))) {
            }
        }
        return result;
    }

    @Override
    public final String getLabel() {
        String name = this.getName();
        String physunit = this.getPhysicalUnits();
        if (!StringUtil.isEmpty(name) && !StringUtil.isEmpty(physunit)) {
            name = new StringBuffer(name).append(" ").append(physunit).toString();
        } else if (!StringUtil.isEmpty(physunit)) {
            name = new StringBuffer("unnamed").append(" ").append(physunit).toString();
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final double getMaxX() {
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                double result = this.m_maxX;
                if (this.m_maxXErrorBar != -1.7976931348623157E308) {
                    result = this.m_maxXErrorBar;
                }
                return result;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final double getMaxY() {
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                double result = this.m_maxY;
                if (this.m_maxYErrorBar != -1.7976931348623157E308) {
                    result = this.m_maxYErrorBar;
                }
                return result;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final double getMinX() {
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                double result = this.m_minX;
                if (this.m_minXErrorBar != Double.MAX_VALUE) {
                    result = this.m_minXErrorBar;
                }
                return result;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final double getMinY() {
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                double result = this.m_minY;
                if (this.m_minYErrorBar != Double.MAX_VALUE) {
                    result = this.m_minYErrorBar;
                }
                return result;
            }
        }
    }

    @Override
    public final String getName() {
        return this.m_name;
    }

    @Override
    public ITrace2D.ManhattanDistancePoint getNearestPointManhattan(double x, double y) {
        ITrace2D.ManhattanDistancePoint result = new ITrace2D.ManhattanDistancePoint();
        Iterator<TracePoint2D> it = this.iterator();
        double shortestManhattanDistance = Double.MAX_VALUE;
        while (it.hasNext()) {
            TracePoint2D point = it.next();
            double manhattanDistance = point.getManhattanDistance(x, y);
            if (!(manhattanDistance < shortestManhattanDistance)) continue;
            shortestManhattanDistance = manhattanDistance;
            result.setPoint(point);
            result.setManhattanDistance(shortestManhattanDistance);
        }
        return result;
    }

    @Override
    public final String getPhysicalUnits() {
        String result = StringUtil.isEmpty(this.m_physicalUnitsX) && StringUtil.isEmpty(this.m_physicalUnitsY) ? "" : new StringBuffer("[x: ").append(this.getPhysicalUnitsX()).append(", y: ").append(this.getPhysicalUnitsY()).append("]").toString();
        return result;
    }

    @Override
    public final String getPhysicalUnitsX() {
        return this.m_physicalUnitsX;
    }

    @Override
    public final String getPhysicalUnitsY() {
        return this.m_physicalUnitsY;
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners(String property) {
        return this.m_propertyChangeSupport.getPropertyChangeListeners(property);
    }

    @Override
    public final Chart2D getRenderer() {
        Chart2D result = null;
        if (this.m_renderer instanceof Chart2D) {
            result = (Chart2D)this.m_renderer;
        }
        return result;
    }

    @Override
    public final Stroke getStroke() {
        return this.m_stroke;
    }

    @Override
    public final Set<ITracePainter> getTracePainters() {
        return this.m_tracePainters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Integer getZIndex() {
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                return 100 - this.m_zIndex;
            }
        }
    }

    @Override
    public final boolean isVisible() {
        return this.m_visible;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("IErrorBarPolicy.PROPERTY_CONFIGURATION".equals(evt.getPropertyName())) {
            this.expandErrorBarBounds();
            this.firePropertyChange("ITrace2D.PROPERTY_ERRORBARPOLICY_CONFIGURATION", null, evt.getSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeAllPoints() {
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                this.m_firsttime = true;
                this.removeAllPointsInternal();
                double oldValue = this.m_maxX;
                this.m_maxX = 0.0;
                this.firePropertyChange("ITrace2D.PROPERTY_MAX_X", new Double(oldValue), new Double(this.m_maxX));
                oldValue = this.m_maxY;
                this.m_maxY = 0.0;
                this.firePropertyChange("ITrace2D.PROPERTY_MAX_Y", new Double(oldValue), new Double(this.m_maxY));
                oldValue = this.m_minX;
                this.m_minX = 0.0;
                this.firePropertyChange("ITrace2D.PROPERTY_MIN_X", new Double(oldValue), new Double(this.m_minX));
                oldValue = this.m_minY;
                this.m_minY = 0.0;
                this.firePropertyChange("ITrace2D.PROPERTY_MIN_Y", new Double(oldValue), new Double(this.m_minY));
                for (ITrace2D trace : this.m_computingTraces) {
                    trace.removeAllPoints();
                }
            }
        }
    }

    @Override
    public boolean removeComputingTrace(ITrace2D trace) {
        boolean result = this.m_computingTraces.remove(trace);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeErrorBarPolicy(IErrorBarPolicy errorBarPolicy) {
        boolean result = false;
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                result = this.m_errorBarPolicies.remove(errorBarPolicy);
                if (result) {
                    errorBarPolicy.setTrace(null);
                    errorBarPolicy.removePropertyChangeListener("IErrorBarPolicy.PROPERTY_CONFIGURATION", this);
                    this.expandErrorBarBounds();
                    this.firePropertyChange("ITrace2D.PROPERTY_ERRORBARPOLICY", errorBarPolicy, null);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removePoint(TracePoint2D point) {
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                TracePoint2D removed = this.removePointInternal(point);
                if (removed != null) {
                    double tmpx = removed.getX();
                    double tmpy = removed.getY();
                    if (tmpx >= this.m_maxX) {
                        tmpx = this.m_maxX;
                        this.maxXSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_X", new Double(tmpx), new Double(this.m_maxX));
                    } else if (tmpx <= this.m_minX) {
                        tmpx = this.m_minX;
                        this.minXSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_X", new Double(tmpx), new Double(this.m_minX));
                    }
                    if (tmpy >= this.m_maxY) {
                        tmpy = this.m_maxY;
                        this.maxYSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_Y", new Double(tmpy), new Double(this.m_maxY));
                    } else if (tmpy <= this.m_minY) {
                        tmpy = this.m_minY;
                        this.minYSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_Y", new Double(tmpy), new Double(this.m_minY));
                    }
                    this.firePointRemoved(removed);
                    removed.setListener(null);
                    for (ITrace2D trace : this.m_computingTraces) {
                        trace.removePoint(removed);
                    }
                }
                return removed != null;
            }
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(property, listener);
    }

    @Override
    public boolean removeTracePainter(ITracePainter painter) {
        boolean result = false;
        if (this.m_tracePainters.size() > 1 && (result = this.m_tracePainters.remove(painter))) {
            this.firePropertyChange("ITrace2D.PROPERTY_PAINTERS", painter, null);
        }
        return result;
    }

    @Override
    public final void setColor(Color color) {
        Color oldValue = this.m_color;
        this.m_color = color;
        if (!this.m_color.equals(oldValue)) {
            this.firePropertyChange("ITrace2D.PROPERTY_COLOR", oldValue, this.m_color);
        }
    }

    @Override
    public void setComparableProperty(Number n) {
        this.m_zIndex = (Integer)n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<IErrorBarPolicy> setErrorBarPolicy(IErrorBarPolicy errorBarPolicy) {
        Set<IErrorBarPolicy> result = this.m_errorBarPolicies;
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                this.m_errorBarPolicies = new TreeSet<IErrorBarPolicy>();
                boolean added = this.m_errorBarPolicies.add(errorBarPolicy);
                if (added) {
                    errorBarPolicy.setTrace(this);
                    this.expandErrorBarBounds();
                    errorBarPolicy.addPropertyChangeListener("IErrorBarPolicy.PROPERTY_CONFIGURATION", this);
                    this.firePropertyChange("ITrace2D.PROPERTY_ERRORBARPOLICY", null, errorBarPolicy);
                }
                for (IErrorBarPolicy oldPolicy : result) {
                    oldPolicy.setTrace(null);
                    errorBarPolicy.removePropertyChangeListener("IErrorBarPolicy.PROPERTY_CONFIGURATION", this);
                    this.firePropertyChange("ITrace2D.PROPERTY_ERRORBARPOLICY", oldPolicy, null);
                }
            }
        }
        return result;
    }

    @Override
    public final void setName(String name) {
        String oldValue = this.m_name;
        String oldLabel = this.getLabel();
        this.m_name = name;
        String newLabel = this.getLabel();
        this.firePropertyChange("ITrace2D.PROPERTY_LABEL", oldLabel, newLabel);
        this.firePropertyChange("ITrace2D.PROPERTY_NAME", oldValue, this.m_name);
    }

    @Override
    public final void setPhysicalUnits(String xunit, String yunit) {
        String oldValue = this.getPhysicalUnits();
        String oldLabel = this.getLabel();
        this.m_physicalUnitsX = xunit;
        this.m_physicalUnitsY = yunit;
        String newValue = this.getPhysicalUnits();
        String newLabel = this.getLabel();
        this.firePropertyChange("ITrace2D.PROPERTY_LABEL", oldLabel, newLabel);
        this.firePropertyChange("ITrace2D.PROPERTY_PHYSICALUNITS", oldValue, newValue);
    }

    @Override
    public final void setRenderer(Chart2D renderer) {
        boolean requiresErrorBarCalculation = this.m_renderer != renderer;
        this.m_renderer = renderer;
        if (requiresErrorBarCalculation) {
            this.expandErrorBarBounds();
        }
    }

    @Override
    public final void setStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        Stroke oldValue = this.m_stroke;
        this.m_stroke = stroke;
        if (!this.m_stroke.equals(oldValue)) {
            this.firePropertyChange("ITrace2D.PROPERTY_STROKE", oldValue, this.m_stroke);
        }
    }

    @Override
    public final Set<ITracePainter> setTracePainter(ITracePainter painter) {
        Set<ITracePainter> result = this.m_tracePainters;
        this.m_tracePainters = new TreeSet<ITracePainter>();
        boolean added = this.m_tracePainters.add(painter);
        if (added) {
            this.firePropertyChange("ITrace2D.PROPERTY_PAINTERS", null, painter);
        }
        return result;
    }

    @Override
    public final void setVisible(boolean visible) {
        boolean oldValue = this.m_visible;
        this.m_visible = visible;
        if (oldValue != this.m_visible) {
            this.firePropertyChange("ITrace2D.PROPERTY_VISIBLE", oldValue, this.m_visible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setZIndex(Integer zIndex) {
        if (!zIndex.equals(this.m_zIndex)) {
            Object object = this.m_renderer;
            synchronized (object) {
                Integer oldValue = this.m_zIndex;
                ATrace2D aTrace2D = this;
                synchronized (aTrace2D) {
                    boolean rendered = this.m_renderer instanceof Chart2D;
                    if (rendered) {
                        ((Chart2D)this.m_renderer).removeTrace(this);
                    }
                    this.m_zIndex = 100 - zIndex;
                    if (rendered) {
                        ((Chart2D)this.m_renderer).addTrace(this);
                    }
                    this.firePropertyChange("ITrace2D.PROPERTY_ZINDEX", oldValue, this.m_zIndex);
                }
            }
        }
    }

    @Override
    public boolean showsErrorBars() {
        boolean result = false;
        for (IErrorBarPolicy errorBarPolicy : this.m_errorBarPolicies) {
            if (errorBarPolicy.getErrorBarPainters().size() <= 0 || !errorBarPolicy.isShowNegativeXErrors() && !errorBarPolicy.isShowNegativeYErrors() && !errorBarPolicy.isShowPositiveXErrors() && !errorBarPolicy.isShowPositiveYErrors()) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public boolean showsNegativeXErrorBars() {
        boolean result = false;
        for (IErrorBarPolicy errorBarPolicy : this.m_errorBarPolicies) {
            if (errorBarPolicy.getErrorBarPainters().size() <= 0 || !errorBarPolicy.isShowNegativeXErrors()) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public boolean showsNegativeYErrorBars() {
        boolean result = false;
        for (IErrorBarPolicy errorBarPolicy : this.m_errorBarPolicies) {
            if (errorBarPolicy.getErrorBarPainters().size() <= 0 || !errorBarPolicy.isShowNegativeYErrors()) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public boolean showsPositiveXErrorBars() {
        boolean result = false;
        for (IErrorBarPolicy errorBarPolicy : this.m_errorBarPolicies) {
            if (errorBarPolicy.getErrorBarPainters().size() <= 0 || !errorBarPolicy.isShowPositiveXErrors()) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public boolean showsPositiveYErrorBars() {
        boolean result = false;
        for (IErrorBarPolicy errorBarPolicy : this.m_errorBarPolicies) {
            if (errorBarPolicy.getErrorBarPainters().size() <= 0 || !errorBarPolicy.isShowPositiveYErrors()) continue;
            result = true;
            break;
        }
        return result;
    }

    public String toString() {
        return this.getName();
    }

    protected abstract boolean addPointInternal(TracePoint2D var1);

    protected void finalize() throws Throwable {
        super.finalize();
        --instanceCount;
    }

    protected void firePointAdded(TracePoint2D added) {
        this.firePointChanged(added, 1);
        this.firePropertyChange("ITrace2D.PROPERTY_TRACEPOINT", null, added);
    }

    protected void firePointRemoved(TracePoint2D removed) {
        this.firePointChanged(removed, 2);
        this.firePropertyChange("ITrace2D.PROPERTY_TRACEPOINT", removed, null);
    }

    protected final void firePropertyChange(String property, Object oldvalue, Object newvalue) {
        if (property.equals("ITrace2D.PROPERTY_MAX_X") || property.equals("ITrace2D.PROPERTY_MAX_Y") || property.equals("ITrace2D.PROPERTY_MIN_X") || property.equals("ITrace2D.PROPERTY_MIN_Y") || property.equals("ITrace2D.PROPERTY_TRACEPOINT") || property.equals("ITrace2D.PROPERTY_POINT_CHANGED")) {
            if (!Thread.holdsLock(this.m_renderer)) {
                throw new RuntimeException("Acquire a lock on the corresponding chart first!");
            }
            if (!Thread.holdsLock(this)) {
                throw new RuntimeException("Acquire a lock on this trace first!");
            }
        }
        this.m_propertyChangeSupport.firePropertyChange(property, oldvalue, newvalue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maxXSearch() {
        ATrace2D aTrace2D = this;
        synchronized (aTrace2D) {
            double ret = -1.7976931348623157E308;
            TracePoint2D tmpoint = null;
            Iterator<TracePoint2D> it = this.iterator();
            while (it.hasNext()) {
                tmpoint = it.next();
                double tmp = tmpoint.getX();
                if (!(tmp > ret)) continue;
                ret = tmp;
            }
            this.m_maxX = ret;
        }
        this.expandMaxXErrorBarBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maxYSearch() {
        ATrace2D aTrace2D = this;
        synchronized (aTrace2D) {
            double ret = -1.7976931348623157E308;
            TracePoint2D tmpoint = null;
            Iterator<TracePoint2D> it = this.iterator();
            while (it.hasNext()) {
                tmpoint = it.next();
                double tmp = tmpoint.getY();
                if (!(tmp > ret)) continue;
                ret = tmp;
            }
            this.m_maxY = ret;
        }
        this.expandMaxYErrorBarBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void minXSearch() {
        ATrace2D aTrace2D = this;
        synchronized (aTrace2D) {
            double ret = Double.MAX_VALUE;
            TracePoint2D tmpoint = null;
            Iterator<TracePoint2D> it = this.iterator();
            while (it.hasNext()) {
                tmpoint = it.next();
                double tmp = tmpoint.getX();
                if (!(tmp < ret)) continue;
                ret = tmp;
            }
            this.m_minX = ret;
        }
        this.expandMinXErrorBarBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void minYSearch() {
        ATrace2D aTrace2D = this;
        synchronized (aTrace2D) {
            double ret = Double.MAX_VALUE;
            TracePoint2D tmpoint = null;
            Iterator<TracePoint2D> it = this.iterator();
            while (it.hasNext()) {
                tmpoint = it.next();
                double tmp = tmpoint.getY();
                if (!(tmp < ret)) continue;
                ret = tmp;
            }
            this.m_minY = ret;
            this.expandMinYErrorBarBounds();
        }
    }

    protected abstract void removeAllPointsInternal();

    protected abstract TracePoint2D removePointInternal(TracePoint2D var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandErrorBarBounds() {
        boolean requiresErrorBarCalculation;
        boolean bl = requiresErrorBarCalculation = !this.isEmpty();
        if (requiresErrorBarCalculation) {
            Object object = this.m_renderer;
            synchronized (object) {
                ATrace2D aTrace2D = this;
                synchronized (aTrace2D) {
                    boolean change;
                    if (this.showsPositiveXErrorBars()) {
                        change = this.expandMaxXErrorBarBounds();
                        if (change) {
                            this.firePropertyChange("ITrace2D.PROPERTY_MAX_X", this, new Double(this.getMaxX()));
                        }
                    } else if (this.m_maxXErrorBar != -1.7976931348623157E308) {
                        this.m_maxXErrorBar = -1.7976931348623157E308;
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_X", this, new Double(this.getMaxX()));
                    }
                    if (this.showsPositiveYErrorBars()) {
                        change = this.expandMaxYErrorBarBounds();
                        if (change) {
                            this.firePropertyChange("ITrace2D.PROPERTY_MAX_Y", this, new Double(this.getMaxY()));
                        }
                    } else if (this.m_maxYErrorBar != -1.7976931348623157E308) {
                        this.m_maxYErrorBar = -1.7976931348623157E308;
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_Y", this, new Double(this.getMaxY()));
                    }
                    if (this.showsNegativeXErrorBars()) {
                        change = this.expandMinXErrorBarBounds();
                        if (change) {
                            this.firePropertyChange("ITrace2D.PROPERTY_MIN_X", this, new Double(this.getMinX()));
                        }
                    } else if (this.m_minXErrorBar != Double.MAX_VALUE) {
                        this.m_minXErrorBar = Double.MAX_VALUE;
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_X", this, new Double(this.getMinX()));
                    }
                    if (this.showsNegativeYErrorBars()) {
                        change = this.expandMinYErrorBarBounds();
                        if (change) {
                            this.firePropertyChange("ITrace2D.PROPERTY_MIN_Y", this, new Double(this.getMinY()));
                        }
                    } else if (this.m_minYErrorBar != Double.MAX_VALUE) {
                        this.m_minYErrorBar = Double.MAX_VALUE;
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_Y", this, new Double(this.getMinY()));
                    }
                }
            }
        }
    }

    private boolean expandMaxXErrorBarBounds() {
        double absoluteMax;
        Chart2D chart = this.getRenderer();
        boolean change = false;
        double errorBarMaxXCollect = -1.7976931348623157E308;
        if (chart != null) {
            double errorBarMaxX = -1.7976931348623157E308;
            for (IErrorBarPolicy errorBarPolicy : this.m_errorBarPolicies) {
                if (!errorBarPolicy.isShowPositiveXErrors() || !((errorBarMaxX = errorBarPolicy.getXError(this.m_maxX)) > errorBarMaxXCollect)) continue;
                errorBarMaxXCollect = errorBarMaxX;
            }
        }
        if (!MathUtil.assertEqual(this.m_maxXErrorBar, absoluteMax = errorBarMaxXCollect + this.m_maxX, 1.0E-8)) {
            this.m_maxXErrorBar = absoluteMax;
            change = true;
        }
        return change;
    }

    private boolean expandMaxYErrorBarBounds() {
        double absoluteMax;
        Chart2D chart = this.getRenderer();
        boolean change = false;
        double errorBarMaxYCollect = -1.7976931348623157E308;
        if (chart != null) {
            double errorBarMaxY = -1.7976931348623157E308;
            for (IErrorBarPolicy errorBarPolicy : this.m_errorBarPolicies) {
                if (!errorBarPolicy.isShowPositiveYErrors() || !((errorBarMaxY = errorBarPolicy.getYError(this.m_maxY)) > errorBarMaxYCollect)) continue;
                errorBarMaxYCollect = errorBarMaxY;
            }
        }
        if (!MathUtil.assertEqual(this.m_maxYErrorBar, absoluteMax = errorBarMaxYCollect + this.m_maxY, 1.0E-8)) {
            this.m_maxYErrorBar = absoluteMax;
            change = true;
        }
        return change;
    }

    private boolean expandMinXErrorBarBounds() {
        double absoluteMin;
        Chart2D chart = this.getRenderer();
        boolean change = false;
        double errorBarMinXCollect = -1.7976931348623157E308;
        if (chart != null) {
            double errorBarMinX = -1.7976931348623157E308;
            for (IErrorBarPolicy errorBarPolicy : this.m_errorBarPolicies) {
                if (!errorBarPolicy.isShowNegativeXErrors() || !((errorBarMinX = errorBarPolicy.getXError(this.m_minX)) > errorBarMinXCollect)) continue;
                errorBarMinXCollect = errorBarMinX;
            }
        }
        if (!MathUtil.assertEqual(this.m_minXErrorBar, absoluteMin = this.m_minX - errorBarMinXCollect, 1.0E-8)) {
            this.m_minXErrorBar = absoluteMin;
            change = true;
        }
        return change;
    }

    private boolean expandMinYErrorBarBounds() {
        double absoluteMin;
        Chart2D chart = this.getRenderer();
        boolean change = false;
        double errorBarMinYCollect = -1.7976931348623157E308;
        if (chart != null) {
            double errorBarMinY = -1.7976931348623157E308;
            for (IErrorBarPolicy errorBarPolicy : this.getErrorBarPolicies()) {
                if (!errorBarPolicy.isShowNegativeYErrors() || !((errorBarMinY = errorBarPolicy.getYError(this.m_minY)) > errorBarMinYCollect)) continue;
                errorBarMinYCollect = errorBarMinY;
            }
        }
        if (!MathUtil.assertEqual(this.m_minYErrorBar, absoluteMin = this.m_minY - errorBarMinYCollect, 1.0E-8)) {
            this.m_minYErrorBar = absoluteMin;
            change = true;
        }
        return change;
    }
}

