"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _path = _interopRequireDefault(require("path"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _tooltip = _interopRequireDefault(require("../atom/tooltip"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _atomTextEditor = _interopRequireDefault(require("../atom/atom-text-editor"));

var _issueishLink = require("./issueish-link");

var _emojiReactionsController = _interopRequireDefault(require("../controllers/emoji-reactions-controller"));

var _prCheckoutController = require("../controllers/pr-checkout-controller");

var _githubDotcomMarkdown = _interopRequireDefault(require("./github-dotcom-markdown"));

var _patchPreviewView = _interopRequireDefault(require("./patch-preview-view"));

var _checkoutButton = _interopRequireDefault(require("./checkout-button"));

var _timeago = _interopRequireDefault(require("./timeago"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _helpers = require("../helpers");

var _reporterProxy = require("../reporter-proxy");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ReviewsView extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "logStartReviewClick", () => {
      (0, _reporterProxy.addEvent)('start-pr-review', {
        "package": 'github',
        component: this.constructor.name
      });
    });

    _defineProperty(this, "renderReviewSummary", review => {
      const reviewTypes = type => {
        return {
          APPROVED: {
            icon: 'icon-check',
            copy: 'approved these changes'
          },
          COMMENTED: {
            icon: 'icon-comment',
            copy: 'commented'
          },
          CHANGES_REQUESTED: {
            icon: 'icon-alert',
            copy: 'requested changes'
          }
        }[type] || {
          icon: '',
          copy: ''
        };
      };

      const {
        icon,
        copy
      } = reviewTypes(review.state); // filter non actionable empty summary comments from this view

      if (review.state === 'PENDING' || review.state === 'COMMENTED' && review.bodyHTML === '') {
        return null;
      }

      const author = review.author || _helpers.GHOST_USER;
      return _react["default"].createElement("div", {
        className: "github-ReviewSummary",
        key: review.id
      }, _react["default"].createElement("header", {
        className: "github-Review-header"
      }, _react["default"].createElement("div", {
        className: "github-Review-header-authorData"
      }, _react["default"].createElement("span", {
        className: `github-ReviewSummary-icon icon ${icon}`
      }), _react["default"].createElement("img", {
        className: "github-ReviewSummary-avatar",
        src: author.avatarUrl,
        alt: author.login
      }), _react["default"].createElement("a", {
        className: "github-ReviewSummary-username",
        href: author.url
      }, author.login), _react["default"].createElement("span", {
        className: "github-ReviewSummary-type"
      }, copy), this.renderEditedLink(review)), _react["default"].createElement(_timeago["default"], {
        className: "github-ReviewSummary-timeAgo",
        time: review.submittedAt,
        displayStyle: "short"
      })), _react["default"].createElement("main", {
        className: "github-ReviewSummary-comment"
      }, _react["default"].createElement(_githubDotcomMarkdown["default"], {
        html: review.bodyHTML,
        switchToIssueish: this.props.openIssueish,
        openIssueishLinkInNewTab: this.openIssueishLinkInNewTab
      }), _react["default"].createElement(_emojiReactionsController["default"], {
        reactable: review,
        tooltips: this.props.tooltips,
        reportMutationErrors: this.props.reportMutationErrors
      })));
    });

    _defineProperty(this, "renderReviewCommentThread", commentThread => {
      const {
        comments,
        thread
      } = commentThread;
      const rootComment = comments[0];

      if (!rootComment) {
        return null;
      }

      let threadHolder = this.threadHolders.get(thread.id);

      if (!threadHolder) {
        threadHolder = new _refHolder["default"]();
        this.threadHolders.set(thread.id, threadHolder);
      }

      const nativePath = (0, _helpers.toNativePathSep)(rootComment.path);

      const {
        dir,
        base
      } = _path["default"].parse(nativePath);

      const {
        lineNumber,
        positionText
      } = this.getTranslatedPosition(rootComment);
      const refJumpToFileButton = new _refHolder["default"]();
      const jumpToFileDisabledLabel = 'Checkout this pull request to enable Jump To File.';
      const elementId = `review-thread-${thread.id}`;
      const navButtonClasses = ['github-Review-navButton', 'icon', {
        outdated: !lineNumber
      }];
      const openFileClasses = (0, _classnames["default"])('icon-code', ...navButtonClasses);
      const openDiffClasses = (0, _classnames["default"])('icon-diff', ...navButtonClasses);
      const isOpen = this.props.threadIDsOpen.has(thread.id);
      const isHighlighted = this.props.scrollToThreadID === thread.id;

      const toggle = evt => {
        evt.preventDefault();
        evt.stopPropagation();

        if (isOpen) {
          this.props.hideThreadID(thread.id);
        } else {
          this.props.showThreadID(thread.id);
        }
      };

      const author = rootComment.author || _helpers.GHOST_USER;
      return _react["default"].createElement("details", {
        ref: threadHolder.setter,
        className: (0, _classnames["default"])('github-Review', {
          'resolved': thread.isResolved,
          'github-Review--highlight': isHighlighted
        }),
        key: elementId,
        id: elementId,
        open: isOpen
      }, _react["default"].createElement("summary", {
        className: "github-Review-reference",
        onClick: toggle
      }, dir && _react["default"].createElement("span", {
        className: "github-Review-path"
      }, dir), _react["default"].createElement("span", {
        className: "github-Review-file"
      }, dir ? _path["default"].sep : '', base), _react["default"].createElement("span", {
        className: "github-Review-lineNr"
      }, positionText), _react["default"].createElement("img", {
        className: "github-Review-referenceAvatar",
        src: author.avatarUrl,
        alt: author.login
      }), _react["default"].createElement(_timeago["default"], {
        className: "github-Review-referenceTimeAgo",
        time: rootComment.createdAt,
        displayStyle: "short"
      })), _react["default"].createElement("nav", {
        className: "github-Review-nav"
      }, _react["default"].createElement("button", {
        className: openFileClasses,
        "data-path": nativePath,
        "data-line": lineNumber,
        onClick: this.openFile,
        disabled: this.props.checkoutOp.isEnabled(),
        ref: refJumpToFileButton.setter
      }, "Jump To File"), _react["default"].createElement("button", {
        className: openDiffClasses,
        "data-path": nativePath,
        "data-line": rootComment.position,
        onClick: this.openDiff
      }, "Open Diff"), this.props.checkoutOp.isEnabled() && _react["default"].createElement(_tooltip["default"], {
        manager: this.props.tooltips,
        target: refJumpToFileButton,
        title: jumpToFileDisabledLabel,
        showDelay: 200
      })), rootComment.position !== null && _react["default"].createElement(_patchPreviewView["default"], {
        multiFilePatch: this.props.multiFilePatch,
        fileName: nativePath,
        diffRow: rootComment.position,
        maxRowCount: this.props.contextLines,
        config: this.props.config
      }), this.renderThread({
        thread,
        comments
      }));
    });

    _defineProperty(this, "renderThread", ({
      thread,
      comments
    }) => {
      let replyHolder = this.replyHolders.get(thread.id);

      if (!replyHolder) {
        replyHolder = new _refHolder["default"]();
        this.replyHolders.set(thread.id, replyHolder);
      }

      const lastComment = comments[comments.length - 1];
      const isPosting = this.props.postingToThreadID !== null;
      return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement("main", {
        className: "github-Review-comments"
      }, comments.map(this.renderComment), _react["default"].createElement("div", {
        className: (0, _classnames["default"])('github-Review-reply', {
          'github-Review-reply--disabled': isPosting
        }),
        "data-thread-id": thread.id
      }, _react["default"].createElement(_atomTextEditor["default"], {
        placeholderText: "Reply...",
        lineNumberGutterVisible: false,
        softWrapped: true,
        autoHeight: true,
        readOnly: isPosting,
        refModel: replyHolder
      }))), thread.isResolved && _react["default"].createElement("div", {
        className: "github-Review-resolvedText"
      }, "This conversation was marked as resolved by @", thread.resolvedBy.login), _react["default"].createElement("footer", {
        className: "github-Review-footer"
      }, _react["default"].createElement("button", {
        className: "github-Review-replyButton btn",
        title: "Add your comment",
        disabled: isPosting,
        onClick: () => this.submitReply(replyHolder, thread, lastComment)
      }, "Comment"), this.renderResolveButton(thread)));
    });

    _defineProperty(this, "renderResolveButton", thread => {
      if (thread.isResolved) {
        return _react["default"].createElement("button", {
          className: "github-Review-resolveButton btn btn-primary icon icon-check",
          title: "Unresolve conversation",
          onClick: () => this.props.unresolveThread(thread)
        }, "Unresolve conversation");
      } else {
        return _react["default"].createElement("button", {
          className: "github-Review-resolveButton btn btn-primary icon icon-check",
          title: "Resolve conversation",
          onClick: () => this.props.resolveThread(thread)
        }, "Resolve conversation");
      }
    });

    _defineProperty(this, "renderComment", comment => {
      if (comment.isMinimized) {
        return _react["default"].createElement("div", {
          className: "github-Review-comment github-Review-comment--hidden",
          key: comment.id
        }, _react["default"].createElement(_octicon["default"], {
          icon: 'fold',
          className: "github-Review-icon"
        }), _react["default"].createElement("em", null, "This comment was hidden"));
      }

      const commentClass = (0, _classnames["default"])('github-Review-comment', {
        'github-Review-comment--pending': comment.state === 'PENDING'
      });
      const author = comment.author || _helpers.GHOST_USER;
      return _react["default"].createElement("div", {
        className: commentClass,
        key: comment.id
      }, _react["default"].createElement("header", {
        className: "github-Review-header"
      }, _react["default"].createElement("div", {
        className: "github-Review-header-authorData"
      }, _react["default"].createElement("img", {
        className: "github-Review-avatar",
        src: author.avatarUrl,
        alt: author.login
      }), _react["default"].createElement("a", {
        className: "github-Review-username",
        href: author.url
      }, author.login), _react["default"].createElement("a", {
        className: "github-Review-timeAgo",
        href: comment.url
      }, _react["default"].createElement(_timeago["default"], {
        displayStyle: "long",
        time: comment.createdAt
      })), this.renderEditedLink(comment), comment.state === 'PENDING' && _react["default"].createElement("span", {
        className: "github-Review-pendingBadge badge badge-warning"
      }, "pending")), _react["default"].createElement("a", {
        className: "github-Review-reportAbuseLink",
        title: "report abuse",
        href: `https://github.com/contact/report-content?report=${encodeURIComponent(author.login)}&content_url=${encodeURIComponent(comment.url)}`
      }, _react["default"].createElement(_octicon["default"], {
        icon: "alert"
      }))), _react["default"].createElement("div", {
        className: "github-Review-text"
      }, _react["default"].createElement(_githubDotcomMarkdown["default"], {
        html: comment.bodyHTML,
        switchToIssueish: this.props.openIssueish,
        openIssueishLinkInNewTab: this.openIssueishLinkInNewTab
      }), _react["default"].createElement(_emojiReactionsController["default"], {
        reactable: comment,
        tooltips: this.props.tooltips,
        reportMutationErrors: this.props.reportMutationErrors
      })));
    });

    _defineProperty(this, "openFile", evt => {
      if (!this.props.checkoutOp.isEnabled()) {
        const target = evt.currentTarget;
        this.props.openFile(target.dataset.path, target.dataset.line);
      }
    });

    _defineProperty(this, "openDiff", evt => {
      const target = evt.currentTarget;
      this.props.openDiff(target.dataset.path, parseInt(target.dataset.line, 10));
    });

    _defineProperty(this, "openIssueishLinkInNewTab", evt => {
      const {
        repoOwner,
        repoName,
        issueishNumber
      } = (0, _issueishLink.getDataFromGithubUrl)(evt.target.dataset.url);
      return this.props.openIssueish(repoOwner, repoName, issueishNumber);
    });

    _defineProperty(this, "submitCurrentComment", evt => {
      const threadID = evt.currentTarget.dataset.threadId;
      /* istanbul ignore if */

      if (!threadID) {
        return null;
      }

      const {
        thread,
        comments
      } = this.props.commentThreads.find(each => each.thread.id === threadID);
      const replyHolder = this.replyHolders.get(threadID);
      return this.submitReply(replyHolder, thread, comments[comments.length - 1]);
    });

    this.rootHolder = new _refHolder["default"]();
    this.replyHolders = new Map();
    this.threadHolders = new Map();
    this.state = {
      isRefreshing: false
    };
    this.subs = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    const {
      scrollToThreadID
    } = this.props;

    if (scrollToThreadID) {
      const threadHolder = this.threadHolders.get(scrollToThreadID);

      if (threadHolder) {
        threadHolder.map(element => {
          element.scrollIntoViewIfNeeded();
          return null; // shh, eslint
        });
      }
    }
  }

  componentDidUpdate(prevProps) {
    const {
      scrollToThreadID
    } = this.props;

    if (scrollToThreadID && scrollToThreadID !== prevProps.scrollToThreadID) {
      const threadHolder = this.threadHolders.get(scrollToThreadID);

      if (threadHolder) {
        threadHolder.map(element => {
          element.scrollIntoViewIfNeeded();
          return null; // shh, eslint
        });
      }
    }
  }

  componentWillUnmount() {
    this.subs.dispose();
  }

  render() {
    return _react["default"].createElement("div", {
      className: "github-Reviews",
      ref: this.rootHolder.setter
    }, this.renderCommands(), this.renderHeader(), _react["default"].createElement("div", {
      className: "github-Reviews-list"
    }, this.renderReviewSummaries(), this.renderReviewCommentThreads()));
  }

  renderCommands() {
    return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement(_commands["default"], {
      registry: this.props.commands,
      target: this.rootHolder
    }, _react["default"].createElement(_commands.Command, {
      command: "github:more-context",
      callback: this.props.moreContext
    }), _react["default"].createElement(_commands.Command, {
      command: "github:less-context",
      callback: this.props.lessContext
    })), _react["default"].createElement(_commands["default"], {
      registry: this.props.commands,
      target: ".github-Review-reply"
    }, _react["default"].createElement(_commands.Command, {
      command: "github:submit-comment",
      callback: this.submitCurrentComment
    })));
  }

  renderHeader() {
    const refresh = () => {
      if (this.state.isRefreshing) {
        return;
      }

      this.setState({
        isRefreshing: true
      });
      const sub = this.props.refetch(() => {
        this.subs.remove(sub);
        this.setState({
          isRefreshing: false
        });
      });
      this.subs.add(sub);
    };

    return _react["default"].createElement("header", {
      className: "github-Reviews-topHeader"
    }, _react["default"].createElement("span", {
      className: "icon icon-comment-discussion"
    }), _react["default"].createElement("span", {
      className: "github-Reviews-headerTitle"
    }, "Reviews for\xA0", _react["default"].createElement("span", {
      className: "github-Reviews-clickable",
      onClick: this.props.openPR
    }, this.props.owner, "/", this.props.repo, "#", this.props.number)), _react["default"].createElement("button", {
      className: (0, _classnames["default"])('github-Reviews-headerButton github-Reviews-clickable icon icon-repo-sync', {
        refreshing: this.state.isRefreshing
      }),
      onClick: refresh
    }), _react["default"].createElement(_checkoutButton["default"], {
      checkoutOp: this.props.checkoutOp,
      classNamePrefix: "github-Reviews-checkoutButton--",
      classNames: ['github-Reviews-headerButton']
    }));
  }

  renderEmptyState() {
    const {
      number,
      repo,
      owner
    } = this.props; // todo: make this open the review flow in Atom instead of dotcom

    const pullRequestURL = `https://www.github.com/${owner}/${repo}/pull/${number}/files/`;
    return _react["default"].createElement("div", {
      className: "github-Reviews-emptyState"
    }, _react["default"].createElement("img", {
      src: "atom://github/img/mona.svg",
      alt: "Mona the octocat in spaaaccee",
      className: "github-Reviews-emptyImg"
    }), _react["default"].createElement("div", {
      className: "github-Reviews-emptyText"
    }, "This pull request has no reviews"), _react["default"].createElement("button", {
      className: "github-Reviews-emptyCallToActionButton btn"
    }, _react["default"].createElement("a", {
      href: pullRequestURL,
      onClick: this.logStartReviewClick
    }, "Start a new review")));
  }

  renderReviewSummaries() {
    if (this.props.summaries.length === 0) {
      return this.renderEmptyState();
    }

    const toggle = evt => {
      evt.preventDefault();

      if (this.props.summarySectionOpen) {
        this.props.hideSummaries();
      } else {
        this.props.showSummaries();
      }
    };

    return _react["default"].createElement("details", {
      className: "github-Reviews-section summaries",
      open: this.props.summarySectionOpen
    }, _react["default"].createElement("summary", {
      className: "github-Reviews-header",
      onClick: toggle
    }, _react["default"].createElement("span", {
      className: "github-Reviews-title"
    }, "Summaries")), _react["default"].createElement("main", {
      className: "github-Reviews-container"
    }, this.props.summaries.map(this.renderReviewSummary)));
  }

  renderReviewCommentThreads() {
    const commentThreads = this.props.commentThreads;

    if (commentThreads.length === 0) {
      return null;
    }

    const resolvedThreads = commentThreads.filter(pair => pair.thread.isResolved).length;

    const toggleComments = evt => {
      evt.preventDefault();

      if (this.props.commentSectionOpen) {
        this.props.hideComments();
      } else {
        this.props.showComments();
      }
    };

    return _react["default"].createElement("details", {
      className: "github-Reviews-section comments",
      open: this.props.commentSectionOpen
    }, _react["default"].createElement("summary", {
      className: "github-Reviews-header",
      onClick: toggleComments
    }, _react["default"].createElement("span", {
      className: "github-Reviews-title"
    }, "Comments"), _react["default"].createElement("span", {
      className: "github-Reviews-progress"
    }, _react["default"].createElement("span", {
      className: "github-Reviews-count"
    }, "Resolved", ' ', _react["default"].createElement("span", {
      className: "github-Reviews-countNr"
    }, resolvedThreads), ' ', "of", ' ', _react["default"].createElement("span", {
      className: "github-Reviews-countNr"
    }, commentThreads.length)), _react["default"].createElement("progress", {
      className: "github-Reviews-progessBar",
      value: resolvedThreads,
      max: commentThreads.length
    }))), _react["default"].createElement("main", {
      className: "github-Reviews-container"
    }, commentThreads.map(this.renderReviewCommentThread)));
  }

  renderEditedLink(entity) {
    if (!entity.lastEditedAt) {
      return null;
    } else {
      return _react["default"].createElement("span", {
        className: "github-Review-edited"
      }, "\xA0\u2022\xA0", _react["default"].createElement("a", {
        className: "github-Review-edited",
        href: entity.url
      }, "edited"));
    }
  }

  submitReply(replyHolder, thread, lastComment) {
    const body = replyHolder.map(editor => editor.getText()).getOr('');

    const didSubmitComment = () => replyHolder.map(editor => editor.setText('', {
      bypassReadOnly: true
    }));

    const didFailComment = () => replyHolder.map(editor => editor.setText(body, {
      bypassReadOnly: true
    }));

    return this.props.addSingleComment(body, thread.id, lastComment.id, lastComment.path, lastComment.position, {
      didSubmitComment,
      didFailComment
    });
  }

  getTranslatedPosition(rootComment) {
    let lineNumber, positionText;
    const translations = this.props.commentTranslations;

    const isCheckedOutPullRequest = this.props.checkoutOp.why() === _prCheckoutController.checkoutStates.CURRENT;

    if (translations === null) {
      lineNumber = null;
      positionText = '';
    } else if (rootComment.position === null) {
      lineNumber = null;
      positionText = 'outdated';
    } else {
      const translationsForFile = translations.get(rootComment.path);
      lineNumber = translationsForFile.diffToFilePosition.get(parseInt(rootComment.position, 10));

      if (translationsForFile.fileTranslations && isCheckedOutPullRequest) {
        lineNumber = translationsForFile.fileTranslations.get(lineNumber).newPosition;
      }

      positionText = lineNumber;
    }

    return {
      lineNumber,
      positionText
    };
  }

}

exports["default"] = ReviewsView;

_defineProperty(ReviewsView, "propTypes", {
  // Relay results
  relay: _propTypes["default"].shape({
    environment: _propTypes["default"].object.isRequired
  }).isRequired,
  repository: _propTypes["default"].object.isRequired,
  pullRequest: _propTypes["default"].object.isRequired,
  summaries: _propTypes["default"].array.isRequired,
  commentThreads: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    thread: _propTypes["default"].object.isRequired,
    comments: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired
  })),
  refetch: _propTypes["default"].func.isRequired,
  // Package models
  multiFilePatch: _propTypes["default"].object.isRequired,
  contextLines: _propTypes["default"].number.isRequired,
  checkoutOp: _propTypes2.EnableableOperationPropType.isRequired,
  summarySectionOpen: _propTypes["default"].bool.isRequired,
  commentSectionOpen: _propTypes["default"].bool.isRequired,
  threadIDsOpen: _propTypes["default"].shape({
    has: _propTypes["default"].func.isRequired
  }),
  postingToThreadID: _propTypes["default"].string,
  scrollToThreadID: _propTypes["default"].string,
  // Structure: Map< relativePath: String, {
  //   rawPositions: Set<lineNumbers: Number>,
  //   diffToFilePosition: Map<rawPosition: Number, adjustedPosition: Number>,
  //   fileTranslations: null | Map<adjustedPosition: Number, {newPosition: Number}>,
  //   digest: String,
  // }>
  commentTranslations: _propTypes["default"].object,
  // for the dotcom link in the empty state
  number: _propTypes["default"].number.isRequired,
  repo: _propTypes["default"].string.isRequired,
  owner: _propTypes["default"].string.isRequired,
  workdir: _propTypes["default"].string.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  // Action methods
  openFile: _propTypes["default"].func.isRequired,
  openDiff: _propTypes["default"].func.isRequired,
  openPR: _propTypes["default"].func.isRequired,
  moreContext: _propTypes["default"].func.isRequired,
  lessContext: _propTypes["default"].func.isRequired,
  openIssueish: _propTypes["default"].func.isRequired,
  showSummaries: _propTypes["default"].func.isRequired,
  hideSummaries: _propTypes["default"].func.isRequired,
  showComments: _propTypes["default"].func.isRequired,
  hideComments: _propTypes["default"].func.isRequired,
  showThreadID: _propTypes["default"].func.isRequired,
  hideThreadID: _propTypes["default"].func.isRequired,
  resolveThread: _propTypes["default"].func.isRequired,
  unresolveThread: _propTypes["default"].func.isRequired,
  addSingleComment: _propTypes["default"].func.isRequired,
  reportMutationErrors: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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