"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _state = _interopRequireDefault(require("./state"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Initial state to be used when we anticipate that the workspace will contain a single project once bootstrapping
 * has completed. Presents in the UI like the Loading state.
 */
class LoadingGuess extends _state["default"] {
  isLoadingGuess() {
    return true;
  }

  isUndetermined() {
    return true;
  }

  showGitTabLoading() {
    return true;
  }

  showGitTabInit() {
    return false;
  }

  hasDirectory() {
    return false;
  }

}

exports["default"] = LoadingGuess;

_state["default"].register(LoadingGuess);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImxvYWRpbmctZ3Vlc3MuanMiXSwibmFtZXMiOlsiTG9hZGluZ0d1ZXNzIiwiU3RhdGUiLCJpc0xvYWRpbmdHdWVzcyIsImlzVW5kZXRlcm1pbmVkIiwic2hvd0dpdFRhYkxvYWRpbmciLCJzaG93R2l0VGFiSW5pdCIsImhhc0RpcmVjdG9yeSIsInJlZ2lzdGVyIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7Ozs7QUFFQTs7OztBQUllLE1BQU1BLFlBQU4sU0FBMkJDLGlCQUEzQixDQUFpQztBQUM5Q0MsRUFBQUEsY0FBYyxHQUFHO0FBQ2YsV0FBTyxJQUFQO0FBQ0Q7O0FBRURDLEVBQUFBLGNBQWMsR0FBRztBQUNmLFdBQU8sSUFBUDtBQUNEOztBQUVEQyxFQUFBQSxpQkFBaUIsR0FBRztBQUNsQixXQUFPLElBQVA7QUFDRDs7QUFFREMsRUFBQUEsY0FBYyxHQUFHO0FBQ2YsV0FBTyxLQUFQO0FBQ0Q7O0FBRURDLEVBQUFBLFlBQVksR0FBRztBQUNiLFdBQU8sS0FBUDtBQUNEOztBQW5CNkM7Ozs7QUFzQmhETCxrQkFBTU0sUUFBTixDQUFlUCxZQUFmIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzcuMC9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgU3RhdGUgZnJvbSAnLi9zdGF0ZSc7XG5cbi8qKlxuICogSW5pdGlhbCBzdGF0ZSB0byBiZSB1c2VkIHdoZW4gd2UgYW50aWNpcGF0ZSB0aGF0IHRoZSB3b3Jrc3BhY2Ugd2lsbCBjb250YWluIGEgc2luZ2xlIHByb2plY3Qgb25jZSBib290c3RyYXBwaW5nXG4gKiBoYXMgY29tcGxldGVkLiBQcmVzZW50cyBpbiB0aGUgVUkgbGlrZSB0aGUgTG9hZGluZyBzdGF0ZS5cbiAqL1xuZXhwb3J0IGRlZmF1bHQgY2xhc3MgTG9hZGluZ0d1ZXNzIGV4dGVuZHMgU3RhdGUge1xuICBpc0xvYWRpbmdHdWVzcygpIHtcbiAgICByZXR1cm4gdHJ1ZTtcbiAgfVxuXG4gIGlzVW5kZXRlcm1pbmVkKCkge1xuICAgIHJldHVybiB0cnVlO1xuICB9XG5cbiAgc2hvd0dpdFRhYkxvYWRpbmcoKSB7XG4gICAgcmV0dXJuIHRydWU7XG4gIH1cblxuICBzaG93R2l0VGFiSW5pdCgpIHtcbiAgICByZXR1cm4gZmFsc2U7XG4gIH1cblxuICBoYXNEaXJlY3RvcnkoKSB7XG4gICAgcmV0dXJuIGZhbHNlO1xuICB9XG59XG5cblN0YXRlLnJlZ2lzdGVyKExvYWRpbmdHdWVzcyk7XG4iXX0=