"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareIssueishListController = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _propTypes2 = require("../prop-types");

var _issueishListView = _interopRequireDefault(require("../views/issueish-list-view"));

var _issueish = _interopRequireDefault(require("../models/issueish"));

var _reviewsItem = _interopRequireDefault(require("../items/reviews-item"));

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const StatePropType = _propTypes["default"].oneOf(['EXPECTED', 'PENDING', 'SUCCESS', 'ERROR', 'FAILURE']);

class BareIssueishListController extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "openReviews", async () => {
      /* istanbul ignore next */
      if (this.props.results.length < 1) {
        return;
      }

      const result = this.props.results[0];

      const uri = _reviewsItem["default"].buildURI({
        host: this.props.endpoint.getHost(),
        owner: result.repository.owner.login,
        repo: result.repository.name,
        number: result.number,
        workdir: this.props.workingDirectory
      });

      await this.props.workspace.open(uri);
      (0, _reporterProxy.addEvent)('open-reviews-tab', {
        "package": 'github',
        from: this.constructor.name
      });
    });

    this.state = {};
  }

  static getDerivedStateFromProps(props, state) {
    if (props.results === null) {
      return {
        lastResults: null,
        issueishes: []
      };
    }

    if (props.results !== state.lastResults) {
      return {
        lastResults: props.results,
        issueishes: props.results.map(node => new _issueish["default"](node)).filter(props.resultFilter)
      };
    }

    return null;
  }

  render() {
    return _react["default"].createElement(_issueishListView["default"], {
      title: this.props.title,
      isLoading: this.props.isLoading,
      total: this.props.total,
      issueishes: this.state.issueishes,
      error: this.props.error,
      needReviewsButton: this.props.needReviewsButton,
      onIssueishClick: this.props.onOpenIssueish,
      onMoreClick: this.props.onOpenMore,
      openReviews: this.openReviews,
      emptyComponent: this.props.emptyComponent
    });
  }

}

exports.BareIssueishListController = BareIssueishListController;

_defineProperty(BareIssueishListController, "propTypes", {
  results: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    number: _propTypes["default"].number.isRequired,
    title: _propTypes["default"].string.isRequired,
    url: _propTypes["default"].string.isRequired,
    author: _propTypes["default"].shape({
      login: _propTypes["default"].string.isRequired,
      avatarUrl: _propTypes["default"].string.isRequired
    }),
    createdAt: _propTypes["default"].string.isRequired,
    headRefName: _propTypes["default"].string.isRequired,
    repository: _propTypes["default"].shape({
      id: _propTypes["default"].string.isRequired,
      name: _propTypes["default"].string.isRequired,
      owner: _propTypes["default"].shape({
        login: _propTypes["default"].string.isRequired
      }).isRequired
    }).isRequired,
    commits: _propTypes["default"].shape({
      nodes: _propTypes["default"].arrayOf(_propTypes["default"].shape({
        commit: _propTypes["default"].shape({
          status: _propTypes["default"].shape({
            contexts: _propTypes["default"].arrayOf(_propTypes["default"].shape({
              state: StatePropType.isRequired
            }).isRequired).isRequired
          })
        })
      }))
    })
  })),
  total: _propTypes["default"].number.isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  title: _propTypes["default"].string.isRequired,
  error: _propTypes["default"].object,
  resultFilter: _propTypes["default"].func,
  onOpenIssueish: _propTypes["default"].func.isRequired,
  onOpenMore: _propTypes["default"].func,
  emptyComponent: _propTypes["default"].func,
  workspace: _propTypes["default"].object,
  endpoint: _propTypes2.EndpointPropType,
  workingDirectory: _propTypes["default"].string,
  needReviewsButton: _propTypes["default"].bool
});

_defineProperty(BareIssueishListController, "defaultProps", {
  results: [],
  total: 0,
  resultFilter: () => true
});

var _default = (0, _reactRelay.createFragmentContainer)(BareIssueishListController, {
  results: function () {
    const node = require("./__generated__/issueishListController_results.graphql");

    if (node.hash && node.hash !== "5cd992367edc948370db9a3182449e06") {
      console.error("The definition of 'issueishListController_results' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueishListController_results.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImlzc3VlaXNoLWxpc3QtY29udHJvbGxlci5qcyJdLCJuYW1lcyI6WyJTdGF0ZVByb3BUeXBlIiwiUHJvcFR5cGVzIiwib25lT2YiLCJCYXJlSXNzdWVpc2hMaXN0Q29udHJvbGxlciIsIlJlYWN0IiwiQ29tcG9uZW50IiwiY29uc3RydWN0b3IiLCJwcm9wcyIsInJlc3VsdHMiLCJsZW5ndGgiLCJyZXN1bHQiLCJ1cmkiLCJSZXZpZXdzSXRlbSIsImJ1aWxkVVJJIiwiaG9zdCIsImVuZHBvaW50IiwiZ2V0SG9zdCIsIm93bmVyIiwicmVwb3NpdG9yeSIsImxvZ2luIiwicmVwbyIsIm5hbWUiLCJudW1iZXIiLCJ3b3JrZGlyIiwid29ya2luZ0RpcmVjdG9yeSIsIndvcmtzcGFjZSIsIm9wZW4iLCJmcm9tIiwic3RhdGUiLCJnZXREZXJpdmVkU3RhdGVGcm9tUHJvcHMiLCJsYXN0UmVzdWx0cyIsImlzc3VlaXNoZXMiLCJtYXAiLCJub2RlIiwiSXNzdWVpc2giLCJmaWx0ZXIiLCJyZXN1bHRGaWx0ZXIiLCJyZW5kZXIiLCJ0aXRsZSIsImlzTG9hZGluZyIsInRvdGFsIiwiZXJyb3IiLCJuZWVkUmV2aWV3c0J1dHRvbiIsIm9uT3Blbklzc3VlaXNoIiwib25PcGVuTW9yZSIsIm9wZW5SZXZpZXdzIiwiZW1wdHlDb21wb25lbnQiLCJhcnJheU9mIiwic2hhcGUiLCJpc1JlcXVpcmVkIiwic3RyaW5nIiwidXJsIiwiYXV0aG9yIiwiYXZhdGFyVXJsIiwiY3JlYXRlZEF0IiwiaGVhZFJlZk5hbWUiLCJpZCIsImNvbW1pdHMiLCJub2RlcyIsImNvbW1pdCIsInN0YXR1cyIsImNvbnRleHRzIiwiYm9vbCIsIm9iamVjdCIsImZ1bmMiLCJFbmRwb2ludFByb3BUeXBlIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7Ozs7OztBQUVBLE1BQU1BLGFBQWEsR0FBR0Msc0JBQVVDLEtBQVYsQ0FBZ0IsQ0FBQyxVQUFELEVBQWEsU0FBYixFQUF3QixTQUF4QixFQUFtQyxPQUFuQyxFQUE0QyxTQUE1QyxDQUFoQixDQUF0Qjs7QUFFTyxNQUFNQywwQkFBTixTQUF5Q0Msa0JBQU1DLFNBQS9DLENBQXlEO0FBeUQ5REMsRUFBQUEsV0FBVyxDQUFDQyxLQUFELEVBQVE7QUFDakIsVUFBTUEsS0FBTjs7QUFEaUIseUNBd0JMLFlBQVk7QUFDeEI7QUFDQSxVQUFJLEtBQUtBLEtBQUwsQ0FBV0MsT0FBWCxDQUFtQkMsTUFBbkIsR0FBNEIsQ0FBaEMsRUFBbUM7QUFDakM7QUFDRDs7QUFDRCxZQUFNQyxNQUFNLEdBQUcsS0FBS0gsS0FBTCxDQUFXQyxPQUFYLENBQW1CLENBQW5CLENBQWY7O0FBQ0EsWUFBTUcsR0FBRyxHQUFHQyx3QkFBWUMsUUFBWixDQUFxQjtBQUMvQkMsUUFBQUEsSUFBSSxFQUFFLEtBQUtQLEtBQUwsQ0FBV1EsUUFBWCxDQUFvQkMsT0FBcEIsRUFEeUI7QUFFL0JDLFFBQUFBLEtBQUssRUFBRVAsTUFBTSxDQUFDUSxVQUFQLENBQWtCRCxLQUFsQixDQUF3QkUsS0FGQTtBQUcvQkMsUUFBQUEsSUFBSSxFQUFFVixNQUFNLENBQUNRLFVBQVAsQ0FBa0JHLElBSE87QUFJL0JDLFFBQUFBLE1BQU0sRUFBRVosTUFBTSxDQUFDWSxNQUpnQjtBQUsvQkMsUUFBQUEsT0FBTyxFQUFFLEtBQUtoQixLQUFMLENBQVdpQjtBQUxXLE9BQXJCLENBQVo7O0FBT0EsWUFBTSxLQUFLakIsS0FBTCxDQUFXa0IsU0FBWCxDQUFxQkMsSUFBckIsQ0FBMEJmLEdBQTFCLENBQU47QUFDQSxtQ0FBUyxrQkFBVCxFQUE2QjtBQUFDLG1CQUFTLFFBQVY7QUFBb0JnQixRQUFBQSxJQUFJLEVBQUUsS0FBS3JCLFdBQUwsQ0FBaUJlO0FBQTNDLE9BQTdCO0FBQ0QsS0F2Q2tCOztBQUdqQixTQUFLTyxLQUFMLEdBQWEsRUFBYjtBQUNEOztBQUVELFNBQU9DLHdCQUFQLENBQWdDdEIsS0FBaEMsRUFBdUNxQixLQUF2QyxFQUE4QztBQUM1QyxRQUFJckIsS0FBSyxDQUFDQyxPQUFOLEtBQWtCLElBQXRCLEVBQTRCO0FBQzFCLGFBQU87QUFDTHNCLFFBQUFBLFdBQVcsRUFBRSxJQURSO0FBRUxDLFFBQUFBLFVBQVUsRUFBRTtBQUZQLE9BQVA7QUFJRDs7QUFFRCxRQUFJeEIsS0FBSyxDQUFDQyxPQUFOLEtBQWtCb0IsS0FBSyxDQUFDRSxXQUE1QixFQUF5QztBQUN2QyxhQUFPO0FBQ0xBLFFBQUFBLFdBQVcsRUFBRXZCLEtBQUssQ0FBQ0MsT0FEZDtBQUVMdUIsUUFBQUEsVUFBVSxFQUFFeEIsS0FBSyxDQUFDQyxPQUFOLENBQWN3QixHQUFkLENBQWtCQyxJQUFJLElBQUksSUFBSUMsb0JBQUosQ0FBYUQsSUFBYixDQUExQixFQUE4Q0UsTUFBOUMsQ0FBcUQ1QixLQUFLLENBQUM2QixZQUEzRDtBQUZQLE9BQVA7QUFJRDs7QUFFRCxXQUFPLElBQVA7QUFDRDs7QUFtQkRDLEVBQUFBLE1BQU0sR0FBRztBQUNQLFdBQ0UsZ0NBQUMsNEJBQUQ7QUFDRSxNQUFBLEtBQUssRUFBRSxLQUFLOUIsS0FBTCxDQUFXK0IsS0FEcEI7QUFFRSxNQUFBLFNBQVMsRUFBRSxLQUFLL0IsS0FBTCxDQUFXZ0MsU0FGeEI7QUFHRSxNQUFBLEtBQUssRUFBRSxLQUFLaEMsS0FBTCxDQUFXaUMsS0FIcEI7QUFJRSxNQUFBLFVBQVUsRUFBRSxLQUFLWixLQUFMLENBQVdHLFVBSnpCO0FBS0UsTUFBQSxLQUFLLEVBQUUsS0FBS3hCLEtBQUwsQ0FBV2tDLEtBTHBCO0FBTUUsTUFBQSxpQkFBaUIsRUFBRSxLQUFLbEMsS0FBTCxDQUFXbUMsaUJBTmhDO0FBT0UsTUFBQSxlQUFlLEVBQUUsS0FBS25DLEtBQUwsQ0FBV29DLGNBUDlCO0FBUUUsTUFBQSxXQUFXLEVBQUUsS0FBS3BDLEtBQUwsQ0FBV3FDLFVBUjFCO0FBU0UsTUFBQSxXQUFXLEVBQUUsS0FBS0MsV0FUcEI7QUFVRSxNQUFBLGNBQWMsRUFBRSxLQUFLdEMsS0FBTCxDQUFXdUM7QUFWN0IsTUFERjtBQWNEOztBQWpINkQ7Ozs7Z0JBQW5EM0MsMEIsZUFDUTtBQUNqQkssRUFBQUEsT0FBTyxFQUFFUCxzQkFBVThDLE9BQVYsQ0FDUDlDLHNCQUFVK0MsS0FBVixDQUFnQjtBQUNkMUIsSUFBQUEsTUFBTSxFQUFFckIsc0JBQVVxQixNQUFWLENBQWlCMkIsVUFEWDtBQUVkWCxJQUFBQSxLQUFLLEVBQUVyQyxzQkFBVWlELE1BQVYsQ0FBaUJELFVBRlY7QUFHZEUsSUFBQUEsR0FBRyxFQUFFbEQsc0JBQVVpRCxNQUFWLENBQWlCRCxVQUhSO0FBSWRHLElBQUFBLE1BQU0sRUFBRW5ELHNCQUFVK0MsS0FBVixDQUFnQjtBQUN0QjdCLE1BQUFBLEtBQUssRUFBRWxCLHNCQUFVaUQsTUFBVixDQUFpQkQsVUFERjtBQUV0QkksTUFBQUEsU0FBUyxFQUFFcEQsc0JBQVVpRCxNQUFWLENBQWlCRDtBQUZOLEtBQWhCLENBSk07QUFRZEssSUFBQUEsU0FBUyxFQUFFckQsc0JBQVVpRCxNQUFWLENBQWlCRCxVQVJkO0FBU2RNLElBQUFBLFdBQVcsRUFBRXRELHNCQUFVaUQsTUFBVixDQUFpQkQsVUFUaEI7QUFVZC9CLElBQUFBLFVBQVUsRUFBRWpCLHNCQUFVK0MsS0FBVixDQUFnQjtBQUMxQlEsTUFBQUEsRUFBRSxFQUFFdkQsc0JBQVVpRCxNQUFWLENBQWlCRCxVQURLO0FBRTFCNUIsTUFBQUEsSUFBSSxFQUFFcEIsc0JBQVVpRCxNQUFWLENBQWlCRCxVQUZHO0FBRzFCaEMsTUFBQUEsS0FBSyxFQUFFaEIsc0JBQVUrQyxLQUFWLENBQWdCO0FBQ3JCN0IsUUFBQUEsS0FBSyxFQUFFbEIsc0JBQVVpRCxNQUFWLENBQWlCRDtBQURILE9BQWhCLEVBRUpBO0FBTHVCLEtBQWhCLEVBTVRBLFVBaEJXO0FBaUJkUSxJQUFBQSxPQUFPLEVBQUV4RCxzQkFBVStDLEtBQVYsQ0FBZ0I7QUFDdkJVLE1BQUFBLEtBQUssRUFBRXpELHNCQUFVOEMsT0FBVixDQUFrQjlDLHNCQUFVK0MsS0FBVixDQUFnQjtBQUN2Q1csUUFBQUEsTUFBTSxFQUFFMUQsc0JBQVUrQyxLQUFWLENBQWdCO0FBQ3RCWSxVQUFBQSxNQUFNLEVBQUUzRCxzQkFBVStDLEtBQVYsQ0FBZ0I7QUFDdEJhLFlBQUFBLFFBQVEsRUFBRTVELHNCQUFVOEMsT0FBVixDQUNSOUMsc0JBQVUrQyxLQUFWLENBQWdCO0FBQ2RwQixjQUFBQSxLQUFLLEVBQUU1QixhQUFhLENBQUNpRDtBQURQLGFBQWhCLEVBRUdBLFVBSEssRUFJUkE7QUFMb0IsV0FBaEI7QUFEYyxTQUFoQjtBQUQrQixPQUFoQixDQUFsQjtBQURnQixLQUFoQjtBQWpCSyxHQUFoQixDQURPLENBRFE7QUFrQ2pCVCxFQUFBQSxLQUFLLEVBQUV2QyxzQkFBVXFCLE1BQVYsQ0FBaUIyQixVQWxDUDtBQW1DakJWLEVBQUFBLFNBQVMsRUFBRXRDLHNCQUFVNkQsSUFBVixDQUFlYixVQW5DVDtBQW9DakJYLEVBQUFBLEtBQUssRUFBRXJDLHNCQUFVaUQsTUFBVixDQUFpQkQsVUFwQ1A7QUFxQ2pCUixFQUFBQSxLQUFLLEVBQUV4QyxzQkFBVThELE1BckNBO0FBdUNqQjNCLEVBQUFBLFlBQVksRUFBRW5DLHNCQUFVK0QsSUF2Q1A7QUF3Q2pCckIsRUFBQUEsY0FBYyxFQUFFMUMsc0JBQVUrRCxJQUFWLENBQWVmLFVBeENkO0FBeUNqQkwsRUFBQUEsVUFBVSxFQUFFM0Msc0JBQVUrRCxJQXpDTDtBQTJDakJsQixFQUFBQSxjQUFjLEVBQUU3QyxzQkFBVStELElBM0NUO0FBNENqQnZDLEVBQUFBLFNBQVMsRUFBRXhCLHNCQUFVOEQsTUE1Q0o7QUE2Q2pCaEQsRUFBQUEsUUFBUSxFQUFFa0QsNEJBN0NPO0FBOENqQnpDLEVBQUFBLGdCQUFnQixFQUFFdkIsc0JBQVVpRCxNQTlDWDtBQStDakJSLEVBQUFBLGlCQUFpQixFQUFFekMsc0JBQVU2RDtBQS9DWixDOztnQkFEUjNELDBCLGtCQW1EVztBQUNwQkssRUFBQUEsT0FBTyxFQUFFLEVBRFc7QUFFcEJnQyxFQUFBQSxLQUFLLEVBQUUsQ0FGYTtBQUdwQkosRUFBQUEsWUFBWSxFQUFFLE1BQU07QUFIQSxDOztlQWlFVCx5Q0FBd0JqQywwQkFBeEIsRUFBb0Q7QUFDakVLLEVBQUFBLE9BQU87QUFBQTs7QUFBQTtBQUFBO0FBQUE7O0FBQUE7QUFBQTtBQUQwRCxDQUFwRCxDIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzcuMC9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCB7Z3JhcGhxbCwgY3JlYXRlRnJhZ21lbnRDb250YWluZXJ9IGZyb20gJ3JlYWN0LXJlbGF5JztcbmltcG9ydCB7RW5kcG9pbnRQcm9wVHlwZX0gZnJvbSAnLi4vcHJvcC10eXBlcyc7XG5pbXBvcnQgSXNzdWVpc2hMaXN0VmlldyBmcm9tICcuLi92aWV3cy9pc3N1ZWlzaC1saXN0LXZpZXcnO1xuaW1wb3J0IElzc3VlaXNoIGZyb20gJy4uL21vZGVscy9pc3N1ZWlzaCc7XG5pbXBvcnQgUmV2aWV3c0l0ZW0gZnJvbSAnLi4vaXRlbXMvcmV2aWV3cy1pdGVtJztcbmltcG9ydCB7YWRkRXZlbnR9IGZyb20gJy4uL3JlcG9ydGVyLXByb3h5JztcblxuY29uc3QgU3RhdGVQcm9wVHlwZSA9IFByb3BUeXBlcy5vbmVPZihbJ0VYUEVDVEVEJywgJ1BFTkRJTkcnLCAnU1VDQ0VTUycsICdFUlJPUicsICdGQUlMVVJFJ10pO1xuXG5leHBvcnQgY2xhc3MgQmFyZUlzc3VlaXNoTGlzdENvbnRyb2xsZXIgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBzdGF0aWMgcHJvcFR5cGVzID0ge1xuICAgIHJlc3VsdHM6IFByb3BUeXBlcy5hcnJheU9mKFxuICAgICAgUHJvcFR5cGVzLnNoYXBlKHtcbiAgICAgICAgbnVtYmVyOiBQcm9wVHlwZXMubnVtYmVyLmlzUmVxdWlyZWQsXG4gICAgICAgIHRpdGxlOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgICAgIHVybDogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuICAgICAgICBhdXRob3I6IFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICAgICAgbG9naW46IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICAgICAgICBhdmF0YXJVcmw6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICAgICAgfSksXG4gICAgICAgIGNyZWF0ZWRBdDogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuICAgICAgICBoZWFkUmVmTmFtZTogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuICAgICAgICByZXBvc2l0b3J5OiBQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgICAgIGlkOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgICAgICAgbmFtZTogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuICAgICAgICAgIG93bmVyOiBQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgICAgICAgbG9naW46IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICAgICAgICB9KS5pc1JlcXVpcmVkLFxuICAgICAgICB9KS5pc1JlcXVpcmVkLFxuICAgICAgICBjb21taXRzOiBQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgICAgIG5vZGVzOiBQcm9wVHlwZXMuYXJyYXlPZihQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgICAgICAgY29tbWl0OiBQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgICAgICAgICBzdGF0dXM6IFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICAgICAgICAgICAgY29udGV4dHM6IFByb3BUeXBlcy5hcnJheU9mKFxuICAgICAgICAgICAgICAgICAgUHJvcFR5cGVzLnNoYXBlKHtcbiAgICAgICAgICAgICAgICAgICAgc3RhdGU6IFN0YXRlUHJvcFR5cGUuaXNSZXF1aXJlZCxcbiAgICAgICAgICAgICAgICAgIH0pLmlzUmVxdWlyZWQsXG4gICAgICAgICAgICAgICAgKS5pc1JlcXVpcmVkLFxuICAgICAgICAgICAgICB9KSxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgIH0pKSxcbiAgICAgICAgfSksXG4gICAgICB9KSxcbiAgICApLFxuICAgIHRvdGFsOiBQcm9wVHlwZXMubnVtYmVyLmlzUmVxdWlyZWQsXG4gICAgaXNMb2FkaW5nOiBQcm9wVHlwZXMuYm9vbC5pc1JlcXVpcmVkLFxuICAgIHRpdGxlOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgZXJyb3I6IFByb3BUeXBlcy5vYmplY3QsXG5cbiAgICByZXN1bHRGaWx0ZXI6IFByb3BUeXBlcy5mdW5jLFxuICAgIG9uT3Blbklzc3VlaXNoOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIG9uT3Blbk1vcmU6IFByb3BUeXBlcy5mdW5jLFxuXG4gICAgZW1wdHlDb21wb25lbnQ6IFByb3BUeXBlcy5mdW5jLFxuICAgIHdvcmtzcGFjZTogUHJvcFR5cGVzLm9iamVjdCxcbiAgICBlbmRwb2ludDogRW5kcG9pbnRQcm9wVHlwZSxcbiAgICB3b3JraW5nRGlyZWN0b3J5OiBQcm9wVHlwZXMuc3RyaW5nLFxuICAgIG5lZWRSZXZpZXdzQnV0dG9uOiBQcm9wVHlwZXMuYm9vbCxcbiAgfTtcblxuICBzdGF0aWMgZGVmYXVsdFByb3BzID0ge1xuICAgIHJlc3VsdHM6IFtdLFxuICAgIHRvdGFsOiAwLFxuICAgIHJlc3VsdEZpbHRlcjogKCkgPT4gdHJ1ZSxcbiAgfVxuXG4gIGNvbnN0cnVjdG9yKHByb3BzKSB7XG4gICAgc3VwZXIocHJvcHMpO1xuXG4gICAgdGhpcy5zdGF0ZSA9IHt9O1xuICB9XG5cbiAgc3RhdGljIGdldERlcml2ZWRTdGF0ZUZyb21Qcm9wcyhwcm9wcywgc3RhdGUpIHtcbiAgICBpZiAocHJvcHMucmVzdWx0cyA9PT0gbnVsbCkge1xuICAgICAgcmV0dXJuIHtcbiAgICAgICAgbGFzdFJlc3VsdHM6IG51bGwsXG4gICAgICAgIGlzc3VlaXNoZXM6IFtdLFxuICAgICAgfTtcbiAgICB9XG5cbiAgICBpZiAocHJvcHMucmVzdWx0cyAhPT0gc3RhdGUubGFzdFJlc3VsdHMpIHtcbiAgICAgIHJldHVybiB7XG4gICAgICAgIGxhc3RSZXN1bHRzOiBwcm9wcy5yZXN1bHRzLFxuICAgICAgICBpc3N1ZWlzaGVzOiBwcm9wcy5yZXN1bHRzLm1hcChub2RlID0+IG5ldyBJc3N1ZWlzaChub2RlKSkuZmlsdGVyKHByb3BzLnJlc3VsdEZpbHRlciksXG4gICAgICB9O1xuICAgIH1cblxuICAgIHJldHVybiBudWxsO1xuICB9XG5cbiAgb3BlblJldmlld3MgPSBhc3luYyAoKSA9PiB7XG4gICAgLyogaXN0YW5idWwgaWdub3JlIG5leHQgKi9cbiAgICBpZiAodGhpcy5wcm9wcy5yZXN1bHRzLmxlbmd0aCA8IDEpIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG4gICAgY29uc3QgcmVzdWx0ID0gdGhpcy5wcm9wcy5yZXN1bHRzWzBdO1xuICAgIGNvbnN0IHVyaSA9IFJldmlld3NJdGVtLmJ1aWxkVVJJKHtcbiAgICAgIGhvc3Q6IHRoaXMucHJvcHMuZW5kcG9pbnQuZ2V0SG9zdCgpLFxuICAgICAgb3duZXI6IHJlc3VsdC5yZXBvc2l0b3J5Lm93bmVyLmxvZ2luLFxuICAgICAgcmVwbzogcmVzdWx0LnJlcG9zaXRvcnkubmFtZSxcbiAgICAgIG51bWJlcjogcmVzdWx0Lm51bWJlcixcbiAgICAgIHdvcmtkaXI6IHRoaXMucHJvcHMud29ya2luZ0RpcmVjdG9yeSxcbiAgICB9KTtcbiAgICBhd2FpdCB0aGlzLnByb3BzLndvcmtzcGFjZS5vcGVuKHVyaSk7XG4gICAgYWRkRXZlbnQoJ29wZW4tcmV2aWV3cy10YWInLCB7cGFja2FnZTogJ2dpdGh1YicsIGZyb206IHRoaXMuY29uc3RydWN0b3IubmFtZX0pO1xuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIHJldHVybiAoXG4gICAgICA8SXNzdWVpc2hMaXN0Vmlld1xuICAgICAgICB0aXRsZT17dGhpcy5wcm9wcy50aXRsZX1cbiAgICAgICAgaXNMb2FkaW5nPXt0aGlzLnByb3BzLmlzTG9hZGluZ31cbiAgICAgICAgdG90YWw9e3RoaXMucHJvcHMudG90YWx9XG4gICAgICAgIGlzc3VlaXNoZXM9e3RoaXMuc3RhdGUuaXNzdWVpc2hlc31cbiAgICAgICAgZXJyb3I9e3RoaXMucHJvcHMuZXJyb3J9XG4gICAgICAgIG5lZWRSZXZpZXdzQnV0dG9uPXt0aGlzLnByb3BzLm5lZWRSZXZpZXdzQnV0dG9ufVxuICAgICAgICBvbklzc3VlaXNoQ2xpY2s9e3RoaXMucHJvcHMub25PcGVuSXNzdWVpc2h9XG4gICAgICAgIG9uTW9yZUNsaWNrPXt0aGlzLnByb3BzLm9uT3Blbk1vcmV9XG4gICAgICAgIG9wZW5SZXZpZXdzPXt0aGlzLm9wZW5SZXZpZXdzfVxuICAgICAgICBlbXB0eUNvbXBvbmVudD17dGhpcy5wcm9wcy5lbXB0eUNvbXBvbmVudH1cbiAgICAgIC8+XG4gICAgKTtcbiAgfVxufVxuXG5leHBvcnQgZGVmYXVsdCBjcmVhdGVGcmFnbWVudENvbnRhaW5lcihCYXJlSXNzdWVpc2hMaXN0Q29udHJvbGxlciwge1xuICByZXN1bHRzOiBncmFwaHFsYFxuICAgIGZyYWdtZW50IGlzc3VlaXNoTGlzdENvbnRyb2xsZXJfcmVzdWx0cyBvbiBQdWxsUmVxdWVzdFxuICAgIEByZWxheShwbHVyYWw6IHRydWUpXG4gICAge1xuICAgICAgbnVtYmVyXG4gICAgICB0aXRsZVxuICAgICAgdXJsXG4gICAgICBhdXRob3Ige1xuICAgICAgICBsb2dpblxuICAgICAgICBhdmF0YXJVcmxcbiAgICAgIH1cbiAgICAgIGNyZWF0ZWRBdFxuICAgICAgaGVhZFJlZk5hbWVcblxuICAgICAgcmVwb3NpdG9yeSB7XG4gICAgICAgIGlkXG4gICAgICAgIG5hbWVcbiAgICAgICAgb3duZXIge1xuICAgICAgICAgIGxvZ2luXG4gICAgICAgIH1cbiAgICAgIH1cblxuICAgICAgY29tbWl0cyhsYXN0OjEpIHtcbiAgICAgICAgbm9kZXMge1xuICAgICAgICAgIGNvbW1pdCB7XG4gICAgICAgICAgICBzdGF0dXMge1xuICAgICAgICAgICAgICBjb250ZXh0cyB7XG4gICAgICAgICAgICAgICAgc3RhdGVcbiAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cbiAgYCxcbn0pO1xuIl19