(function() {
  var Bookmarks, BookmarksView, CompositeDisposable, ReactBookmarks, disposables, editorsBookmarks;

  CompositeDisposable = require('atom').CompositeDisposable;

  Bookmarks = null;

  ReactBookmarks = null;

  BookmarksView = require('./bookmarks-view');

  editorsBookmarks = null;

  disposables = null;

  module.exports = {
    activate: function(bookmarksByEditorId) {
      var bookmarksView, watchedEditors;
      editorsBookmarks = [];
      watchedEditors = new WeakSet();
      bookmarksView = null;
      disposables = new CompositeDisposable;
      atom.commands.add('atom-workspace', 'bookmarks:view-all', function() {
        if (bookmarksView == null) {
          bookmarksView = new BookmarksView(editorsBookmarks);
        }
        return bookmarksView.show();
      });
      return atom.workspace.observeTextEditors(function(textEditor) {
        var bookmarks, state;
        if (watchedEditors.has(textEditor)) {
          return;
        }
        if (Bookmarks == null) {
          Bookmarks = require('./bookmarks');
        }
        if (state = bookmarksByEditorId[textEditor.id]) {
          bookmarks = Bookmarks.deserialize(textEditor, state);
        } else {
          bookmarks = new Bookmarks(textEditor);
        }
        editorsBookmarks.push(bookmarks);
        watchedEditors.add(textEditor);
        return disposables.add(textEditor.onDidDestroy(function() {
          var index;
          index = editorsBookmarks.indexOf(bookmarks);
          if (index !== -1) {
            editorsBookmarks.splice(index, 1);
          }
          bookmarks.destroy();
          return watchedEditors["delete"](textEditor);
        }));
      });
    },
    deactivate: function() {
      var bookmarks, i, len;
      if (typeof bookmarksView !== "undefined" && bookmarksView !== null) {
        bookmarksView.destroy();
      }
      for (i = 0, len = editorsBookmarks.length; i < len; i++) {
        bookmarks = editorsBookmarks[i];
        bookmarks.deactivate();
      }
      return disposables.dispose();
    },
    serialize: function() {
      var bookmarks, bookmarksByEditorId, i, len;
      bookmarksByEditorId = {};
      for (i = 0, len = editorsBookmarks.length; i < len; i++) {
        bookmarks = editorsBookmarks[i];
        bookmarksByEditorId[bookmarks.editor.id] = bookmarks.serialize();
      }
      return bookmarksByEditorId;
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
