/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import org.netbeans.modules.profiler.snaptracer.impl.swing.LabelRenderer;

public final class EnhancedLabelRenderer
extends LabelRenderer {
    private static final EnhancedInsets EMPTY_INSETS = new EnhancedInsets();
    private EnhancedInsets marginInsets;
    private EnhancedInsets borderInsets;
    private Border border;
    private Color background;

    public void setMargin(Insets insets) {
        this.marginInsets = insets == null ? EMPTY_INSETS : new EnhancedInsets(insets);
    }

    @Override
    public void setBorder(Border border) {
        this.border = border;
        this.borderInsets = border == null ? EMPTY_INSETS : new EnhancedInsets(border.getBorderInsets(this));
    }

    @Override
    public Border getBorder() {
        return this.border;
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    private EnhancedInsets getMarginInsets() {
        if (this.marginInsets == null) {
            this.marginInsets = EMPTY_INSETS;
        }
        return this.marginInsets;
    }

    private EnhancedInsets getBorderInsets() {
        if (this.borderInsets == null) {
            this.borderInsets = EMPTY_INSETS;
        }
        return this.borderInsets;
    }

    @Override
    protected void prePaint(Graphics graphics, int n, int n2) {
        if (this.background != null) {
            graphics.setColor(this.background);
            EnhancedInsets enhancedInsets = this.getMarginInsets();
            Dimension dimension = this.getPreferredSize();
            graphics.fillRect(n - enhancedInsets.left, n2 - enhancedInsets.top, dimension.width + enhancedInsets.width(), dimension.height + enhancedInsets.height());
        }
    }

    @Override
    protected void postPaint(Graphics graphics, int n, int n2) {
        if (this.border != null) {
            EnhancedInsets enhancedInsets = this.getBorderInsets();
            EnhancedInsets enhancedInsets2 = this.getMarginInsets();
            Dimension dimension = this.getPreferredSize();
            this.border.paintBorder(this, graphics, n - enhancedInsets2.left - enhancedInsets.left, n2 - enhancedInsets2.top - enhancedInsets.top, dimension.width + enhancedInsets2.width() + enhancedInsets.width(), dimension.height + enhancedInsets2.height() + enhancedInsets.height());
        }
    }

    private static class EnhancedInsets
    extends Insets {
        public EnhancedInsets() {
            this(0, 0, 0, 0);
        }

        public EnhancedInsets(Insets insets) {
            this(insets.top, insets.left, insets.bottom, insets.right);
        }

        public EnhancedInsets(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
        }

        public int width() {
            return this.left + this.right;
        }

        public int height() {
            return this.top + this.bottom;
        }
    }
}

