
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was LibRingQtConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../usr" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

INCLUDE(GNUInstallDirs)

SET(LIB_RING_QT_INCLUDE_DIR /usr/include/libringqt)

# First, always set the dynamic path
SET(CMAKE_FIND_LIBRARY_SUFFIXES ".dylib;.so;.dll")
SET(LIB_RING_QT_LIBRARY_NAME "ringqt")

FIND_LIBRARY(LIB_RING_QT_LIBRARY NAMES ringqt
            PATHS ${RING_BUILD_DIR}/.libs
            PATHS 
            PATHS ${CMAKE_INSTALL_PREFIX}/libexec )

#if ENABLE_STATIC is set, default to the static version
IF(NOT LIB_RING_QT_LIBRARY OR DEFINED ${ENABLE_STATIC} OR ${ENABLE_STATIC} MATCHES true)
   SET(CMAKE_FIND_LIBRARY_SUFFIXES ".a;.la;.lib")
   SET(LIB_RING_QT_LIBRARY_NAME "ringqt")

   FIND_LIBRARY(LIB_RING_QT_LIBRARY NAMES ringqt
             PATHS ${RING_BUILD_DIR}/.libs
             PATHS 
             PATHS ${CMAKE_INSTALL_PREFIX}/libexec )
ENDIF()

FIND_LIBRARY(LIB_RING_QT_LIBRARY NAMES ${LIB_RING_QT_LIBRARY_NAME}
             PATHS ${RING_BUILD_DIR}/.libs
             PATHS 
             PATHS ${CMAKE_INSTALL_PREFIX}/libexec )


# Set the usual CMake library variables. This is required for some other official
# cmake macros to work
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(LIB_RING_QT
    FOUND_VAR
        LIB_RING_QT_FOUND
    REQUIRED_VARS
        LIB_RING_QT_LIBRARY
        LIB_RING_QT_INCLUDE_DIR
    VERSION_VAR
        1.0.0
)

# This isn't pretty, and the blame is on me. I was clueless when I first
# wrote this file and got something wrong. `LIB_RING_QT` doesn't match the
# project name in `ring-lrc/CMakeLists.txt`. This causes problems when the
# ring-lrc Git repository is used in CMake external projects. Given
# changing it above would break the API, it instead add a second target
# with the proper name.

SET(ringqt_LIBRARY ${LIB_RING_QT_LIBRARY})
SET(ringqt_INCLUDE_DIR ${LIB_RING_QT_INCLUDE_DIR})
SET(ringqt_INCLUDES ${LIB_RING_QT_INCLUDE_DIR}) #compat

FIND_PACKAGE_HANDLE_STANDARD_ARGS(ringqt
    FOUND_VAR
        ringqt_FOUND
    REQUIRED_VARS
        ringqt_LIBRARY
        ringqt_INCLUDE_DIR
    VERSION_VAR
        1.0.0
)

if(NOT TARGET ringqt AND NOT ringqt_BINARY_DIR)
  include("/usr/lib/cmake/LibRingQt/LibRingQtTargets.cmake")
endif()
