/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.hint.DocumentFragmentTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentFragment;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

class FoldingPopupManager
implements EditorMouseListener,
EditorMouseMotionListener {
    private static final TooltipGroup FOLDING_TOOLTIP_GROUP = new TooltipGroup("FOLDING_TOOLTIP_GROUP", 10);
    private static final int TOOLTIP_DELAY_MS = 300;
    private final Alarm myAlarm;

    FoldingPopupManager(EditorImpl editor) {
        this.myAlarm = new Alarm(editor.getDisposable());
        editor.addEditorMouseListener(this);
        editor.addEditorMouseMotionListener(this);
    }

    public void mouseMoved(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(0);
        }
        this.myAlarm.cancelAllRequests();
        Editor editor = e.getEditor();
        if (e.getArea() == EditorMouseEventArea.EDITING_AREA) {
            MouseEvent mouseEvent = e.getMouseEvent();
            Point point = mouseEvent.getPoint();
            FoldRegion fold = ((EditorEx)editor).getFoldingModel().getFoldingPlaceholderAt(point);
            TooltipController controller = TooltipController.getInstance();
            if (fold != null && !fold.shouldNeverExpand()) {
                this.myAlarm.addRequest(() -> {
                    if (!editor.getComponent().isShowing() || !fold.isValid() || fold.isExpanded()) {
                        return;
                    }
                    DocumentFragment range2 = FoldingPopupManager.createDocumentFragment(fold);
                    Point p = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, editor.getComponent().getRootPane().getLayeredPane());
                    controller.showTooltip(editor, p, new DocumentFragmentTooltipRenderer(range2), false, FOLDING_TOOLTIP_GROUP);
                }, 300);
            } else {
                controller.cancelTooltip(FOLDING_TOOLTIP_GROUP, mouseEvent, true);
            }
        }
    }

    @NotNull
    private static DocumentFragment createDocumentFragment(@NotNull FoldRegion fold) {
        int groupEndOffset;
        if (fold == null) {
            FoldingPopupManager.$$$reportNull$$$0(1);
        }
        EditorImpl editor = (EditorImpl)fold.getEditor();
        DocumentEx document = editor.getDocument();
        FoldingGroup group = fold.getGroup();
        int startOffset = fold.getStartOffset();
        int endOffset = fold.getEndOffset();
        if (group != null && editor.offsetToVisualLine(groupEndOffset = editor.getFoldingModel().getEndOffset(group)) == editor.offsetToVisualLine(startOffset)) {
            endOffset = groupEndOffset;
        }
        DocumentFragment documentFragment = new DocumentFragment((Document)document, startOffset, endOffset);
        if (documentFragment == null) {
            FoldingPopupManager.$$$reportNull$$$0(2);
        }
        return documentFragment;
    }

    public void mouseExited(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(3);
        }
        this.myAlarm.cancelAllRequests();
        TooltipController.getInstance().cancelTooltip(FOLDING_TOOLTIP_GROUP, e.getMouseEvent(), true);
    }

    public void mouseDragged(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(4);
        }
    }

    public void mousePressed(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(5);
        }
    }

    public void mouseClicked(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(6);
        }
    }

    public void mouseReleased(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(7);
        }
    }

    public void mouseEntered(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(8);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fold";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/FoldingPopupManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/FoldingPopupManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocumentFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mouseMoved";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createDocumentFragment";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mouseExited";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "mouseDragged";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mousePressed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mouseClicked";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mouseReleased";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mouseEntered";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

