/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.DocPreviewUtil;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.ui.content.Content;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SingleAlarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickDocUtil {
    public static final Object CUT_AT_CMD = ObjectUtils.sentinel((String)"CUT_AT_CMD");

    public static void updateQuickDoc(@NotNull Project project, @NotNull PsiElement element, @Nullable String documentation) {
        if (project == null) {
            QuickDocUtil.$$$reportNull$$$0(0);
        }
        if (element == null) {
            QuickDocUtil.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty((String)documentation)) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            DocumentationComponent component = QuickDocUtil.getActiveDocComponent(project);
            if (component != null) {
                component.replaceText(documentation, element);
            }
        });
    }

    @Nullable
    public static DocumentationComponent getActiveDocComponent(@NotNull Project project) {
        DocumentationComponent component;
        DocumentationManager documentationManager;
        JBPopup hint;
        if (project == null) {
            QuickDocUtil.$$$reportNull$$$0(2);
        }
        if ((hint = (documentationManager = DocumentationManager.getInstance(project)).getDocInfoHint()) != null) {
            component = (DocumentationComponent)((AbstractPopup)hint).getComponent();
        } else if (documentationManager.hasActiveDockedDocWindow()) {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.DOCUMENTATION);
            Content selectedContent = toolWindow == null ? null : toolWindow.getContentManager().getSelectedContent();
            component = selectedContent == null ? null : (DocumentationComponent)selectedContent.getComponent();
        } else {
            component = null;
        }
        return component;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean runInReadActionWithWriteActionPriorityWithRetries(@NotNull Runnable action, long timeout, long pauseBetweenRetries, @Nullable ProgressIndicator progressIndicator) {
        void progressIndicator2;
        boolean result2;
        if (action == null) {
            QuickDocUtil.$$$reportNull$$$0(3);
        }
        long deadline = System.currentTimeMillis() + timeout;
        while (!((result2 = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(action, progressIndicator2 == null ? null : new SensitiveProgressWrapper((ProgressIndicator)progressIndicator2))) || progressIndicator2 != null && progressIndicator2.isCanceled() || System.currentTimeMillis() >= deadline)) {
            try {
                TimeUnit.MILLISECONDS.sleep(pauseBetweenRetries);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return result2;
    }

    @Contract(value="_, _, _, null -> null")
    public static String inferLinkFromFullDocumentation(@NotNull DocumentationProvider provider, PsiElement element, PsiElement originalElement, @Nullable String navigationInfo) {
        if (provider == null) {
            QuickDocUtil.$$$reportNull$$$0(4);
        }
        if (navigationInfo != null) {
            String fqn = element instanceof PsiQualifiedNamedElement ? ((PsiQualifiedNamedElement)element).getQualifiedName() : null;
            String fullText = provider.generateDoc(element, originalElement);
            return HintUtil.prepareHintText(DocPreviewUtil.buildPreview(navigationInfo, fqn, fullText), HintUtil.getInformationHint());
        }
        return null;
    }

    public static void updateQuickDocAsync(@NotNull PsiElement element, @NotNull CharSequence prefix, @NotNull Consumer<Consumer<Object>> provider) {
        if (element == null) {
            QuickDocUtil.$$$reportNull$$$0(5);
        }
        if (prefix == null) {
            QuickDocUtil.$$$reportNull$$$0(6);
        }
        if (provider == null) {
            QuickDocUtil.$$$reportNull$$$0(7);
        }
        Project project = element.getProject();
        StringBuilder sb = new StringBuilder(prefix);
        ConcurrentLinkedQueue queue2 = new ConcurrentLinkedQueue();
        Disposable alarmDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)project, (Disposable)alarmDisposable);
        AtomicBoolean stop2 = new AtomicBoolean(false);
        Ref cutAt = Ref.create(null);
        SingleAlarm alarm = new SingleAlarm(() -> {
            String prevText;
            String newText;
            DocumentationComponent component = QuickDocUtil.getActiveDocComponent(project);
            if (component == null) {
                stop2.set(true);
                Disposer.dispose((Disposable)alarmDisposable);
                return;
            }
            Object s = queue2.poll();
            while (s != null) {
                if (s == CUT_AT_CMD || cutAt.get() == CUT_AT_CMD) {
                    cutAt.set(s);
                    s = "";
                } else if (!cutAt.isNull()) {
                    int idx = StringUtil.indexOf((CharSequence)sb, (CharSequence)cutAt.get().toString());
                    if (idx >= 0) {
                        sb.setLength(idx);
                    }
                    cutAt.set(null);
                }
                sb.append(s);
                s = queue2.poll();
            }
            if (stop2.get()) {
                Disposer.dispose((Disposable)alarmDisposable);
            }
            if (!Comparing.equal((String)(newText = sb.toString() + "<br><br><br>"), (String)(prevText = component.getText()))) {
                component.replaceText(newText, element);
            }
        }, 100, alarmDisposable);
        AppExecutorUtil.getAppExecutorService().submit(() -> {
            try {
                provider.consume(str -> {
                    ProgressManager.checkCanceled();
                    if (stop2.get()) {
                        throw new ProcessCanceledException();
                    }
                    queue2.add(str);
                    alarm.cancelAndRequest();
                });
            }
            finally {
                if (stop2.compareAndSet(false, true)) {
                    alarm.cancelAndRequest();
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/QuickDocUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateQuickDoc";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getActiveDocComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "runInReadActionWithWriteActionPriorityWithRetries";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "inferLinkFromFullDocumentation";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "updateQuickDocAsync";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

