/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.mp3;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.HashMap;
import javax.sound.sampled.AudioFormat;

public class MP3ElementaryInputStream
extends FilterInputStream {
    public static final AudioFormat.Encoding MP3 = new AudioFormat.Encoding("MP3");
    private Frame frame;
    private long pos;
    private static final int[][] BIT_RATES = new int[][]{{-1, -1, -1, -1, -1}, {32, 32, 32, 32, 8}, {64, 48, 40, 48, 16}, {96, 56, 48, 56, 24}, {128, 64, 56, 64, 32}, {160, 80, 64, 80, 40}, {192, 96, 80, 96, 48}, {224, 112, 96, 112, 56}, {256, 128, 112, 128, 64}, {288, 160, 128, 144, 80}, {320, 192, 160, 160, 96}, {352, 224, 192, 176, 112}, {384, 256, 224, 192, 128}, {416, 320, 256, 224, 144}, {448, 384, 320, 256, 160}, {-2, -2, -2, -2, -2}};
    private static final int[][] SAMPLE_RATES = new int[][]{{44100, 22050, 11025}, {48000, 24000, 12000}, {32000, 16000, 8000}, {-1, -1, -1}};

    public MP3ElementaryInputStream(File file) throws IOException {
        super(new PushbackInputStream(new BufferedInputStream(new FileInputStream(file)), 6));
    }

    public MP3ElementaryInputStream(InputStream inputStream) {
        super(new PushbackInputStream(inputStream, 6));
    }

    public Frame getNextFrame() throws IOException {
        block14: {
            int n;
            int n2;
            int n3;
            int n4;
            while (this.frame != null && this.pos < this.frame.getBodyOffset() + (long)this.frame.getBodySize()) {
                long l = this.skip(this.frame.getBodyOffset() + (long)this.frame.getBodySize() - this.pos);
                if (l < 0L) break;
            }
            while (true) {
                int n5;
                if ((n5 = this.read0()) == -1) {
                    this.frame = null;
                    break block14;
                }
                if (n5 != 255) continue;
                n4 = n5;
                n3 = this.read0();
                if (n3 == -1 || (n3 & 0xE0) != 224) continue;
                n2 = this.read0();
                n = this.read0();
                if (n == -1) continue;
                this.frame = new Frame(n4 << 24 | n3 << 16 | n2 << 8 | n);
                if (this.frame.getBitRate() != -1 && this.frame.getLayer() != -1 && this.frame.getSampleRate() != -1) break;
                PushbackInputStream pushbackInputStream = (PushbackInputStream)this.in;
                pushbackInputStream.unread(n);
                pushbackInputStream.unread(n2);
                pushbackInputStream.unread(n3);
                this.pos -= 3L;
            }
            int n6 = -1;
            int n7 = -1;
            if (this.frame.hasCRC()) {
                n6 = this.read0();
                n7 = this.read0();
                if (n7 == -1) {
                    throw new EOFException();
                }
                this.frame.crc = n6 << 8 | n7;
            }
            this.frame.bodyOffset = this.pos;
            if (this.frame.getBitRate() <= 0 || this.frame.getSampleRate() <= 0) {
                this.frame.bodySize = 0;
            } else if (this.frame.getLayer() == 1) {
                this.frame.bodySize = (int)(12000L * (long)this.frame.getBitRate() / (long)this.frame.getSampleRate() * 4L) - this.frame.getHeaderSize() + this.frame.getPaddingSize();
            } else if (this.frame.getLayer() == 2 || this.frame.getLayer() == 3) {
                if (this.frame.getChannelCount() == 1) {
                    this.frame.bodySize = (int)(72000L * (long)this.frame.getBitRate() / (long)(this.frame.getSampleRate() + this.frame.getPaddingSize())) - this.frame.getHeaderSize() + this.frame.getPaddingSize();
                } else {
                    this.frame.bodySize = (int)(144000L * (long)this.frame.getBitRate() / (long)(this.frame.getSampleRate() + this.frame.getPaddingSize())) - this.frame.getHeaderSize() + this.frame.getPaddingSize();
                }
            }
            PushbackInputStream pushbackInputStream = (PushbackInputStream)this.in;
            if (this.frame.hasCRC()) {
                pushbackInputStream.unread(n7);
                pushbackInputStream.unread(n6);
                this.pos -= 2L;
            }
            pushbackInputStream.unread(n);
            pushbackInputStream.unread(n2);
            pushbackInputStream.unread(n3);
            pushbackInputStream.unread(n4);
            this.pos -= 4L;
            assert (this.pos == this.frame.getFrameOffset()) : String.valueOf(this.pos) + "!=" + this.frame.getFrameOffset();
        }
        return this.frame;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public AudioFormat getFormat() {
        if (this.frame == null) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("vbr", true);
        return new AudioFormat(MP3, this.frame.getSampleRate(), this.frame.getSampleSize(), this.frame.getChannelCount(), this.frame.getFrameSize(), this.frame.getFrameRate(), true, hashMap);
    }

    private int read0() throws IOException {
        int n = super.read();
        if (n != -1) {
            ++this.pos;
        }
        return n;
    }

    @Override
    public int read() throws IOException {
        if (this.frame == null || this.pos >= this.frame.getBodyOffset() + (long)this.frame.getBodySize()) {
            return -1;
        }
        return this.read0();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.frame == null) {
            return -1;
        }
        int n3 = (int)(this.frame.getBodyOffset() + (long)this.frame.getBodySize() - this.pos);
        if (n3 < 1) {
            return -1;
        }
        int n4 = super.read(byArray, n, n2 = Math.min(n3, n2));
        if (n4 != -1) {
            this.pos += (long)n4;
        }
        return n4;
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.in.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) {
                throw new EOFException();
            }
            n3 += n4;
            this.pos += (long)n4;
        }
    }

    @Override
    public long skip(long l) throws IOException {
        if (this.frame == null) {
            return -1L;
        }
        int n = (int)(this.frame.getBodyOffset() + (long)this.frame.getBodySize() - this.pos);
        if (n < 1) {
            return -1L;
        }
        long l2 = this.in.skip(l = Math.min((long)n, l));
        if (l2 > 0L) {
            this.pos += l2;
        }
        return l2;
    }

    public long getStreamPosition() {
        return this.pos;
    }

    public static class Frame {
        private int header;
        private int crc;
        private int bodySize;
        private long bodyOffset;

        public Frame(int n) {
            this.header = n;
        }

        public int getHeader() {
            return this.header;
        }

        public int getVersion() {
            switch (this.getVersionCode()) {
                case 0: {
                    return 25;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 1;
                }
            }
            return -1;
        }

        public int getVersionCode() {
            return this.header >>> 19 & 3;
        }

        public int getLayer() {
            switch (this.getLayerCode()) {
                case 1: {
                    return 3;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 1;
                }
            }
            return -1;
        }

        public int getLayerCode() {
            return this.header >>> 17 & 3;
        }

        public int getBitRate() {
            int n;
            if (this.getVersion() < 0 || this.getLayer() < 0) {
                return -1;
            }
            int n2 = n = this.getVersion() == 1 ? 0 : 3;
            int n3 = this.getVersion() == 1 ? this.getLayer() - 1 : (this.getLayer() == 1 ? 0 : 1);
            return BIT_RATES[this.getBitRateCode()][n + n3];
        }

        public int getBitRateCode() {
            return this.header >>> 12 & 0xF;
        }

        public boolean hasCRC() {
            return (this.header >>> 16 & 1) == 0;
        }

        public int getCRC() {
            return this.crc;
        }

        public boolean hasPadding() {
            return (this.header >>> 9 & 1) == 1;
        }

        public int getSampleRate() {
            if (this.getVersion() < 0 || this.getLayer() < 0) {
                return -1;
            }
            int n = this.getVersion() == 25 ? 2 : this.getVersion() - 1;
            return SAMPLE_RATES[this.getSampleRateCode()][n];
        }

        public int getSampleRateCode() {
            return this.header >>> 10 & 3;
        }

        public int getSampleCount() {
            if (this.getLayer() < 0) {
                return -1;
            }
            return (this.getLayer() == 1 ? 192 : 576) * this.getChannelCount();
        }

        public int getChannelCount() {
            return this.getChannelModeCode() == 3 ? 1 : 2;
        }

        public int getSampleSize() {
            return 16;
        }

        public int getChannelModeCode() {
            return this.header >>> 6 & 3;
        }

        public byte[] headerToByteArray() {
            byte[] byArray = new byte[this.hasCRC() ? 6 : 4];
            this.headerToByteArray(byArray, 0);
            return byArray;
        }

        public int headerToByteArray(byte[] byArray, int n) {
            if (byArray.length - n < this.getHeaderSize()) {
                throw new IllegalArgumentException("data array is too small");
            }
            byArray[n + 0] = (byte)(this.header >>> 24);
            byArray[n + 1] = (byte)(this.header >>> 16);
            byArray[n + 2] = (byte)(this.header >>> 8);
            byArray[n + 3] = (byte)(this.header >>> 0);
            if (this.hasCRC()) {
                byArray[n + 4] = (byte)(this.crc >>> 8);
                byArray[n + 5] = (byte)(this.crc >>> 0);
            }
            return this.getHeaderSize();
        }

        public void writeHeader(OutputStream outputStream) throws IOException {
            outputStream.write(this.header >>> 24);
            outputStream.write(this.header >>> 16);
            outputStream.write(this.header >>> 8);
            outputStream.write(this.header >>> 0);
            if (this.hasCRC()) {
                outputStream.write(this.crc >>> 8);
                outputStream.write(this.crc >>> 0);
            }
        }

        public long getFrameOffset() {
            return this.getBodyOffset() - (long)this.getHeaderSize();
        }

        public int getFrameSize() {
            return this.getHeaderSize() + this.getBodySize();
        }

        public long getHeaderOffset() {
            return this.getFrameOffset();
        }

        public int getHeaderSize() {
            return this.hasCRC() ? 6 : 4;
        }

        public long getSideInfoOffset() {
            return this.bodyOffset;
        }

        public int getSideInfoSize() {
            return this.getChannelCount() == 1 ? 17 : 32;
        }

        public long getBodyOffset() {
            return this.bodyOffset;
        }

        public int getBodySize() {
            return this.bodySize;
        }

        public int getPaddingSize() {
            if (this.hasPadding()) {
                return this.getLayer() == 1 ? 4 : 1;
            }
            return 0;
        }

        private float getFrameRate() {
            return (float)this.getSampleRate() / (float)this.getSampleCount();
        }
    }
}

