# AsyncOverheadBenchmark
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L90)</span>

Default benchmark for measuring asynchronous overhead.


```pony
class iso AsyncOverheadBenchmark is
  AsyncMicroBenchmark iso
```

#### Implements

* [AsyncMicroBenchmark](ponybench-AsyncMicroBenchmark.md) iso

---

## Constructors

### create
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L90)</span>


```pony
new iso create()
: AsyncOverheadBenchmark iso^
```

#### Returns

* [AsyncOverheadBenchmark](ponybench-AsyncOverheadBenchmark.md) iso^

---

## Public Functions

### name
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L94)</span>


```pony
fun box name()
: String val
```

#### Returns

* [String](builtin-String.md) val

---

### apply
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L97)</span>


```pony
fun ref apply(
  c: AsyncBenchContinue val)
: None val
```
#### Parameters

*   c: [AsyncBenchContinue](ponybench-AsyncBenchContinue.md) val

#### Returns

* [None](builtin-None.md) val

---

### config
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L41)</span>


```pony
fun box config()
: BenchConfig val
```

#### Returns

* [BenchConfig](ponybench-BenchConfig.md) val

---

### overhead
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L42)</span>


```pony
fun box overhead()
: AsyncMicroBenchmark iso^
```

#### Returns

* [AsyncMicroBenchmark](ponybench-AsyncMicroBenchmark.md) iso^

---

### before
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L43)</span>


```pony
fun ref before(
  c: AsyncBenchContinue val)
: None val
```
#### Parameters

*   c: [AsyncBenchContinue](ponybench-AsyncBenchContinue.md) val

#### Returns

* [None](builtin-None.md) val

---

### before_iteration
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L44)</span>


```pony
fun ref before_iteration(
  c: AsyncBenchContinue val)
: None val
```
#### Parameters

*   c: [AsyncBenchContinue](ponybench-AsyncBenchContinue.md) val

#### Returns

* [None](builtin-None.md) val

---

### after
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L46)</span>


```pony
fun ref after(
  c: AsyncBenchContinue val)
: None val
```
#### Parameters

*   c: [AsyncBenchContinue](ponybench-AsyncBenchContinue.md) val

#### Returns

* [None](builtin-None.md) val

---

### after_iteration
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L47)</span>


```pony
fun ref after_iteration(
  c: AsyncBenchContinue val)
: None val
```
#### Parameters

*   c: [AsyncBenchContinue](ponybench-AsyncBenchContinue.md) val

#### Returns

* [None](builtin-None.md) val

---

