/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import org.netbeans.lib.profiler.heap.ArrayItemValue;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.ObjectArrayDump;

class HprofArrayValue
extends HprofObject
implements ArrayItemValue {
    final ClassDump dumpClass;
    final int index;

    HprofArrayValue(ClassDump cls, long offset, int number) {
        super(offset + (long)number + 1L);
        this.dumpClass = cls;
        this.index = number;
    }

    @Override
    public Instance getDefiningInstance() {
        return new ObjectArrayDump(this.dumpClass, this.getInstanceArrayOffset());
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Instance getInstance() {
        HprofHeap heap = this.dumpClass.getHprof();
        HprofByteBuffer dumpBuffer = heap.dumpBuffer;
        int idSize = dumpBuffer.getIDSize();
        long instanceId = dumpBuffer.getID(this.getInstanceArrayOffset() + 1L + (long)idSize + 4L + 4L + (long)idSize + (long)this.index * (long)idSize);
        return heap.getInstanceByID(instanceId);
    }

    private long getInstanceArrayOffset() {
        return this.fileOffset - (long)this.index - 1L;
    }
}

