/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.impl.Utilities;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public final class MultiModule
implements PropertyChangeListener {
    public static final String PROP_MODULES = "modules";
    private static final List<Entry> knownRoots = new LinkedList<Entry>();
    private final SourceRoots moduleRoots;
    private final SourceRoots srcRoots;
    private final AtomicReference<Map<String, Pair<ClassPath, CPImpl>>> cpCache;
    private final AtomicReference<ClassPath> mpCache;
    private final PropertyChangeSupport listeners;

    private MultiModule(@NonNull SourceRoots moduleRoots, @NonNull SourceRoots srcRoots) {
        Parameters.notNull((CharSequence)"moduleRoots", (Object)moduleRoots);
        Parameters.notNull((CharSequence)"srcRoots", (Object)srcRoots);
        this.moduleRoots = moduleRoots;
        this.srcRoots = srcRoots;
        this.cpCache = new AtomicReference(Collections.emptyMap());
        this.mpCache = new AtomicReference();
        this.listeners = new PropertyChangeSupport(this);
        this.moduleRoots.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.moduleRoots));
        this.srcRoots.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.srcRoots));
        this.updateCache();
    }

    @NonNull
    public Collection<? extends String> getModuleNames() {
        return Collections.unmodifiableSet(this.getCache().keySet());
    }

    @CheckForNull
    public String getModuleName(@NonNull FileObject artifact) {
        return this.findImpl(artifact).map(p -> (String)p.first()).orElse(null);
    }

    @CheckForNull
    public ClassPath getModuleSources(@NonNull String moduleName) {
        return Optional.ofNullable(this.getCache().get(moduleName)).map(p -> (ClassPath)p.first()).orElse(null);
    }

    @CheckForNull
    public ClassPath getModuleSources(@NonNull FileObject artifact) {
        return this.findImpl(artifact).map(p -> (ClassPath)p.second()).orElse(null);
    }

    @NonNull
    public ClassPath getSourceModulePath() {
        ClassPath mp = this.mpCache.get();
        if (mp == null && !this.mpCache.compareAndSet(null, mp = ClassPathFactory.createClassPath((ClassPathImplementation)new MPImpl(this.moduleRoots)))) {
            mp = this.mpCache.get();
        }
        return mp;
    }

    public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (SourceRoots.PROP_ROOTS.equals(propName)) {
            ProjectManager.mutex().postReadRequest(() -> this.updateCache());
        }
    }

    @NonNull
    private Optional<Pair<String, ClassPath>> findImpl(@NonNull FileObject artifact) {
        Map<String, Pair<ClassPath, CPImpl>> data = this.getCache();
        URL artifactURL = artifact.toURL();
        for (Map.Entry<String, Pair<ClassPath, CPImpl>> e : data.entrySet()) {
            ClassPath cp = (ClassPath)e.getValue().first();
            for (ClassPath.Entry cpe : cp.entries()) {
                if (!Utilities.isParentOf(cpe.getURL(), artifactURL)) continue;
                return Optional.of(Pair.of((Object)e.getKey(), (Object)cp));
            }
        }
        return Optional.empty();
    }

    @NonNull
    private Map<String, Pair<ClassPath, CPImpl>> getCache() {
        return this.cpCache.get();
    }

    private void updateCache() {
        Map<String, Pair<ClassPath, CPImpl>> prev = this.cpCache.get();
        HashMap<String, Collection<URL>> modulesByName = new HashMap<String, Collection<URL>>();
        for (FileObject moduleRoot : this.moduleRoots.getRoots()) {
            MultiModule.collectModuleRoots(moduleRoot, this.srcRoots.getRootURLs(), modulesByName);
        }
        HashSet<String> toKeep = new HashSet<String>(prev.keySet());
        HashSet<String> toRemove = new HashSet<String>(prev.keySet());
        HashSet toAdd = new HashSet(modulesByName.keySet());
        boolean fire = toKeep.retainAll(modulesByName.keySet());
        toRemove.removeAll(modulesByName.keySet());
        toAdd.removeAll(prev.keySet());
        fire |= !toAdd.isEmpty();
        HashMap<String, Object> next = new HashMap<String, Object>();
        for (String modName : toKeep) {
            next.put(modName, prev.get(modName));
        }
        for (String modName : toAdd) {
            CPImpl impl = new CPImpl((Collection)modulesByName.get(modName));
            ClassPath cp = ClassPathFactory.createClassPath((ClassPathImplementation)impl);
            next.put(modName, Pair.of((Object)cp, (Object)impl));
        }
        if (this.cpCache.compareAndSet(prev, next)) {
            if (fire) {
                this.listeners.firePropertyChange(PROP_MODULES, prev.keySet(), next.keySet());
            }
            for (String modName : toKeep) {
                ((CPImpl)((Pair)next.get(modName)).second()).update((Collection)modulesByName.get(modName));
            }
            for (String modName : toRemove) {
                ((CPImpl)prev.get(modName).second()).update(Collections.emptyList());
            }
        }
    }

    private static void collectModuleRoots(@NonNull FileObject moduleRoot, @NonNull URL[] srcRoots, @NonNull Map<String, Collection<URL>> collector) {
        Arrays.stream(moduleRoot.getChildren()).filter(fo -> fo.isFolder() && !fo.getName().startsWith(".")).forEach(module -> {
            URL moduleUrl = module.toURL();
            String moduleName = module.getNameExt();
            for (URL src : srcRoots) {
                if (!Utilities.isParentOf(moduleUrl, src)) continue;
                ArrayList<URL> roots = (ArrayList<URL>)collector.get(moduleName);
                if (roots == null) {
                    roots = new ArrayList<URL>();
                    collector.put(moduleName, roots);
                }
                roots.add(src);
            }
        });
    }

    @NonNull
    public static MultiModule create(@NonNull SourceRoots moduleRoots, @NonNull SourceRoots srcRoots) {
        return new MultiModule(moduleRoots, srcRoots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static MultiModule getOrCreate(@NonNull SourceRoots moduleRoots, @NonNull SourceRoots srcRoots) {
        Parameters.notNull((CharSequence)"moduleRoots", (Object)moduleRoots);
        Parameters.notNull((CharSequence)"srcRoots", (Object)srcRoots);
        List<Entry> list = knownRoots;
        synchronized (list) {
            Entry e;
            Iterator<Entry> it = knownRoots.iterator();
            while (it.hasNext()) {
                try {
                    e = it.next();
                    if (!e.matches(moduleRoots, srcRoots)) continue;
                    return e.getModel();
                }
                catch (NoSuchElementException r) {
                    it.remove();
                }
            }
            MultiModule model = MultiModule.create(moduleRoots, srcRoots);
            e = new Entry(moduleRoots, srcRoots, model);
            knownRoots.add(e);
            return model;
        }
    }

    private static final class MPImpl
    implements ClassPathImplementation,
    PropertyChangeListener {
        private final SourceRoots roots;
        private final PropertyChangeSupport listeners;
        private final AtomicReference<List<PathResourceImplementation>> cache;

        MPImpl(@NonNull SourceRoots roots) {
            this.roots = roots;
            this.listeners = new PropertyChangeSupport(this);
            this.cache = new AtomicReference();
            this.roots.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.roots));
        }

        public List<? extends PathResourceImplementation> getResources() {
            List<Object> res = this.cache.get();
            if (res == null) {
                res = Collections.unmodifiableList(Arrays.stream(this.roots.getRootURLs()).map(url -> ClassPathSupport.createResource((URL)url)).collect(Collectors.toList()));
                this.cache.set(res);
            }
            return res;
        }

        public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
            this.listeners.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.listeners.removePropertyChangeListener(listener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (SourceRoots.PROP_ROOTS.equals(evt.getPropertyName())) {
                this.cache.set(null);
                this.listeners.firePropertyChange("resources", null, null);
            }
        }
    }

    private static final class CPImpl
    implements ClassPathImplementation {
        private final PropertyChangeSupport listeners;
        private final AtomicReference<List<? extends PathResourceImplementation>> cache;

        CPImpl(Collection<? extends URL> roots) {
            this.cache = new AtomicReference(Collections.unmodifiableList(roots.stream().map(root -> ClassPathSupport.createResource((URL)root)).collect(Collectors.toList())));
            this.listeners = new PropertyChangeSupport(this);
        }

        public List<? extends PathResourceImplementation> getResources() {
            return this.cache.get();
        }

        public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
            this.listeners.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
            this.listeners.removePropertyChangeListener(listener);
        }

        void update(@NonNull Collection<? extends URL> update) {
            List<? extends PathResourceImplementation> current = this.cache.get();
            ArrayList<PathResourceImplementation> next = new ArrayList<PathResourceImplementation>();
            LinkedHashSet<? extends URL> updateSet = new LinkedHashSet<URL>(update);
            boolean dirty = false;
            for (PathResourceImplementation pathResourceImplementation : current) {
                URL[] roots = pathResourceImplementation.getRoots();
                assert (roots.length == 1);
                if (updateSet.remove(roots[0])) {
                    next.add(pathResourceImplementation);
                    continue;
                }
                dirty = true;
            }
            for (URL uRL : updateSet) {
                next.add(ClassPathSupport.createResource((URL)uRL));
                dirty = true;
            }
            if (dirty && this.cache.compareAndSet(current, next)) {
                this.listeners.firePropertyChange("resources", null, null);
            }
        }
    }

    private static final class Entry {
        private static final NoSuchElementException REMOVE = new NoSuchElementException(){

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        };
        private final Reference<SourceRoots> modules;
        private final Reference<SourceRoots> sources;
        private final Reference<MultiModule> model;

        Entry(@NonNull SourceRoots modules, @NonNull SourceRoots sources, @NonNull MultiModule model) {
            Parameters.notNull((CharSequence)MultiModule.PROP_MODULES, (Object)modules);
            Parameters.notNull((CharSequence)"sources", (Object)sources);
            Parameters.notNull((CharSequence)"model", (Object)model);
            this.modules = new WeakReference<SourceRoots>(modules);
            this.sources = new WeakReference<SourceRoots>(sources);
            this.model = new WeakReference<MultiModule>(model);
        }

        boolean matches(@NullAllowed SourceRoots modules, @NullAllowed SourceRoots sources) {
            SourceRoots myModules = this.modules.get();
            if (myModules == null) {
                throw REMOVE;
            }
            if (myModules != modules) {
                return false;
            }
            SourceRoots mySources = this.sources.get();
            if (mySources == null) {
                throw REMOVE;
            }
            return mySources == sources;
        }

        @NonNull
        MultiModule getModel() {
            MultiModule res = this.model.get();
            if (res == null) {
                throw REMOVE;
            }
            return res;
        }
    }
}

