/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.wizards;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.ui.wizards.MoveToModulePathPanelGUI;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;

public final class MoveToModulePathPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
ChangeListener {
    public static final String CP_ITEMS_TO_MOVE = "cp_items_to_move";
    private final J2SEProject project;
    private final EditableProperties ep;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private MoveToModulePathPanelGUI gui;

    public MoveToModulePathPanel(J2SEProject project, EditableProperties ep) {
        this.project = project;
        this.ep = ep;
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new MoveToModulePathPanelGUI(this.project);
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(WizardDescriptor wizard) {
        if (this.gui != null) {
            ClassPathSupport cs = new ClassPathSupport(this.project.evaluator(), this.project.getReferenceHelper(), this.project.getAntProjectHelper(), this.project.getUpdateHelper(), null);
            this.gui.setCPItems(cs.itemsList(this.ep.get((Object)"javac.classpath")));
        }
    }

    public void storeSettings(WizardDescriptor wizard) {
        Object value = wizard.getValue();
        if (WizardDescriptor.PREVIOUS_OPTION.equals(value) || WizardDescriptor.CANCEL_OPTION.equals(value) || WizardDescriptor.CLOSED_OPTION.equals(value)) {
            return;
        }
        if (this.gui != null) {
            wizard.putProperty(CP_ITEMS_TO_MOVE, this.gui.getCPItemsToMove());
        }
        wizard.putProperty("NewFileWizard_Title", null);
    }

    public boolean isValid() {
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChange();
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(e);
        }
    }
}

