/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EntityParser {
    private static final Pattern ENTITY_PATTERN = Pattern.compile("<!ENTITY\\s+%\\s+(\\S+)\\s+\"([^\"]*)\"\\s*>");
    private static final Pattern ENTITY_USE_PATTERN = Pattern.compile("%([\\S;]+);");
    private final Map<String, String> entityMap = new HashMap<String, String>();
    private String remainingText = "";

    public void parse(Reader reader) throws IOException {
        int read;
        StringBuilder w = new StringBuilder();
        char[] buf = new char[4096];
        while ((read = reader.read(buf)) != -1) {
            w.append(buf, 0, read);
        }
        String originalText = w.toString();
        StringBuffer buffer = new StringBuffer(originalText.length());
        Matcher entityMatcher = ENTITY_PATTERN.matcher(originalText);
        while (entityMatcher.find()) {
            this.addEntity(entityMatcher);
            entityMatcher.appendReplacement(buffer, "");
        }
        entityMatcher.appendTail(buffer);
        StringBuffer buffer2 = new StringBuffer(originalText.length());
        Matcher entityReplacementMatcher = ENTITY_USE_PATTERN.matcher(buffer);
        while (entityReplacementMatcher.find()) {
            String entity = entityReplacementMatcher.group(1);
            if (!this.entityMap.containsKey(entity)) continue;
            entityReplacementMatcher.appendReplacement(buffer2, this.entityMap.get(entity));
        }
        entityReplacementMatcher.appendTail(buffer2);
        this.remainingText = buffer2.toString();
    }

    private void addEntity(Matcher m) throws IOException {
        String key = m.group(1);
        String value = m.group(2);
        if (value != null) {
            int refStart = value.indexOf("%");
            int refEnd = value.indexOf(";");
            if (refStart >= 0 && refEnd > refStart) {
                String entityKey = value.substring(refStart + 1, refEnd);
                String val = this.entityMap.get(entityKey);
                if (val != null) {
                    String newValue = value.substring(0, refStart) + val + value.substring(refEnd + 1);
                    System.out.println("found ENTITY: % " + key + " \"" + newValue + "\"");
                    this.entityMap.put(key, newValue);
                }
            } else {
                System.out.println("found ENTITY: % " + key + " \"" + value + "\"");
                this.entityMap.put(key, value);
            }
        }
    }

    public Reader getReader() throws IOException {
        return new StringReader(this.remainingText);
    }
}

