/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.java.source.parsing.ClasspathInfoProvider;
import org.netbeans.modules.java.source.parsing.JavacParserResult;
import org.netbeans.modules.javafx2.editor.ErrorMark;
import org.netbeans.modules.javafx2.editor.ErrorReporter;
import org.netbeans.modules.javafx2.editor.completion.beans.FxBean;
import org.netbeans.modules.javafx2.editor.completion.model.FxInclude;
import org.netbeans.modules.javafx2.editor.completion.model.FxModel;
import org.netbeans.modules.javafx2.editor.completion.model.FxNewInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxNodeVisitor;
import org.netbeans.modules.javafx2.editor.completion.model.FxTreeUtilities;
import org.netbeans.modules.javafx2.editor.completion.model.FxmlParserResult;
import org.netbeans.modules.javafx2.editor.parser.BuildEnvironment;
import org.netbeans.modules.javafx2.editor.parser.FxModelBuilder;
import org.netbeans.modules.javafx2.editor.parser.ModelAccessor;
import org.netbeans.modules.javafx2.editor.parser.ModelBuilderStep;
import org.netbeans.modules.javafx2.editor.parser.processors.EventResolver;
import org.netbeans.modules.javafx2.editor.parser.processors.ImportProcessor;
import org.netbeans.modules.javafx2.editor.parser.processors.IncludeResolver;
import org.netbeans.modules.javafx2.editor.parser.processors.NamedInstancesCollector;
import org.netbeans.modules.javafx2.editor.parser.processors.PropertyResolver;
import org.netbeans.modules.javafx2.editor.parser.processors.ReferenceResolver;
import org.netbeans.modules.javafx2.editor.parser.processors.ScriptResolver;
import org.netbeans.modules.javafx2.editor.parser.processors.TypeResolver;
import org.netbeans.modules.javafx2.editor.parser.processors.ValueChecker;
import org.netbeans.modules.javafx2.editor.sax.XmlLexerParser;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.filesystems.FileObject;
import org.xml.sax.SAXException;

class FxmlParser
extends Parser
implements ErrorReporter {
    private FxmlParserResult result;
    private Collection<ErrorMark> problems = new ArrayList<ErrorMark>();
    private FxModel model;
    private CompilationInfo info;
    private Snapshot snapshot;
    private BuildEnvironment env;
    private List<ModelBuilderStep> steps;

    FxmlParser() {
    }

    @Override
    public void addError(ErrorMark em) {
        this.problems.add(em);
    }

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
        this.snapshot = snapshot;
        TokenHierarchy h = snapshot.getTokenHierarchy();
        XmlLexerParser tokenParser = new XmlLexerParser(h);
        FxModelBuilder builder = new FxModelBuilder();
        FileObject fo = snapshot.getSource().getFileObject();
        if (fo != null) {
            builder.setBaseURL(fo.toURL());
        }
        tokenParser.setContentHandler(builder);
        try {
            tokenParser.parse();
        }
        catch (SAXException ex) {
            throw new ParseException("Parsing failed", (Throwable)ex);
        }
        final ClasspathInfo cpInfo = ClasspathInfo.create((FileObject)snapshot.getSource().getFileObject());
        this.problems.addAll(tokenParser.getErrors());
        this.problems.addAll(builder.getErrors());
        this.model = builder.getModel();
        class UT
        extends UserTask
        implements ClasspathInfoProvider {
            UT() {
            }

            public ClasspathInfo getClasspathInfo() {
                return cpInfo;
            }

            public void run(ResultIterator resultIterator) throws Exception {
                JavacParserResult res = (JavacParserResult)resultIterator.getParserResult();
                FxmlParser.this.info = res.get(CompilationInfo.class);
                FxmlParser.this.env = FxmlParser.this.createBuildEnvironment();
                FxmlParser.this.initModelSteps();
                for (ModelBuilderStep step : FxmlParser.this.steps) {
                    FxNodeVisitor visitor = step.createVisitor(FxmlParser.this.env);
                    FxmlParser.this.model.accept(visitor);
                }
            }
        }
        UT ut = new UT();
        ParserManager.parse((String)"text/x-java", (UserTask)ut);
        this.result = new ResultImpl(snapshot, this.model, this.problems, h);
        this.env = null;
        this.steps = null;
        snapshot = null;
        this.model = null;
        this.info = null;
        this.problems = new ArrayList<ErrorMark>();
    }

    private void initModelSteps() {
        this.steps = new ArrayList<ModelBuilderStep>();
        this.steps.add(new NamedInstancesCollector());
        this.steps.add(new IncludeResolver());
        this.steps.add(new ScriptResolver());
        this.steps.add(new TypeResolver());
        this.steps.add(new ReferenceResolver());
        this.steps.add(new PropertyResolver());
        this.steps.add(new EventResolver());
        this.steps.add(new ValueChecker());
    }

    private BuildEnvironment createBuildEnvironment() {
        BuildEnvironment env = new BuildEnvironment();
        env.setAccessor(ModelAccessor.INSTANCE);
        env.setBeanProvider(FxBean.getBeanProvider(this.info));
        env.setCompilationInfo(this.info);
        env.setHierarchy((TokenHierarchy<XMLTokenId>)this.snapshot.getTokenHierarchy());
        env.setModel(this.model);
        env.setReporter(this);
        env.setTreeUtilities(new FxTreeUtilities(ModelAccessor.INSTANCE, this.model, env.getHierarchy()));
        return env;
    }

    public Parser.Result getResult(Task task) throws ParseException {
        return this.result;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private static final class ResultImpl
    extends FxmlParserResult {
        private ImportProcessor importProcessor;

        public ResultImpl(Snapshot _snapshot, FxModel sourceModel, Collection<ErrorMark> problems, TokenHierarchy<?> h) {
            super(_snapshot, sourceModel, problems, h);
        }

        @Override
        public FxNewInstance resolveInstance(FxInclude include) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected FxTreeUtilities createTreeUtilities() {
            return new FxTreeUtilities(ModelAccessor.INSTANCE, this.getSourceModel(), this.getTokenHierarchy());
        }

        @Override
        public Set<String> resolveClassName(CompilationInfo info, String className) {
            if (this.importProcessor == null) {
                this.importProcessor = new ImportProcessor(this.getTokenHierarchy(), null, this.getTreeUtilities());
                this.importProcessor.load(info, this.getSourceModel());
            }
            return this.importProcessor.resolveTypeName(info, className);
        }
    }
}

