/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.util.WeakHashMap;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.versioning.util.IndexingBridge;
import org.openide.util.RequestProcessor;

public final class DelayScanRegistry {
    private final WeakHashMap<RequestProcessor.Task, DelayedScan> registry = new WeakHashMap(5);
    private static DelayScanRegistry instance;
    private static int MAX_WAITING_TIME;
    private static int WAITING_PERIOD;
    private static final boolean BLOCK_INDEFINITELY;

    public static synchronized DelayScanRegistry getInstance() {
        if (instance == null) {
            instance = new DelayScanRegistry();
        }
        return instance;
    }

    private DelayScanRegistry() {
    }

    public boolean isDelayed(RequestProcessor.Task task, Logger logger, String logMessagePrefix) {
        boolean rescheduled = false;
        DelayedScan scan = this.getRegisteredScan(task);
        Future projectOpenTask = OpenProjects.getDefault().openProjects();
        if (!projectOpenTask.isDone()) {
            try {
                projectOpenTask.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (IndexingBridge.getInstance().isIndexingInProgress() && (BLOCK_INDEFINITELY || scan.waitingLoops * WAITING_PERIOD < MAX_WAITING_TIME)) {
            Level level = ++scan.waitingLoops < 10 ? Level.FINE : Level.INFO;
            logger.log(level, "{0}: Scanning in progress, trying again in {1}ms", new Object[]{logMessagePrefix, WAITING_PERIOD});
            task.schedule(WAITING_PERIOD);
            rescheduled = true;
        } else {
            scan.waitingLoops = 0;
        }
        return rescheduled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DelayedScan getRegisteredScan(RequestProcessor.Task task) {
        WeakHashMap<RequestProcessor.Task, DelayedScan> weakHashMap = this.registry;
        synchronized (weakHashMap) {
            DelayedScan scan = this.registry.get(task);
            if (scan == null) {
                scan = new DelayedScan();
                this.registry.put(task, scan);
            }
            return scan;
        }
    }

    static {
        MAX_WAITING_TIME = 180000;
        WAITING_PERIOD = 10000;
        BLOCK_INDEFINITELY = "true".equals(System.getProperty("versioning.delayscan.nolimit", "false"));
    }

    private static class DelayedScan {
        private int waitingLoops;

        private DelayedScan() {
        }
    }
}

