/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui.instant;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.ui.instant.CompletionLayoutPopup;
import org.netbeans.modules.refactoring.java.ui.instant.DocumentationScrollPane;
import org.netbeans.modules.refactoring.java.ui.instant.InstantOption;

public final class CompletionLayout
implements ItemListener {
    public static final int COMPLETION_ITEM_HEIGHT = 16;
    private static final int COMPLETION_ANCHOR_HORIZONTAL_SHIFT = 22;
    static final int POPUP_VERTICAL_GAP = 1;
    private Reference<JTextComponent> editorComponentRef;
    private final CompletionPopup completionPopup;
    private final DocPopup docPopup;
    private Problem problem;
    private LinkedList<CompletionLayoutPopup> visiblePopups;
    private final PropertyChangeListener listener;

    public CompletionLayout(PropertyChangeListener listener) {
        this.listener = listener;
        this.completionPopup = new CompletionPopup();
        this.completionPopup.setLayout(this);
        this.completionPopup.setPreferDisplayAboveCaret(false);
        this.docPopup = new DocPopup();
        this.docPopup.setLayout(this);
        this.docPopup.setPreferDisplayAboveCaret(false);
        this.visiblePopups = new LinkedList();
    }

    public int getAnchorOffset() {
        return this.completionPopup.getAnchorOffset();
    }

    public JTextComponent getEditorComponent() {
        return this.editorComponentRef != null ? this.editorComponentRef.get() : null;
    }

    public Problem getProblem() {
        return this.problem;
    }

    public void setEditorComponent(JTextComponent editorComponent) {
        this.hideAll();
        this.editorComponentRef = new WeakReference<JTextComponent>(editorComponent);
    }

    private void hideAll() {
        for (CompletionLayoutPopup popup : this.visiblePopups) {
            popup.hide();
        }
        this.visiblePopups.clear();
    }

    public void showCompletion(List<InstantOption> options, int anchorOffset, String shortcutHint) {
        this.completionPopup.show(options, anchorOffset, shortcutHint, this.problem, this);
        if (!this.visiblePopups.contains(this.completionPopup)) {
            this.visiblePopups.push(this.completionPopup);
        }
    }

    public boolean hideCompletion() {
        for (CompletionLayoutPopup popup : this.visiblePopups) {
            if (!(popup instanceof CompletionPopup) || !popup.isVisible()) continue;
            popup.hide();
            ((CompletionPopup)popup).completionScrollPane = null;
            this.visiblePopups.remove(popup);
            return true;
        }
        return false;
    }

    public boolean isCompletionVisible() {
        return this.completionPopup.isVisible();
    }

    public void processKeyEvent(KeyEvent evt) {
        for (CompletionLayoutPopup popup : this.visiblePopups) {
            popup.processKeyEvent(evt);
            if (!evt.isConsumed()) continue;
            return;
        }
    }

    public void showDocumentation(int anchorOffset) {
        this.docPopup.show(anchorOffset);
        if (!this.visiblePopups.contains(this.docPopup)) {
            this.visiblePopups.push(this.docPopup);
        }
    }

    public boolean hideDocumentation() {
        if (this.docPopup.isVisible()) {
            this.docPopup.clearHistory();
            this.docPopup.hide();
            this.visiblePopups.remove(this.docPopup);
            return true;
        }
        return false;
    }

    public boolean isDocumentationVisible() {
        return this.docPopup.isVisible();
    }

    public void clearDocumentationHistory() {
        this.docPopup.clearHistory();
    }

    void updateLayout(CompletionLayoutPopup popup) {
        popup.resetPreferredSize();
        if (popup == this.completionPopup) {
            popup.showAlongAnchorBounds();
            if (this.docPopup.isVisible() && (this.docPopup.isOverlapped(popup) || this.docPopup.getAnchorOffset() != this.completionPopup.getAnchorOffset() || !this.docPopup.isShowRetainedPreferredSize())) {
                this.updateLayout(this.docPopup);
            }
        } else if (popup == this.docPopup) {
            if (this.isCompletionVisible()) {
                popup.setAnchorOffset(this.completionPopup.getAnchorOffset());
            }
            Rectangle occupiedBounds = popup.getAnchorOffsetBounds();
            this.docPopup.showAlongOccupiedBounds(occupiedBounds);
        } else {
            Rectangle occupiedBounds = popup.getAnchorOffsetBounds();
            popup.showAlongOrNextOccupiedBounds(occupiedBounds, occupiedBounds);
        }
    }

    CompletionPopup testGetCompletionPopup() {
        return this.completionPopup;
    }

    void repaintCompletionView() {
        assert (EventQueue.isDispatchThread());
        JPanel completionView = this.completionPopup.completionScrollPane;
        if (completionView != null && completionView.isVisible()) {
            completionView.repaint();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getItem() instanceof CompletionPopup.OptionCheckbox) {
            CompletionPopup.OptionCheckbox checkbox = (CompletionPopup.OptionCheckbox)e.getItem();
            InstantOption option = checkbox.option;
            boolean oldValue = option.selected();
            boolean newValue = checkbox.isSelected();
            option.setSelected(newValue);
            this.listener.propertyChange(new PropertyChangeEvent(option, option.displayName(), oldValue, newValue));
        }
    }

    private static final class DocPopup
    extends CompletionLayoutPopup {
        private DocPopup() {
        }

        private DocumentationScrollPane getDocumentationScrollPane() {
            return (DocumentationScrollPane)this.getContentComponent();
        }

        protected void show(int anchorOffset) {
            JTextComponent editorComponent = this.getEditorComponent();
            if (editorComponent == null) {
                return;
            }
            if (!this.isVisible()) {
                this.setContentComponent(new DocumentationScrollPane(editorComponent));
            }
            if (!this.isVisible()) {
                this.setAnchorOffset(anchorOffset);
                this.getLayout().updateLayout(this);
            }
        }

        @Override
        public void processKeyEvent(KeyEvent evt) {
            Action action;
            Object actionMapKey;
            if (this.isVisible() && (actionMapKey = this.getDocumentationScrollPane().getInputMap().get(KeyStroke.getKeyStrokeForEvent(evt))) != null && (action = this.getDocumentationScrollPane().getActionMap().get(actionMapKey)) != null) {
                action.actionPerformed(new ActionEvent(this.getDocumentationScrollPane(), 0, null));
                evt.consume();
            }
        }

        public void clearHistory() {
            if (this.isVisible()) {
                // empty if block
            }
        }

        @Override
        protected int getAnchorHorizontalShift() {
            return 22;
        }
    }

    private static final class CompletionPopup
    extends CompletionLayoutPopup {
        private JPanel completionScrollPane;
        private JComponent contentPane;

        private CompletionPopup() {
        }

        public void show(List<InstantOption> options, int anchorOffset, String shortcutHint, Problem problem, ItemListener itemListener) {
            Dimension lastSize;
            JTextComponent editorComponent = this.getEditorComponent();
            if (editorComponent == null) {
                return;
            }
            int lastAnchorOffset = this.getAnchorOffset();
            if (this.isVisible() && this.getContentComponent() == this.completionScrollPane ^ shortcutHint != null) {
                lastSize = this.getContentComponent().getSize();
                this.resetPreferredSize();
            } else {
                lastSize = new Dimension(0, 0);
                this.completionScrollPane = new JPanel();
                this.completionScrollPane.setLayout(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.anchor = 17;
                c.gridx = 0;
                c.gridy = 0;
                this.completionScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.white), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.gray), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
                for (InstantOption instantOption : options) {
                    OptionCheckbox checkbox = new OptionCheckbox(instantOption);
                    checkbox.setFocusable(false);
                    checkbox.addItemListener(itemListener);
                    this.completionScrollPane.add((Component)checkbox, c);
                    ++c.gridy;
                }
                if (shortcutHint != null) {
                    this.contentPane = new JPanel();
                    this.contentPane.setLayout(new BorderLayout());
                    this.contentPane.add((Component)this.completionScrollPane, "Center");
                    JLabel label = new JLabel();
                    label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.white), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Color.gray), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
                    label.setFont(label.getFont().deriveFont((float)label.getFont().getSize() - 2.0f));
                    label.setHorizontalAlignment(4);
                    label.setText(shortcutHint);
                    this.contentPane.add((Component)label, "South");
                } else {
                    this.contentPane = this.completionScrollPane;
                }
                if (problem != null) {
                    JPanel panel = new JPanel();
                    panel.setLayout(new BorderLayout());
                    panel.add((Component)this.getContentComponent(), "Center");
                    JLabel label = new JLabel();
                    label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.white), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Color.gray), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
                    label.setFont(label.getFont().deriveFont((float)label.getFont().getSize() - 2.0f));
                    label.setHorizontalAlignment(4);
                    label.setText(problem.getMessage());
                }
                this.setContentComponent(this.contentPane);
            }
            this.getPreferredSize();
            this.setAnchorOffset(anchorOffset);
            Dimension prefSize = this.getPreferredSize();
            boolean changePopupSize = this.isVisible() ? prefSize.height != lastSize.height || prefSize.width != lastSize.width || anchorOffset != lastAnchorOffset : true;
            if (changePopupSize) {
                this.getLayout().updateLayout(this);
            }
        }

        @Override
        public void processKeyEvent(KeyEvent evt) {
            Action action;
            Object actionMapKey;
            if (this.isVisible() && (actionMapKey = this.completionScrollPane.getInputMap().get(KeyStroke.getKeyStrokeForEvent(evt))) != null && (action = this.completionScrollPane.getActionMap().get(actionMapKey)) != null) {
                action.actionPerformed(new ActionEvent(this.completionScrollPane, 0, null));
                evt.consume();
            }
        }

        @Override
        protected int getAnchorHorizontalShift() {
            return 22;
        }

        private static class OptionCheckbox
        extends JCheckBox {
            private InstantOption option;

            public OptionCheckbox(InstantOption option) {
                super(option.displayName(), option.selected());
                this.setToolTipText(option.tooltip());
                this.option = option;
            }

            public InstantOption getOption() {
                return this.option;
            }
        }
    }
}

