/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.diff;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.netbeans.modules.git.GitStatusNode;
import org.netbeans.modules.git.ui.diff.DiffFileViewComponent;
import org.netbeans.modules.git.ui.diff.DiffNode;
import org.netbeans.modules.git.ui.diff.MultiDiffPanelController;
import org.netbeans.modules.versioning.util.common.FileTreeView;
import org.netbeans.modules.versioning.util.status.VCSStatusNode;
import org.netbeans.swing.outline.RenderDataProvider;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;

class DiffFileTreeImpl
extends FileTreeView<DiffNode>
implements DiffFileViewComponent<DiffNode> {
    private final MultiDiffPanelController master;

    public DiffFileTreeImpl(MultiDiffPanelController master) {
        this.master = master;
        this.setupColumns();
    }

    private void setupColumns() {
        Node.Property[] properties = new Node.Property[]{new ColumnDescriptor<String>("gitstatus", String.class, GitStatusNode.GitStatusProperty.DISPLAY_NAME, GitStatusNode.GitStatusProperty.DESCRIPTION), new ColumnDescriptor<String>("path", String.class, VCSStatusNode.PathProperty.DISPLAY_NAME, VCSStatusNode.PathProperty.DESCRIPTION)};
        this.view.setProperties(properties);
        this.view.getOutline().setRenderDataProvider(this.createRenderProvider());
    }

    private RenderDataProvider createRenderProvider() {
        return new FileTreeView.AbstractRenderDataProvider(){

            protected String annotateName(DiffNode node, String originalLabel) {
                if (node.isExcluded()) {
                    originalLabel = "<s>" + (originalLabel == null ? node.getName() : originalLabel) + "</s>";
                }
                return originalLabel;
            }
        };
    }

    protected void nodeSelected(DiffNode node) {
        if (node == null) {
            this.master.filesSelected(new File[0]);
        } else {
            this.master.filesSelected(node.getFile());
        }
    }

    protected JPopupMenu getPopup() {
        List nodes = this.getSelectedNodes();
        File[] files = this.toFiles(nodes);
        return this.master.getPopupFor(nodes.toArray(new Node[nodes.size()]), files);
    }

    protected void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int width = DiffFileTreeImpl.this.view.getWidth();
                DiffFileTreeImpl.this.view.getOutline().getColumnModel().getColumn(0).setPreferredWidth(width * 40 / 100);
                DiffFileTreeImpl.this.view.getOutline().getColumnModel().getColumn(1).setPreferredWidth(width * 20 / 100);
                DiffFileTreeImpl.this.view.getOutline().getColumnModel().getColumn(2).setPreferredWidth(width * 40 / 100);
            }
        });
    }

    @Override
    public File[] getSelectedFiles() {
        return this.toFiles(this.getSelectedNodes());
    }

    private File[] toFiles(List<Node> nodes) {
        ArrayList<File> files = new ArrayList<File>(nodes.size());
        for (Node n : nodes) {
            File f = (File)n.getLookup().lookup(File.class);
            if (f == null) continue;
            files.add(f);
        }
        return files.toArray(new File[files.size()]);
    }

    private static class ColumnDescriptor<T>
    extends PropertySupport.ReadOnly<T> {
        public ColumnDescriptor(String name, Class<T> type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public T getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }
}

