/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.css.indexing.api.CssIndex;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.model.api.Body;
import org.netbeans.modules.css.model.api.Declarations;
import org.netbeans.modules.css.model.api.Element;
import org.netbeans.modules.css.model.api.ElementFactory;
import org.netbeans.modules.css.model.api.Media;
import org.netbeans.modules.css.model.api.MediaBody;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.ModelUtils;
import org.netbeans.modules.css.model.api.ModelVisitor;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.css.model.api.Selector;
import org.netbeans.modules.css.model.api.SelectorsGroup;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.css.visual.Bundle;
import org.netbeans.modules.css.visual.HtmlEditorSourceTask;
import org.netbeans.modules.css.visual.HtmlSourceElementHandle;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.html.editor.lib.api.elements.TreePath;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModel;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModelFactory;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.DependenciesGraph;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.common.spi.ProjectWebRootQuery;
import org.netbeans.modules.web.common.ui.api.WebUIUtils;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class CreateRulePanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(CreateRulePanel.class.getSimpleName());
    private static final Color tagColor = new Color(0, 0, 230);
    private static final Color attrNameColor = new Color(0, 153, 0);
    private static final Color attrValueColor = new Color(206, 123, 0);
    private String compoundSelectorDefaultValue;
    private HtmlSourceElementHandle activeElement;
    private AtomicReference<String> activeElementClass;
    private AtomicReference<String> activeElementId;
    private SelectorItem selectedClazz;
    private SelectorItem selectedId;
    private SelectorItem selectedElement;
    private SelectorItem selectedCompound;
    private final SelectorItem NO_CLASS = SelectorItem.access$000(null, null);
    private final SelectorItem NO_ID = SelectorItem.access$100(null, null);
    private String[] SELECTOR_TYPE_DESCRIPTIONS = new String[]{Bundle.class_selector_descr(), Bundle.id_selector_descr(), Bundle.element_selector_descr(), Bundle.compound_selector_descr()};
    private ExtDefaultComboBoxModel SELECTORS_MODEL;
    private ExtDefaultComboBoxModel STYLESHEETS_MODEL;
    private ExtDefaultComboBoxModel AT_RULES_MODEL;
    private ListModel SELECTORS_LIST_MODEL;
    private FileObject context;
    private FileObject webRoot;
    private Project project;
    private Collection<String> ELEMENT_SELECTOR_ITEMS;
    private SelectorItemRenderer SELECTOR_MODEL_ITEM_RENDERER;
    private int pos;
    private int diff;
    private JComboBox atRuleCB;
    private JTextPane descriptionPane;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSplitPane jSplitPane1;
    private JComboBox selectorCB;
    private JLabel selectorTypeLabel;
    private JList selectorTypeList;
    private JComboBox styleSheetCB;

    public CreateRulePanel(FileObject context, HtmlSourceElementHandle handle) {
        assert (context != null);
        this.context = context;
        this.project = FileOwnerQuery.getOwner((FileObject)context);
        this.webRoot = ProjectWebRootQuery.getWebRoot((FileObject)context);
        this.activeElement = handle;
        this.STYLESHEETS_MODEL = new ExtDefaultComboBoxModel();
        this.AT_RULES_MODEL = new ExtDefaultComboBoxModel();
        this.SELECTORS_MODEL = new ExtDefaultComboBoxModel();
        this.createStyleSheetsModel();
        this.SELECTORS_LIST_MODEL = new AbstractListModel(){

            @Override
            public int getSize() {
                return 4;
            }

            @Override
            public Object getElementAt(int i) {
                switch (i) {
                    case 0: {
                        return Bundle.selector_type_class();
                    }
                    case 1: {
                        return Bundle.selector_type_id();
                    }
                    case 2: {
                        return Bundle.selector_type_element();
                    }
                    case 3: {
                        return Bundle.selector_type_compound();
                    }
                }
                throw new IllegalStateException();
            }
        };
        this.initComponents();
        this.selectorTypeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FileObject file;
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (!CreateRulePanel.this.selectorCB.isEnabled()) {
                    CreateRulePanel.this.selectorCB.setEnabled(true);
                }
                int index = CreateRulePanel.this.selectorTypeList.getSelectedIndex();
                CreateRulePanel.this.descriptionPane.setText(CreateRulePanel.this.SELECTOR_TYPE_DESCRIPTIONS[index]);
                CreateRulePanel.this.selectorTypeLabel.setText(CreateRulePanel.this.selectorTypeList.getSelectedValue().toString() + Bundle.selector_rule_postfix());
                CreateRulePanel.this.updateSelectorsModel();
                SelectorItem activeSelectorItem = CreateRulePanel.this.getActiveSelectorItem();
                if (activeSelectorItem != null && (file = activeSelectorItem.getFile()) != null) {
                    CreateRulePanel.this.styleSheetCB.setSelectedItem(file);
                    CreateRulePanel.this.updateAtRules();
                    AtRuleItem createInAtRule = activeSelectorItem.getCreateInAtRule();
                    if (createInAtRule != null) {
                        CreateRulePanel.this.atRuleCB.setSelectedItem(createInAtRule);
                    }
                }
            }
        });
        this.selectorCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item;
                if (e.getStateChange() == 1 && (item = e.getItem()) instanceof SelectorItem) {
                    CreateRulePanel.this.setSelectorItem((SelectorItem)e.getItem());
                }
            }
        });
        final ComboBoxEditor editor = this.selectorCB.getEditor();
        if (editor.getEditorComponent() instanceof JTextComponent) {
            JTextComponent textEditor = (JTextComponent)editor.getEditorComponent();
            Document doc = textEditor.getDocument();
            doc.addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent de) {
                    this.change();
                }

                @Override
                public void removeUpdate(DocumentEvent de) {
                    this.change();
                }

                @Override
                public void changedUpdate(DocumentEvent de) {
                    this.change();
                }

                private void change() {
                    SelectorItem selectorItem;
                    String item = editor.getItem().toString();
                    switch (CreateRulePanel.this.selectorTypeList.getSelectedIndex()) {
                        case 0: {
                            if (item.isEmpty()) {
                                selectorItem = CreateRulePanel.this.NO_CLASS;
                                break;
                            }
                            if (item.charAt(0) == '.') {
                                item = item.substring(1);
                            }
                            selectorItem = SelectorItem.createClass(item, null);
                            break;
                        }
                        case 1: {
                            if (item.isEmpty()) {
                                selectorItem = CreateRulePanel.this.NO_ID;
                                break;
                            }
                            if (item.charAt(0) == '#') {
                                item = item.substring(1);
                            }
                            selectorItem = SelectorItem.createId(item, null);
                            break;
                        }
                        case 2: {
                            if (item.isEmpty()) {
                                return;
                            }
                            selectorItem = SelectorItem.createElement(item);
                            break;
                        }
                        case 3: {
                            if (item.isEmpty()) {
                                return;
                            }
                            selectorItem = SelectorItem.createCompound(item);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    FileObject selectedStylesheet = (FileObject)CreateRulePanel.this.styleSheetCB.getSelectedItem();
                    selectorItem.setCreateInFile(selectedStylesheet);
                    AtRuleItem selectedAtRule = (AtRuleItem)CreateRulePanel.this.atRuleCB.getSelectedItem();
                    selectorItem.setCreateInAtRule(selectedAtRule);
                    CreateRulePanel.this.setSelectorItem(selectorItem);
                }
            });
        }
        this.styleSheetCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CreateRulePanel.this.updateAtRules();
                    SelectorItem activeSelectorItem = CreateRulePanel.this.getActiveSelectorItem();
                    if (activeSelectorItem != null) {
                        activeSelectorItem.setCreateInFile(CreateRulePanel.this.getActiveStylesheet());
                    }
                }
            }
        });
        this.atRuleCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SelectorItem activeSelectorItem;
                if (e.getStateChange() == 1 && (activeSelectorItem = CreateRulePanel.this.getActiveSelectorItem()) != null) {
                    activeSelectorItem.setCreateInAtRule(CreateRulePanel.this.getActiveAtRule());
                }
            }
        });
        this.initializeActiveElement();
        this.selectorTypeList.setSelectedIndex(0);
        this.updateAtRules();
        if (this.STYLESHEETS_MODEL.getSize() == 0) {
            this.selectorCB.setEnabled(false);
            this.selectorCB.setEditable(false);
            this.selectorTypeList.setEnabled(false);
            this.descriptionPane.setText(Bundle.CreateRulePanel_no_stylesheet());
        }
    }

    private Attribute getSelectedElementClass() {
        if (this.activeElement != null) {
            return this.activeElement.getOpenTag().getAttribute("class");
        }
        return null;
    }

    private Attribute getSelectedElementId() {
        if (this.activeElement != null) {
            return this.activeElement.getOpenTag().getAttribute("id");
        }
        return null;
    }

    private String getSelectedElementClassName() {
        if (this.activeElementClass == null) {
            CharSequence unquotedValue;
            this.activeElementClass = new AtomicReference();
            Attribute clz = this.getSelectedElementClass();
            if (clz != null && (unquotedValue = clz.unquotedValue()) != null) {
                this.activeElementClass.set(unquotedValue.toString());
            }
        }
        return this.activeElementClass.get();
    }

    private String getSelectedElementIdName() {
        if (this.activeElementId == null) {
            CharSequence unquotedValue;
            this.activeElementId = new AtomicReference();
            Attribute id = this.getSelectedElementId();
            if (id != null && (unquotedValue = id.unquotedValue()) != null) {
                this.activeElementId.set(unquotedValue.toString());
            }
        }
        return this.activeElementId.get();
    }

    private void initializeActiveElement() {
        if (this.activeElement == null) {
            this.activeElement = HtmlEditorSourceTask.getElement();
        }
        if (this.activeElement == null) {
            return;
        }
        StringBuilder compoundDefaultValue = new StringBuilder();
        StringBuilder elementPathLabelText = new StringBuilder();
        elementPathLabelText.append("<html><body>");
        TreePath path = new TreePath((org.netbeans.modules.html.editor.lib.api.elements.Element)this.activeElement.getOpenTag());
        for (int i = path.path().size() - 2; i >= 0; --i) {
            org.netbeans.modules.html.editor.lib.api.elements.Element e = (org.netbeans.modules.html.editor.lib.api.elements.Element)path.path().get(i);
            compoundDefaultValue.append(e.id());
            elementPathLabelText.append("<font color=\"");
            elementPathLabelText.append(WebUIUtils.toHexCode((Color)tagColor));
            elementPathLabelText.append("\">");
            elementPathLabelText.append("&lt;");
            elementPathLabelText.append(e.id());
            elementPathLabelText.append("&gt;");
            elementPathLabelText.append("</font>");
            if (i <= 0) continue;
            compoundDefaultValue.append(' ');
            elementPathLabelText.append(' ');
        }
        elementPathLabelText.append("</body></html>");
        this.compoundSelectorDefaultValue = compoundDefaultValue.toString();
    }

    private FileObject getActiveStylesheet() {
        return (FileObject)this.styleSheetCB.getSelectedItem();
    }

    private AtRuleItem getActiveAtRule() {
        return (AtRuleItem)this.atRuleCB.getSelectedItem();
    }

    private SelectorItem getActiveSelectorItem() {
        switch (this.selectorTypeList.getSelectedIndex()) {
            case 0: {
                return this.selectedClazz;
            }
            case 1: {
                return this.selectedId;
            }
            case 2: {
                return this.selectedElement;
            }
            case 3: {
                return this.selectedCompound;
            }
        }
        throw new IllegalStateException();
    }

    private void setSelectorItem(SelectorItem selector) {
        boolean exists;
        switch (selector.getType()) {
            case 0: {
                this.selectedClazz = selector;
                break;
            }
            case 1: {
                this.selectedId = selector;
                break;
            }
            case 2: {
                this.selectedElement = selector;
                break;
            }
            case 3: {
                this.selectedCompound = selector;
            }
        }
        FileObject existsIn = selector.getExistsInFile();
        boolean bl = exists = existsIn != null;
        if (exists) {
            this.STYLESHEETS_MODEL.setSelectedItem(existsIn);
        }
        this.styleSheetCB.setEnabled(!exists);
        this.atRuleCB.setEnabled(!exists);
    }

    private void createStyleSheetsModel() {
        try {
            TreeSet<FileObject> items = new TreeSet<FileObject>(new Comparator<FileObject>(){

                @Override
                public int compare(FileObject t, FileObject t1) {
                    return t.getPath().compareTo(t1.getPath());
                }
            });
            if (this.project == null) {
                return;
            }
            CssIndex index = CssIndex.create((Project)this.project);
            DependenciesGraph dependencies = index.getDependencies(this.context);
            for (FileObject file : dependencies.getAllReferedFiles()) {
                if (!"text/css".equals(file.getMIMEType())) continue;
                items.add(file);
            }
            this.STYLESHEETS_MODEL.setItems(items);
            if (items.contains(this.context)) {
                this.STYLESHEETS_MODEL.setSelectedItem(this.context);
            } else if (this.STYLESHEETS_MODEL.getSize() > 0) {
                this.STYLESHEETS_MODEL.setSelectedIndex(0);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Model getCssSourceModel(FileObject file) throws ParseException {
        final AtomicReference model_ref = new AtomicReference();
        Source source = Source.create((FileObject)file);
        ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

            public void run(ResultIterator resultIterator) throws Exception {
                if ((resultIterator = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/css")) != null) {
                    CssParserResult result = (CssParserResult)resultIterator.getParserResult();
                    model_ref.set(Model.getModel((CssParserResult)result));
                }
            }
        });
        return (Model)model_ref.get();
    }

    private void updateAtRules() {
        FileObject file = (FileObject)this.STYLESHEETS_MODEL.getSelectedItem();
        if (file == null) {
            return;
        }
        try {
            final ArrayList<Object> items = new ArrayList<Object>();
            items.add(null);
            final Model cssSourceModel = this.getCssSourceModel(file);
            cssSourceModel.runReadTask(new Model.ModelTask(){

                public void run(StyleSheet styleSheet) {
                    ModelVisitor.Adapter visitor = new ModelVisitor.Adapter(){

                        public void visitMedia(Media media) {
                            String displayName = cssSourceModel.getElementSource((Element)media.getMediaQueryList()).toString();
                            items.add(new AtRuleItem(displayName, media));
                        }
                    };
                    styleSheet.accept((ModelVisitor)visitor);
                }
            });
            this.AT_RULES_MODEL.setItems(items);
            this.atRuleCB.setEnabled(this.AT_RULES_MODEL.getSize() > 1);
            if (this.AT_RULES_MODEL.getSize() > 0) {
                this.atRuleCB.setSelectedIndex(0);
            }
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void dumpSummary() {
        if (this.selectedClazz != null) {
            LOGGER.log(Level.FINE, "selected class = {0}", this.selectedClazz.getInfo());
        }
        if (this.selectedId != null) {
            LOGGER.log(Level.FINE, "selected id = {0}", this.selectedId.getInfo());
        }
        if (this.selectedElement != null) {
            LOGGER.log(Level.FINE, "selected element = {0}", this.selectedElement.getInfo());
        }
        if (this.selectedCompound != null) {
            LOGGER.log(Level.FINE, "selected compound = {0}", this.selectedCompound.getInfo());
        }
    }

    public void applyChanges() {
        assert (!EventQueue.isDispatchThread());
        this.dumpSummary();
        try {
            if (this.selectedClazz != null && this.selectedClazz.getExistsInFile() == null && this.selectedClazz.getCreateInFile() != null && this.selectedClazz.getItemFQName() != null) {
                this.createNewRule(this.selectedClazz);
            }
            if (this.selectedId != null && this.selectedId.getExistsInFile() == null && this.selectedId.getCreateInFile() != null && this.selectedId.getItemFQName() != null) {
                this.createNewRule(this.selectedId);
            }
            if (this.activeElement != null) {
                this.modifySourceElement();
            }
        }
        catch (IOException | ParseException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        try {
            switch (this.selectorTypeList.getSelectedIndex()) {
                case 2: {
                    if (this.selectedElement == null) break;
                    this.createNewRule(this.selectedElement);
                    break;
                }
                case 3: {
                    if (this.selectedCompound == null) break;
                    this.createNewRule(this.selectedCompound);
                }
            }
        }
        catch (IOException | ParseException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private void createNewRule(final SelectorItem selectorItem) throws IOException, ParseException {
        final FileObject createInFile = selectorItem.getCreateInFile();
        final Model cssSourceModel = this.getCssSourceModel(createInFile);
        final AtomicReference createdRuleRef = new AtomicReference();
        cssSourceModel.runWriteTask(new Model.ModelTask(){

            public void run(StyleSheet styleSheet) {
                ElementFactory factory = cssSourceModel.getElementFactory();
                Selector s = factory.createSelector((CharSequence)selectorItem.getItemFQName());
                SelectorsGroup sg = factory.createSelectorsGroup(new Selector[]{s});
                Declarations ds = factory.createDeclarations();
                Rule rule = factory.createRule(sg, ds);
                AtRuleItem createInAtRule = selectorItem.getCreateInAtRule();
                if (createInAtRule == null) {
                    Body body = styleSheet.getBody();
                    if (body == null) {
                        body = factory.createBody();
                        styleSheet.setBody(body);
                    }
                    styleSheet.getBody().addRule(rule);
                } else {
                    ModelUtils utils = new ModelUtils(cssSourceModel);
                    Media oldMedia = createInAtRule.getMedia();
                    Media match = utils.findMatchingMedia(oldMedia.getModel(), oldMedia);
                    MediaBody mediaBody = match.getMediaBody();
                    if (mediaBody == null) {
                        mediaBody = factory.createMediaBody();
                        match.setMediaBody(mediaBody);
                    }
                    mediaBody.addRule(rule);
                }
                try {
                    cssSourceModel.applyChanges();
                    createdRuleRef.set(rule);
                    LOGGER.log(Level.FINE, "Created new rule {0} in file {1} (at-rule: {2}).", new Object[]{selectorItem.getItemFQName(), createInFile.getNameExt(), createInAtRule});
                }
                catch (IOException | BadLocationException x) {
                    Exceptions.printStackTrace((Throwable)x);
                }
            }
        });
        Rule createdRule = (Rule)createdRuleRef.get();
        if (createdRule != null) {
            this.selectTheRuleInEditorIfOpened(cssSourceModel, createdRule);
        }
    }

    private void selectTheRuleInEditorIfOpened(final Model omodel, final Rule orule) throws DataObjectNotFoundException, ParseException {
        final FileObject file = (FileObject)omodel.getLookup().lookup(FileObject.class);
        DataObject dobj = DataObject.find((FileObject)file);
        final EditorCookie ec = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
        final AtomicInteger ruleOffset = new AtomicInteger(-1);
        Source source = Source.create((FileObject)file);
        ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

            public void run(ResultIterator resultIterator) throws Exception {
                if ((resultIterator = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/css")) != null) {
                    CssParserResult result = (CssParserResult)resultIterator.getParserResult();
                    final Model model = Model.getModel((CssParserResult)result);
                    model.runReadTask(new Model.ModelTask(){

                        public void run(StyleSheet styleSheet) {
                            ModelUtils utils = new ModelUtils(model);
                            Rule match = utils.findMatchingRule(omodel, orule);
                            if (match != null) {
                                ruleOffset.set(match.getStartOffset());
                            }
                        }
                    });
                }
            }
        });
        if (ruleOffset.get() == -1) {
            return;
        }
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                JEditorPane[] openedPanes = ec.getOpenedPanes();
                if (openedPanes != null && openedPanes.length > 0) {
                    JEditorPane pane = openedPanes[0];
                    pane.setCaretPosition(ruleOffset.get());
                    ec.open();
                    LOGGER.log(Level.FINE, "Focused file {0} and set caret to offset {1}", new Object[]{file.getNameExt(), ruleOffset.get()});
                }
            }
        });
    }

    private void modifySourceElement() throws DataObjectNotFoundException, IOException {
        SaveCookie saveCookie;
        final BaseDocument doc = (BaseDocument)CreateRulePanel.getDocument(this.activeElement.getFile());
        final AtomicBoolean success = new AtomicBoolean();
        DataObject dataObject = DataObject.find((FileObject)this.activeElement.getFile());
        boolean modified = dataObject.getLookup().lookup(SaveCookie.class) != null;
        this.pos = Integer.MAX_VALUE;
        this.diff = -1;
        doc.runAtomicAsUser(new Runnable(){

            @Override
            public void run() {
                try {
                    if (CreateRulePanel.this.selectedClazz != null) {
                        CreateRulePanel.this.updateAttribute((Document)doc, CreateRulePanel.this.getSelectedElementClass(), CreateRulePanel.this.selectedClazz.getItemName(), "class");
                    }
                    if (CreateRulePanel.this.selectedId != null) {
                        CreateRulePanel.this.updateAttribute((Document)doc, CreateRulePanel.this.getSelectedElementId(), CreateRulePanel.this.selectedId.getItemName(), "id");
                    }
                    success.set(true);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        if (success.get() && !modified && (saveCookie = (SaveCookie)dataObject.getLookup().lookup(SaveCookie.class)) != null) {
            saveCookie.save();
        }
    }

    private static void saveDocumentIfNotOpened(Document document) throws IOException {
        SaveCookie save;
        Object o = document.getProperty("stream");
        if (o == null || !(o instanceof DataObject)) {
            return;
        }
        DataObject dobj = (DataObject)o;
        EditorCookie ec = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
        if (ec != null && ec.getOpenedPanes() == null && (save = (SaveCookie)dobj.getLookup().lookup(SaveCookie.class)) != null) {
            save.save();
        }
    }

    private static Document getDocument(FileObject file) {
        try {
            DataObject d = DataObject.find((FileObject)file);
            EditorCookie ec = (EditorCookie)d.getLookup().lookup(EditorCookie.class);
            if (ec == null) {
                return null;
            }
            return ec.openDocument();
        }
        catch (IOException e) {
            return null;
        }
    }

    private void updateAttribute(Document doc, Attribute a, String value, String name) throws BadLocationException {
        LOGGER.log(Level.FINE, "Source element {0}: updating {1} attribute from {2} to {3}.", new Object[]{this.activeElement, name, a != null ? a.unquotedValue() : null, value});
        OpenTag ot = this.activeElement.getOpenTag();
        Snapshot snap = this.activeElement.getSnapshot();
        if (a == null && value == null) {
            return;
        }
        if (a == null && value != null) {
            int insertPos = snap.getOriginalOffset(ot.from() + 1 + ot.name().length());
            StringBuilder sb = new StringBuilder();
            sb.append(' ');
            sb.append(name);
            sb.append('=');
            sb.append('\"');
            sb.append(value);
            sb.append('\"');
            doc.insertString(insertPos, sb.toString(), null);
            this.pos = insertPos;
            this.diff = sb.length();
        } else if (a != null && value == null) {
            int removeFrom = a.from() - 1;
            int removeTo = a.to();
            int rfdoc = snap.getOriginalOffset(removeFrom);
            int rtdoc = snap.getOriginalOffset(removeTo);
            if (rfdoc >= this.pos) {
                rfdoc += this.diff;
                rtdoc += this.diff;
            }
            doc.remove(rfdoc, rtdoc - rfdoc);
            this.pos = removeFrom;
            this.diff = rfdoc - rtdoc;
        } else {
            CharSequence existingValue = a.unquotedValue();
            if (existingValue != null && LexerUtils.equals((CharSequence)existingValue, (CharSequence)value, (boolean)false, (boolean)false)) {
                return;
            }
            int removeFrom = a.from();
            int removeTo = a.to();
            int rfdoc = snap.getOriginalOffset(removeFrom);
            int rtdoc = snap.getOriginalOffset(removeTo);
            if (rfdoc >= this.pos) {
                rfdoc += this.diff;
                rtdoc += this.diff;
            }
            doc.remove(rfdoc, rtdoc - rfdoc);
            int insertPos = rfdoc;
            StringBuilder sb = new StringBuilder();
            sb.append(name);
            sb.append('=');
            sb.append('\"');
            sb.append(value);
            sb.append('\"');
            doc.insertString(insertPos, sb.toString(), null);
            this.pos = insertPos;
            this.diff = rfdoc - rtdoc + sb.length();
        }
    }

    private void updateSelectorsModel() {
        if (this.project == null) {
            return;
        }
        TreeSet<SelectorItem> items = new TreeSet<SelectorItem>();
        SelectorItem selection = null;
        try {
            CssIndex index = CssIndex.create((Project)this.project);
            DependenciesGraph dependencies = index.getDependencies(this.context);
            Collection allReferedFiles = dependencies.getAllReferedFiles();
            switch (this.selectorTypeList.getSelectedIndex()) {
                case 0: {
                    items.add(this.NO_CLASS);
                    String selectedElementClassName = this.getSelectedElementClassName();
                    SelectorItem existingClassSI = null;
                    Map findAllClassDeclarations = index.findAllClassDeclarations();
                    for (FileObject file : findAllClassDeclarations.keySet()) {
                        if (!allReferedFiles.contains(file)) continue;
                        Collection classes = (Collection)findAllClassDeclarations.get(file);
                        for (String clz : classes) {
                            SelectorItem classSelectorItem = SelectorItem.createClass(clz, file);
                            items.add(classSelectorItem);
                            if (!clz.equals(selectedElementClassName)) continue;
                            existingClassSI = classSelectorItem;
                        }
                    }
                    if (selectedElementClassName != null) {
                        if (existingClassSI == null) {
                            SelectorItem classSelectorItem = SelectorItem.createClass(selectedElementClassName, null);
                            classSelectorItem.setCreateInFile(this.getActiveStylesheet());
                            classSelectorItem.setCreateInAtRule(this.getActiveAtRule());
                            items.add(classSelectorItem);
                            selection = classSelectorItem;
                        } else {
                            selection = existingClassSI;
                        }
                    }
                    if (this.selectedClazz == null) break;
                    selection = this.selectedClazz;
                    break;
                }
                case 1: {
                    items.add(this.NO_ID);
                    String selectedElementIdName = this.getSelectedElementIdName();
                    SelectorItem existingIdSI = null;
                    Map findAllIdDeclarations = index.findAllIdDeclarations();
                    for (FileObject file : findAllIdDeclarations.keySet()) {
                        if (!allReferedFiles.contains(file)) continue;
                        Collection ids = (Collection)findAllIdDeclarations.get(file);
                        for (String id : ids) {
                            SelectorItem idSelectorItem = SelectorItem.createId(id, file);
                            items.add(idSelectorItem);
                            if (!id.equals(selectedElementIdName)) continue;
                            existingIdSI = idSelectorItem;
                        }
                    }
                    if (selectedElementIdName != null) {
                        if (existingIdSI == null) {
                            SelectorItem idSelectorItem = SelectorItem.createId(selectedElementIdName, null);
                            idSelectorItem.setCreateInFile(this.getActiveStylesheet());
                            idSelectorItem.setCreateInAtRule(this.getActiveAtRule());
                            items.add(idSelectorItem);
                            selection = idSelectorItem;
                        } else {
                            selection = existingIdSI;
                        }
                    }
                    if (this.selectedId == null) break;
                    selection = this.selectedId;
                    break;
                }
                case 2: {
                    for (String elementName : this.getElementNames()) {
                        SelectorItem item = SelectorItem.createElement(elementName);
                        item.setCreateInFile(this.getActiveStylesheet());
                        item.setCreateInAtRule(this.getActiveAtRule());
                        items.add(item);
                    }
                    if (this.selectedElement == null) {
                        selection = (SelectorItem)items.iterator().next();
                        break;
                    }
                    selection = this.selectedElement;
                    break;
                }
                case 3: {
                    if (this.compoundSelectorDefaultValue != null) {
                        items.add(SelectorItem.createCompound(this.compoundSelectorDefaultValue));
                    }
                    if (this.selectedCompound == null) {
                        SelectorItem compound = SelectorItem.createCompound(this.compoundSelectorDefaultValue);
                        compound.setCreateInFile(this.getActiveStylesheet());
                        compound.setCreateInAtRule(this.getActiveAtRule());
                        selection = compound;
                        break;
                    }
                    selection = this.selectedCompound;
                }
            }
            this.SELECTORS_MODEL.setItems(items);
            if (selection != null) {
                this.selectorCB.setSelectedItem(selection);
            } else if (this.SELECTORS_MODEL.getSize() > 0) {
                this.selectorCB.setSelectedIndex(0);
            } else {
                this.selectorCB.setSelectedItem(null);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Collection<String> getElementNames() {
        if (this.ELEMENT_SELECTOR_ITEMS == null) {
            this.ELEMENT_SELECTOR_ITEMS = new TreeSet<String>();
            HtmlModel model = HtmlModelFactory.getModel((HtmlVersion)HtmlVersion.HTML5);
            for (HtmlTag tag : model.getAllTags()) {
                this.ELEMENT_SELECTOR_ITEMS.add(tag.getName());
            }
        }
        return this.ELEMENT_SELECTOR_ITEMS;
    }

    private SelectorItemRenderer getSelectorModelItemRenderer() {
        if (this.SELECTOR_MODEL_ITEM_RENDERER == null) {
            this.SELECTOR_MODEL_ITEM_RENDERER = new SelectorItemRenderer();
        }
        return this.SELECTOR_MODEL_ITEM_RENDERER;
    }

    private ListCellRenderer createSelectorsRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    if (value instanceof SelectorItem) {
                        SelectorItem selectorItem = (SelectorItem)value;
                        if (selectorItem == CreateRulePanel.this.NO_CLASS || selectorItem == CreateRulePanel.this.NO_ID) {
                            this.setText(Bundle.none_item());
                            return c;
                        }
                        SelectorItemRenderer selectorModelItemRenderer = CreateRulePanel.this.getSelectorModelItemRenderer();
                        boolean originalElement = false;
                        switch (selectorItem.getType()) {
                            case 0: {
                                originalElement = selectorItem.getItemName().equals(CreateRulePanel.this.getSelectedElementClassName());
                                break;
                            }
                            case 1: {
                                originalElement = selectorItem.getItemName().equals(CreateRulePanel.this.getSelectedElementIdName());
                            }
                        }
                        selectorModelItemRenderer.setItem(selectorItem, isSelected, originalElement);
                        return selectorModelItemRenderer;
                    }
                } else if (value instanceof String) {
                    this.setText((String)value);
                }
                return c;
            }
        };
    }

    private ListCellRenderer createAtRulesRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value == null) {
                    this.setText(Bundle.none_item());
                } else if (value instanceof AtRuleItem) {
                    this.setText(((AtRuleItem)value).getDisplayName());
                } else if (value instanceof String) {
                    this.setText((String)value);
                }
                return c;
            }
        };
    }

    private ListCellRenderer createStylesheetsRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value == null) {
                    return c;
                }
                if (value instanceof FileObject) {
                    FileObject file = (FileObject)value;
                    if (CreateRulePanel.this.webRoot == null) {
                        this.setText(file.getNameExt());
                    } else {
                        String relativePath = FileUtil.getRelativePath((FileObject)CreateRulePanel.this.webRoot, (FileObject)file);
                        if (relativePath != null) {
                            this.setText(relativePath);
                        } else {
                            this.setText(file.getNameExt());
                        }
                    }
                } else if (value instanceof String) {
                    this.setText((String)value);
                }
                return c;
            }
        };
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.selectorTypeList = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.descriptionPane = new JTextPane();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.styleSheetCB = new JComboBox();
        this.atRuleCB = new JComboBox();
        this.jLabel4 = new JLabel();
        this.selectorCB = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.selectorTypeLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CreateRulePanel.class, (String)"CreateRulePanel.jLabel1.text"));
        this.jSplitPane1.setDividerLocation(140);
        this.jSplitPane1.setDividerSize(4);
        this.selectorTypeList.setModel(this.SELECTORS_LIST_MODEL);
        this.selectorTypeList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.selectorTypeList);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.descriptionPane.setEditable(false);
        this.descriptionPane.setText(NbBundle.getMessage(CreateRulePanel.class, (String)"CreateRulePanel.descriptionPane.text"));
        this.descriptionPane.setEnabled(false);
        this.jScrollPane2.setViewportView(this.descriptionPane);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(CreateRulePanel.class, (String)"CreateRulePanel.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(CreateRulePanel.class, (String)"CreateRulePanel.jLabel3.text"));
        this.styleSheetCB.setModel(this.STYLESHEETS_MODEL);
        this.styleSheetCB.setEnabled(false);
        this.styleSheetCB.setRenderer(this.createStylesheetsRenderer());
        this.atRuleCB.setModel(this.AT_RULES_MODEL);
        this.atRuleCB.setEnabled(false);
        this.atRuleCB.setRenderer(this.createAtRulesRenderer());
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(CreateRulePanel.class, (String)"CreateRulePanel.jLabel4.text"));
        this.selectorCB.setEditable(true);
        this.selectorCB.setModel(this.SELECTORS_MODEL);
        this.selectorCB.setEnabled(false);
        this.selectorCB.setRenderer(this.createSelectorsRenderer());
        Mnemonics.setLocalizedText((JLabel)this.selectorTypeLabel, null);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addContainerGap(462, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.selectorTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1).addGap(6, 6, 6)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.atRuleCB, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.styleSheetCB, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.selectorCB, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jSplitPane1, -2, 0, Short.MAX_VALUE).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -2, 88, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator1, -2, 10, -2).addComponent(this.selectorTypeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel4).addComponent(this.selectorCB, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.styleSheetCB, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.atRuleCB, -2, -1, -2).addComponent(this.jLabel3)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public class ExtDefaultComboBoxModel
    extends AbstractListModel
    implements MutableComboBoxModel,
    Serializable {
        private final List objects = new ArrayList();
        private Object selectedObject;

        public void setItems(Collection items) {
            int oldLen = this.objects.size();
            this.objects.clear();
            this.objects.addAll(items);
            this.fireIntervalRemoved(this, 0, oldLen);
            this.fireIntervalAdded(this, 0, this.objects.size());
        }

        public void setSelectedIndex(int index) {
            if (index >= this.objects.size()) {
                return;
            }
            if (index < 0) {
                return;
            }
            this.setSelectedItem(this.objects.get(index));
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (this.selectedObject != null && !this.selectedObject.equals(anObject) || this.selectedObject == null && anObject != null) {
                this.selectedObject = anObject;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedObject;
        }

        @Override
        public int getSize() {
            return this.objects.size();
        }

        @Override
        public Object getElementAt(int index) {
            if (index >= 0 && index < this.objects.size()) {
                return this.objects.get(index);
            }
            return null;
        }

        public int getIndexOf(Object anObject) {
            return this.objects.indexOf(anObject);
        }

        public void addElement(Object anObject) {
            this.objects.add(anObject);
            this.fireIntervalAdded(this, this.objects.size() - 1, this.objects.size() - 1);
            if (this.objects.size() == 1 && this.selectedObject == null && anObject != null) {
                this.setSelectedItem(anObject);
            }
        }

        public void insertElementAt(Object anObject, int index) {
            this.objects.add(index, anObject);
            this.fireIntervalAdded(this, index, index);
        }

        @Override
        public void removeElementAt(int index) {
            if (this.getElementAt(index) == this.selectedObject) {
                if (index == 0) {
                    this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
                } else {
                    this.setSelectedItem(this.getElementAt(index - 1));
                }
            }
            this.objects.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }

        @Override
        public void removeElement(Object anObject) {
            int index = this.objects.indexOf(anObject);
            if (index != -1) {
                this.removeElementAt(index);
            }
        }
    }

    private static class SelectorItemRenderer
    extends JPanel {
        private JLabel west = new JLabel();
        private JLabel east = new JLabel();
        private Color bg;
        private Color bgSelected;
        private Color fg;
        private Color fgSelected;
        private Color inFile;
        private Font plain;
        private Font bold;
        private boolean original;

        public SelectorItemRenderer() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.west, "West");
            this.add((Component)this.east, "East");
            this.fg = UIManager.getDefaults().getColor("ComboBox.foreground");
            this.bg = UIManager.getDefaults().getColor("ComboBox.background");
            this.fgSelected = UIManager.getDefaults().getColor("ComboBox.selectionForeground");
            this.bgSelected = UIManager.getDefaults().getColor("ComboBox.selectionBackground");
            this.inFile = Color.gray;
            this.plain = this.west.getFont();
            this.bold = this.plain.deriveFont(1);
        }

        public void setItem(SelectorItem item, boolean isSelected, boolean originalElement) {
            if (this.original != originalElement) {
                this.west.setFont(originalElement ? this.bold : this.plain);
                this.original = originalElement;
            }
            this.west.setText(item.getItemName());
            this.east.setText(item.getFileDisplayName());
            if (isSelected) {
                this.west.setForeground(this.fgSelected);
                this.east.setForeground(this.fgSelected);
                this.setBackground(this.bgSelected);
            } else {
                this.west.setForeground(this.fg);
                this.east.setForeground(this.inFile);
                this.setBackground(this.bg);
            }
        }
    }

    private static class AtRuleItem {
        private Media media;
        private String displayName;

        public AtRuleItem(String displayName, Media media) {
            this.displayName = displayName;
            this.media = media;
        }

        public Media getMedia() {
            return this.media;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int hashCode() {
            int hash = 7;
            hash = 59 * hash + (this.media != null ? this.media.hashCode() : 0);
            hash = 59 * hash + (this.displayName != null ? this.displayName.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AtRuleItem other = (AtRuleItem)obj;
            if (!(this.media == other.media || this.media != null && this.media.equals(other.media))) {
                return false;
            }
            return !(this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName));
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    private static class SelectorItem
    implements Comparable<SelectorItem> {
        public static final int CLASS_TYPE = 0;
        public static final int ID_TYPE = 1;
        public static final int ELEMENT_TYPE = 2;
        public static final int COMPOUND_TYPE = 3;
        private final int type;
        private final String clz;
        private final String id;
        private final String element;
        private final FileObject existsIn;
        private FileObject createNewIn;
        private AtRuleItem createIn;

        private static SelectorItem createClass(String name, FileObject existsIn) {
            return new SelectorItem(0, name, null, null, existsIn);
        }

        private static SelectorItem createId(String name, FileObject existsIn) {
            return new SelectorItem(1, null, name, null, existsIn);
        }

        private static SelectorItem createElement(String name) {
            return new SelectorItem(2, null, null, name, null);
        }

        private static SelectorItem createCompound(String name) {
            return new SelectorItem(3, null, null, name, null);
        }

        public SelectorItem(int type, String clz, String id, String element, FileObject existsIn) {
            this.type = type;
            this.clz = clz;
            this.id = id;
            this.element = element;
            this.existsIn = existsIn;
        }

        public int getType() {
            return this.type;
        }

        public void setCreateInAtRule(AtRuleItem mediaItem) {
            this.createIn = mediaItem;
        }

        public AtRuleItem getCreateInAtRule() {
            return this.createIn;
        }

        public String getCreateInAtRuleDisplayName() {
            return this.getCreateInAtRule() != null ? this.getCreateInAtRule().getDisplayName() : null;
        }

        public void setCreateInFile(FileObject file) {
            this.createNewIn = file;
        }

        public FileObject getCreateInFile() {
            return this.createNewIn;
        }

        public FileObject getFile() {
            return this.getCreateInFile() != null ? this.getCreateInFile() : this.getExistsInFile();
        }

        public String getCreateInFileDisplayName() {
            return this.getCreateInFile() != null ? this.getCreateInFile().getNameExt() : null;
        }

        public FileObject getExistsInFile() {
            return this.existsIn;
        }

        public String getFileDisplayName() {
            return this.existsIn != null ? this.existsIn.getNameExt() : null;
        }

        public String getItemName() {
            StringBuilder sb = new StringBuilder();
            if (this.clz != null) {
                sb.append(this.clz);
            } else if (this.id != null) {
                sb.append(this.id);
            } else if (this.element != null) {
                sb.append(this.element);
            }
            return sb.length() == 0 ? null : sb.toString();
        }

        public String getItemFQName() {
            StringBuilder sb = new StringBuilder();
            if (this.clz != null) {
                sb.append('.');
                sb.append(this.clz);
            } else if (this.id != null) {
                sb.append('#');
                sb.append(this.id);
            } else if (this.element != null) {
                sb.append(this.element);
            }
            return sb.length() == 0 ? null : sb.toString();
        }

        public String toString() {
            String in = this.getItemName();
            return in != null ? in : "";
        }

        public String getInfo() {
            StringBuilder sb = new StringBuilder();
            sb.append("type=");
            sb.append(this.getType());
            sb.append(", name=");
            sb.append(this.getItemName());
            sb.append(", existsIn=");
            sb.append(this.getFileDisplayName());
            sb.append(", createInFile=");
            sb.append(this.getCreateInFileDisplayName());
            sb.append(", createInAt-Rule=");
            sb.append(this.getCreateInAtRuleDisplayName());
            return sb.toString();
        }

        public int hashCode() {
            int hash = 5;
            hash = 13 * hash + this.type;
            hash = 13 * hash + (this.clz != null ? this.clz.hashCode() : 0);
            hash = 13 * hash + (this.id != null ? this.id.hashCode() : 0);
            hash = 13 * hash + (this.element != null ? this.element.hashCode() : 0);
            hash = 13 * hash + (this.existsIn != null ? this.existsIn.hashCode() : 0);
            hash = 13 * hash + (this.createNewIn != null ? this.createNewIn.hashCode() : 0);
            hash = 13 * hash + (this.createIn != null ? this.createIn.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SelectorItem other = (SelectorItem)obj;
            if (this.type != other.type) {
                return false;
            }
            if (this.clz == null ? other.clz != null : !this.clz.equals(other.clz)) {
                return false;
            }
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            if (this.element == null ? other.element != null : !this.element.equals(other.element)) {
                return false;
            }
            if (!(this.existsIn == other.existsIn || this.existsIn != null && this.existsIn.equals(other.existsIn))) {
                return false;
            }
            if (!(this.createNewIn == other.createNewIn || this.createNewIn != null && this.createNewIn.equals(other.createNewIn))) {
                return false;
            }
            return this.createIn == other.createIn || this.createIn != null && this.createIn.equals(other.createIn);
        }

        @Override
        public int compareTo(SelectorItem o) {
            String herFQN;
            String myFQN = this.getItemFQName();
            String string = herFQN = o == null ? null : o.getItemFQName();
            if (herFQN == null && myFQN != null) {
                return 1;
            }
            if (herFQN != null && myFQN == null) {
                return -1;
            }
            if (herFQN == null && myFQN == null) {
                return 0;
            }
            return myFQN.compareTo(herFQN);
        }
    }
}

