/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.model.extensions.mime.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Fault;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Output;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.mime.MIMEComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.mime.MIMEContent;
import org.netbeans.modules.xml.wsdl.model.extensions.mime.MIMEMimeXml;
import org.netbeans.modules.xml.wsdl.model.extensions.mime.MIMEMultipartRelated;
import org.netbeans.modules.xml.wsdl.model.extensions.mime.MIMEPart;
import org.netbeans.modules.xml.wsdl.model.extensions.mime.MIMEQName;
import org.netbeans.modules.xml.wsdl.model.extensions.mime.validation.MIMEComponentValidator;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBinding;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBody;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPHeader;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPHeaderFault;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPQName;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12Binding;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12Body;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12Header;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12HeaderFault;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12QName;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.util.NbBundle;

public class WSIAPValidator
implements MIMEComponent.Visitor {
    public static final String CONTENT_TYPE_TEXT_XML = "text/xml";
    public static final String NS_URI_SWA_REF = "http://ws-i.org/profiles/basic/1.1/xsd";
    public static final String SCHEMA_TYPE_SWA_REF = "swaRef";
    private final List<Validator.ResultItem> mResults;
    private final MIMEComponentValidator mValidator;
    private WSDLModel mWSDLModel;
    private boolean isSOAPBinding;
    private boolean isSOAP12Binding;

    public WSIAPValidator(MIMEComponentValidator validator, WSDLModel model) {
        this.mValidator = validator;
        this.mResults = new LinkedList<Validator.ResultItem>();
        this.mWSDLModel = model;
    }

    public void validate() {
        Definitions defs = this.mWSDLModel.getDefinitions();
        for (Binding binding : defs.getBindings()) {
            int numSoap12Bindings;
            int numSoapBindings = binding.getExtensibilityElements(SOAPBinding.class).size();
            if (numSoapBindings == 1) {
                this.isSOAP12Binding = false;
                this.isSOAPBinding = true;
                this.visit(binding);
            }
            if ((numSoap12Bindings = binding.getExtensibilityElements(SOAP12Binding.class).size()) != 1) continue;
            this.isSOAP12Binding = true;
            this.isSOAPBinding = false;
            this.visit(binding);
        }
    }

    public List<Validator.ResultItem> getResultItems() {
        return this.mResults;
    }

    private void visit(Binding binding) {
        Collection<BindingOperation> ops = binding.getBindingOperations();
        for (BindingOperation bindingOperation : ops) {
            BindingInput bindingInput = bindingOperation.getBindingInput();
            BindingOutput bindingOutput = bindingOperation.getBindingOutput();
            this.testAP2901(bindingInput, bindingOutput);
            List inputMimeContents = this.getMimeContentElements(bindingInput == null ? new ArrayList() : bindingInput.getExtensibilityElements());
            List outputMimeContents = this.getMimeContentElements(bindingOutput == null ? new ArrayList() : bindingOutput.getExtensibilityElements());
            this.testAP2903_2910_2944(bindingOperation, bindingInput, bindingOutput, inputMimeContents, outputMimeContents);
            this.testAP2911_2906(bindingInput == null ? new ArrayList() : bindingInput.getExtensibilityElements(MIMEMultipartRelated.class), bindingOutput == null ? new ArrayList() : bindingOutput.getExtensibilityElements(MIMEMultipartRelated.class));
            List<MIMEPart> inputMimeParts = this.getAllMimeParts(bindingInput == null ? new ArrayList() : bindingInput.getExtensibilityElements());
            List<MIMEPart> outputMimeParts = this.getAllMimeParts(bindingOutput == null ? new ArrayList() : bindingOutput.getExtensibilityElements());
            this.testAP2909(inputMimeParts, outputMimeParts);
            this.testAP2930(bindingOperation);
        }
    }

    private void visit(BindingFault target) {
        if (target.getExtensibilityElements(MIMEMultipartRelated.class).size() > 0) {
            this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)target, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2930")));
        }
    }

    @Override
    public void visit(MIMEContent target) {
        Part part;
        if (target.getPartRef() == null || target.getPartRef().get() == null) {
            this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)target, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2903_PART")));
        }
        if (target.getPartRef() != null && target.getPartRef().get() != null && ((part = (Part)target.getPartRef().get()).getType() == null && part.getElement() == null || part.getType() != null && part.getElement() != null)) {
            this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)target, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2910")));
        }
        if (target.getPartRef() != null && target.getPartRef().get() != null && (part = (Part)target.getPartRef().get()).getElement() != null && !CONTENT_TYPE_TEXT_XML.equals(target.getType())) {
            this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)target, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2944")));
        }
    }

    @Override
    public void visit(MIMEMimeXml target) {
    }

    @Override
    public void visit(MIMEMultipartRelated target) {
        List<MIMEPart> mimeParts = target.getMIMEParts();
        boolean soapBodyFound = false;
        for (int j = 0; j < mimeParts.size(); ++j) {
            boolean hasSOAPBody = false;
            boolean hasSOAPHEADER = false;
            List<ExtensibilityElement> extElems = mimeParts.get(j).getExtensibilityElements();
            for (int k = 0; k < extElems.size(); ++k) {
                if (extElems.get(k).getQName().equals(SOAPQName.BODY.getQName()) && this.isSOAPBinding || extElems.get(k).getQName().equals(SOAP12QName.BODY.getQName()) && this.isSOAP12Binding) {
                    hasSOAPBody = true;
                    if (soapBodyFound) {
                        if (this.isSOAPBinding) {
                            this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)target, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2911")));
                        } else if (this.isSOAP12Binding) {
                            this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)target, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2911_SOAP12")));
                        }
                    } else {
                        soapBodyFound = true;
                    }
                }
                if ((!extElems.get(k).getQName().equals(SOAPQName.HEADER.getQName()) || !this.isSOAPBinding) && (!extElems.get(k).getQName().equals(SOAP12QName.HEADER.getQName()) || !this.isSOAP12Binding)) continue;
                hasSOAPHEADER = true;
            }
            if (hasSOAPBody || !hasSOAPHEADER) continue;
            if (this.isSOAPBinding) {
                this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)mimeParts.get(j), NbBundle.getMessage(WSIAPValidator.class, (String)"AP2906")));
                continue;
            }
            if (!this.isSOAP12Binding) continue;
            this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)mimeParts.get(j), NbBundle.getMessage(WSIAPValidator.class, (String)"AP2906_SOAP12")));
        }
        if (!soapBodyFound) {
            if (this.isSOAPBinding) {
                this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)target, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2911")));
            } else if (this.isSOAP12Binding) {
                this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)target, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2911_SOAP12")));
            }
        }
    }

    @Override
    public void visit(MIMEPart target) {
        List<MIMEContent> contents = target.getExtensibilityElements(MIMEContent.class);
        if (contents != null && contents.size() > 1) {
            String partVal = contents.get(0).getPart();
            int j = 1;
            if (j < contents.size() && !partVal.equals(contents.get(j).getPart())) {
                this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)target, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2909")));
            }
        }
    }

    private List getMimeContentElements(List extElems) {
        ArrayList<ExtensibilityElement> mimeContentElements = new ArrayList<ExtensibilityElement>();
        if (extElems != null) {
            for (int i = 0; i < extElems.size(); ++i) {
                ExtensibilityElement extElem = (ExtensibilityElement)extElems.get(i);
                if (extElem.getQName().equals(MIMEQName.MULTIPART_RELATED.getQName())) {
                    List<MIMEPart> mimeParts = ((MIMEMultipartRelated)extElem).getMIMEParts();
                    for (int j = 0; j < mimeParts.size(); ++j) {
                        List elems = this.getMimeContentElements(mimeParts.get(j).getExtensibilityElements());
                        mimeContentElements.addAll(elems);
                    }
                    continue;
                }
                if (!extElem.getQName().equals(MIMEQName.CONTENT.getQName())) continue;
                mimeContentElements.add(extElem);
            }
        }
        return mimeContentElements;
    }

    private List<MIMEPart> getAllMimeParts(List extElems) {
        ArrayList<MIMEPart> mimeParts = new ArrayList<MIMEPart>();
        if (extElems != null) {
            for (int i = 0; i < extElems.size(); ++i) {
                ExtensibilityElement extElem = (ExtensibilityElement)extElems.get(i);
                if (!extElem.getQName().equals(MIMEQName.MULTIPART_RELATED.getQName())) continue;
                List<MIMEPart> mParts = ((MIMEMultipartRelated)extElem).getMIMEParts();
                mimeParts.addAll(mParts);
                for (int j = 0; j < mParts.size(); ++j) {
                    List<MIMEPart> elems = this.getAllMimeParts(mParts.get(j).getExtensibilityElements());
                    mimeParts.addAll(elems);
                }
            }
        }
        return mimeParts;
    }

    private List getMimeMultipartElements(List extElems) {
        ArrayList<ExtensibilityElement> mimeMultipartElements = new ArrayList<ExtensibilityElement>();
        if (extElems != null) {
            for (int i = 0; i < extElems.size(); ++i) {
                ExtensibilityElement extElem = (ExtensibilityElement)extElems.get(i);
                if (!extElem.getQName().equals(MIMEQName.MULTIPART_RELATED.getQName())) continue;
                mimeMultipartElements.add(extElem);
                List<MIMEPart> mimeParts = ((MIMEMultipartRelated)extElem).getMIMEParts();
                for (int j = 0; j < mimeParts.size(); ++j) {
                    List elems = this.getMimeMultipartElements(mimeParts.get(j).getExtensibilityElements());
                    mimeMultipartElements.addAll(elems);
                }
            }
        }
        return mimeMultipartElements;
    }

    private void testAP2901(BindingInput bindingInput, BindingOutput bindingOutput) {
        int mimeXMLNum;
        int mimeMultipartNum;
        int mimeConentNum;
        int soapNum;
        if (bindingInput != null) {
            soapNum = 0;
            if (this.isSOAPBinding) {
                soapNum = bindingInput.getExtensibilityElements(SOAPBody.class).size();
            } else if (this.isSOAP12Binding) {
                soapNum = bindingInput.getExtensibilityElements(SOAP12Body.class).size();
            }
            mimeConentNum = bindingInput.getExtensibilityElements(MIMEContent.class).size();
            mimeMultipartNum = bindingInput.getExtensibilityElements(MIMEMultipartRelated.class).size();
            mimeXMLNum = bindingInput.getExtensibilityElements(MIMEMimeXml.class).size();
            if (soapNum == 0 && mimeConentNum == 0 && mimeMultipartNum == 0 && mimeXMLNum == 0) {
                this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingInput, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2901_INPUT")));
            }
        }
        if (bindingOutput != null) {
            soapNum = 0;
            if (this.isSOAPBinding) {
                soapNum = bindingOutput.getExtensibilityElements(SOAPBody.class).size();
            } else if (this.isSOAP12Binding) {
                soapNum = bindingOutput.getExtensibilityElements(SOAP12Body.class).size();
            }
            mimeConentNum = bindingOutput.getExtensibilityElements(MIMEContent.class).size();
            mimeMultipartNum = bindingOutput.getExtensibilityElements(MIMEMultipartRelated.class).size();
            mimeXMLNum = bindingOutput.getExtensibilityElements(MIMEMimeXml.class).size();
            if (soapNum == 0 && mimeConentNum == 0 && mimeMultipartNum == 0 && mimeXMLNum == 0) {
                this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingOutput, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2901_OUTPUT")));
            }
        }
    }

    private void testAP2903_2910_2944(BindingOperation bindingOperation, BindingInput bindingInput, BindingOutput bindingOutput, List inputMimeContents, List outputMimeContents) {
        MIMEContent mimeContent;
        int i;
        if (!inputMimeContents.isEmpty()) {
            Input portTypeInput = ((Operation)bindingOperation.getOperation().get()).getInput();
            if (portTypeInput == null) {
                this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingInput, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2903_PORTTYPE_NULL")));
            } else if (portTypeInput.getMessage() == null) {
                this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingInput, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2903_MESSAGE_NULL")));
            } else {
                for (i = 0; i < inputMimeContents.size(); ++i) {
                    mimeContent = (MIMEContent)inputMimeContents.get(i);
                    mimeContent.accept(this);
                }
            }
        }
        if (!outputMimeContents.isEmpty()) {
            Output portTypeOutput = ((Operation)bindingOperation.getOperation().get()).getOutput();
            if (portTypeOutput == null) {
                this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingOutput, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2903_PORTTYPE_NULL")));
            } else if (portTypeOutput.getMessage() == null) {
                this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingOutput, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2903_MESSAGE_NULL")));
            } else {
                for (i = 0; i < outputMimeContents.size(); ++i) {
                    mimeContent = (MIMEContent)outputMimeContents.get(i);
                    mimeContent.accept(this);
                }
            }
        }
    }

    private void testAP2911_2906(List inputMultiparts, List outputMultiparts) {
        MIMEMultipartRelated multiPart;
        int i;
        if (inputMultiparts != null) {
            for (i = 0; i < inputMultiparts.size(); ++i) {
                multiPart = (MIMEMultipartRelated)inputMultiparts.get(i);
                multiPart.accept(this);
            }
        }
        if (outputMultiparts != null) {
            for (i = 0; i < outputMultiparts.size(); ++i) {
                multiPart = (MIMEMultipartRelated)outputMultiparts.get(i);
                multiPart.accept(this);
            }
        }
    }

    private void testAP2930(BindingOperation bindingOperation) {
        Collection<BindingFault> faults = bindingOperation.getBindingFaults();
        if (!faults.isEmpty()) {
            for (BindingFault fault : faults) {
                this.visit(fault);
            }
        }
    }

    private void testAP2909(List<MIMEPart> inputMimeParts, List<MIMEPart> outputMimeParts) {
        for (MIMEPart part : inputMimeParts) {
            part.accept(this);
        }
        for (MIMEPart part : outputMimeParts) {
            part.accept(this);
        }
    }

    private void testAP2940(Input input, Output output) {
        List<String> swaRefParts;
        if (input == null || input.getMessage() == null || input.getMessage().get() == null || !(swaRefParts = this.getSwaRefParts((Message)input.getMessage().get())).isEmpty()) {
            // empty if block
        }
    }

    private List<String> getSwaRefParts(Message message) {
        ArrayList<String> swaRefParts = new ArrayList<String>();
        for (Part part : message.getParts()) {
            boolean isEle = true;
            if (part.getType() != null) {
                isEle = false;
                QName partRef = part.getType().getQName();
                GlobalType partType = (GlobalType)part.getType().get();
                this.isSwarefType(partType);
                if (partType instanceof GlobalSimpleType) {
                    this.isSwarefType((GlobalSimpleType)partType);
                    continue;
                }
                if (!(partType instanceof GlobalComplexType)) continue;
            }
            if (part.getElement() == null) continue;
            QName qName = part.getElement().getQName();
        }
        return swaRefParts;
    }

    private boolean isSwarefType(GlobalType globalType) {
        if (globalType instanceof GlobalSimpleType) {
            return this.isSwarefType((GlobalSimpleType)globalType);
        }
        return globalType instanceof GlobalComplexType;
    }

    private boolean isSwarefType(GlobalSimpleType simpleType) {
        return NS_URI_SWA_REF.equals(simpleType.getModel().getSchema().getTargetNamespace()) && SCHEMA_TYPE_SWA_REF.equals(simpleType.getName());
    }

    private Collection<String> getPartNames(Collection<Part> parts) {
        ArrayList<String> names = new ArrayList<String>();
        for (Part part : parts) {
            names.add(part.getName());
        }
        return names;
    }

    private Collection<String> getFaultNames(Collection<Fault> faults) {
        ArrayList<String> names = new ArrayList<String>();
        for (Fault fault : faults) {
            names.add(fault.getName());
        }
        return names;
    }

    public void testAP2941(Binding binding, BindingOperation bindingOperation, BindingInput bindingInput, BindingOutput bindingOutput, Input portTypeInput, Output portTypeOutput) {
        List outputParts;
        List inputParts;
        if (portTypeInput != null && portTypeInput.getMessage() != null && !(inputParts = this.getBindingParts_AP2941(bindingOperation.getBindingInput().getExtensibilityElements(), (Message)portTypeInput.getMessage().get())).containsAll(this.getPartNames(((Message)portTypeInput.getMessage().get()).getParts()))) {
            this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingInput, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2941")));
        }
        if (portTypeOutput != null && portTypeOutput.getMessage() != null && !(outputParts = this.getBindingParts_AP2941(bindingOperation.getBindingOutput().getExtensibilityElements(), (Message)portTypeOutput.getMessage().get())).containsAll(this.getPartNames(((Message)portTypeOutput.getMessage().get()).getParts()))) {
            this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingOutput, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2941")));
        }
    }

    private List getBindingParts_AP2941(List extElems, Message message) {
        ArrayList<String> parts;
        block16: {
            block15: {
                parts = new ArrayList<String>();
                if (!this.isSOAPBinding) break block15;
                if (extElems == null) break block16;
                for (int i = 0; i < extElems.size(); ++i) {
                    ExtensibilityElement extElem = (ExtensibilityElement)extElems.get(i);
                    if (extElem instanceof SOAPBody) {
                        List<String> pts = ((SOAPBody)extElem).getParts();
                        if (pts == null) continue;
                        parts.addAll(pts);
                        continue;
                    }
                    if (extElem instanceof SOAPHeader) {
                        Collection<SOAPHeaderFault> headerFaults = null;
                        if (!(extElem instanceof SOAPHeader)) continue;
                        SOAPHeader header = (SOAPHeader)extElem;
                        if (message.equals(header.getMessage().get())) {
                            parts.add(header.getPart());
                        }
                        headerFaults = header.getSOAPHeaderFaults();
                        for (SOAPHeaderFault hFault : headerFaults) {
                            if (!message.equals(hFault.getMessage().get())) continue;
                            parts.add(hFault.getPart());
                        }
                        continue;
                    }
                    if (extElem instanceof MIMEContent) {
                        parts.add(((MIMEContent)extElem).getPart());
                        continue;
                    }
                    if (!(extElem instanceof MIMEMultipartRelated)) continue;
                    List<MIMEPart> mimeParts = ((MIMEMultipartRelated)extElem).getMIMEParts();
                    for (int j = 0; j < mimeParts.size(); ++j) {
                        parts.addAll(this.getBindingParts_AP2941(mimeParts.get(j).getExtensibilityElements(), message));
                    }
                }
                break block16;
            }
            if (this.isSOAP12Binding && extElems != null) {
                for (int i = 0; i < extElems.size(); ++i) {
                    ExtensibilityElement extElem = (ExtensibilityElement)extElems.get(i);
                    if (extElem instanceof SOAP12Body) {
                        List<String> pts = ((SOAP12Body)extElem).getParts();
                        if (pts == null) continue;
                        parts.addAll(pts);
                        continue;
                    }
                    if (extElem instanceof SOAP12Header) {
                        Collection<SOAP12HeaderFault> headerFaults = null;
                        if (!(extElem instanceof SOAP12Header)) continue;
                        SOAP12Header header = (SOAP12Header)extElem;
                        if (message.equals(header.getMessage().get())) {
                            parts.add(header.getPart());
                        }
                        headerFaults = header.getSOAPHeaderFaults();
                        for (SOAP12HeaderFault hFault : headerFaults) {
                            if (!message.equals(hFault.getMessage().get())) continue;
                            parts.add(hFault.getPart());
                        }
                        continue;
                    }
                    if (extElem instanceof MIMEContent) {
                        parts.add(((MIMEContent)extElem).getPart());
                        continue;
                    }
                    if (!(extElem instanceof MIMEMultipartRelated)) continue;
                    List<MIMEPart> mimeParts = ((MIMEMultipartRelated)extElem).getMIMEParts();
                    for (int j = 0; j < mimeParts.size(); ++j) {
                        parts.addAll(this.getBindingParts_AP2941(mimeParts.get(j).getExtensibilityElements(), message));
                    }
                }
            }
        }
        return parts;
    }
}

