/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeNodeDecl;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.Util;
import org.netbeans.tax.spec.ConditionalSection;
import org.netbeans.tax.spec.DTD;
import org.netbeans.tax.spec.DocumentType;
import org.netbeans.tax.spec.ParameterEntityReference;

public class TreeNotationDecl
extends TreeNodeDecl
implements DTD.Child,
ParameterEntityReference.Child,
DocumentType.Child,
ConditionalSection.Child {
    public static final String PROP_NAME = "name";
    public static final String PROP_PUBLIC_ID = "publicId";
    public static final String PROP_SYSTEM_ID = "systemId";
    private String name;
    private String systemId;
    private String publicId;

    public TreeNotationDecl(String name, String publicId, String systemId) throws InvalidArgumentException {
        this.checkName(name);
        this.name = name;
        this.checkPublicId(publicId);
        this.checkSystemId(systemId);
        this.checkExternalId(publicId, systemId);
        this.systemId = systemId;
        this.publicId = publicId;
    }

    protected TreeNotationDecl(TreeNotationDecl notationDecl) {
        super(notationDecl);
        this.name = notationDecl.name;
        this.publicId = notationDecl.publicId;
        this.systemId = notationDecl.systemId;
    }

    @Override
    public Object clone() {
        return new TreeNotationDecl(this);
    }

    @Override
    public boolean equals(Object object, boolean deep) {
        if (!super.equals(object, deep)) {
            return false;
        }
        TreeNotationDecl peer = (TreeNotationDecl)object;
        if (!Util.equals(this.getName(), peer.getName())) {
            return false;
        }
        if (!Util.equals(this.getSystemId(), peer.getSystemId())) {
            return false;
        }
        return Util.equals(this.getPublicId(), peer.getPublicId());
    }

    @Override
    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeNotationDecl peer = (TreeNotationDecl)treeObject;
        this.setNameImpl(peer.getName());
        this.setSystemIdImpl(peer.getSystemId());
        this.setPublicIdImpl(peer.getPublicId());
    }

    public String getName() {
        return this.name;
    }

    private final void setNameImpl(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChange(PROP_NAME, oldName, newName);
    }

    public final void setName(String newName) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.name, newName)) {
            return;
        }
        this.checkReadOnly();
        this.checkName(newName);
        this.setNameImpl(newName);
    }

    protected final void checkName(String name) throws InvalidArgumentException {
        TreeUtilities.checkNotationDeclName(name);
    }

    public String getPublicId() {
        return this.publicId;
    }

    private final void setPublicIdImpl(String newPublicId) {
        String oldPublicId = this.publicId;
        this.publicId = newPublicId;
        this.firePropertyChange(PROP_PUBLIC_ID, oldPublicId, newPublicId);
    }

    public final void setPublicId(String newPublicId) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.publicId, newPublicId)) {
            return;
        }
        this.checkReadOnly();
        this.checkPublicId(newPublicId);
        this.checkExternalId(newPublicId, this.systemId);
        this.setPublicIdImpl(newPublicId);
    }

    protected final void checkPublicId(String publicId) throws InvalidArgumentException {
        TreeUtilities.checkNotationDeclPublicId(publicId);
    }

    public String getSystemId() {
        return this.systemId;
    }

    private final void setSystemIdImpl(String newSystemId) {
        String oldSystemId = this.systemId;
        this.systemId = newSystemId;
        this.firePropertyChange(PROP_SYSTEM_ID, oldSystemId, newSystemId);
    }

    public final void setSystemId(String newSystemId) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.systemId, newSystemId)) {
            return;
        }
        this.checkReadOnly();
        this.checkSystemId(newSystemId);
        this.checkExternalId(this.publicId, newSystemId);
        this.setSystemIdImpl(newSystemId);
    }

    protected final void checkSystemId(String systemId) throws InvalidArgumentException {
        TreeUtilities.checkNotationDeclSystemId(systemId);
    }

    protected final void checkExternalId(String publicId, String systemId) throws InvalidArgumentException {
        if (publicId == null && systemId == null) {
            throw new InvalidArgumentException(Util.THIS.getString("EXC_invalid_nulls"), new NullPointerException());
        }
    }
}

