/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.LoggerHintsCustomizer;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.CustomizerProvider;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public final class NoLoggers {
    public static Iterable<ErrorDescription> checkNoLoggers(HintContext ctx) {
        List<String> customLoggerClasses;
        Element cls = ctx.getInfo().getTrees().getElement(ctx.getPath());
        if (cls == null || cls.getKind() != ElementKind.CLASS || cls.getModifiers().contains((Object)Modifier.ABSTRACT) || cls.getEnclosingElement() != null && cls.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
            return null;
        }
        TypeElement loggerTypeElement = ctx.getInfo().getElements().getTypeElement("java.util.logging.Logger");
        if (loggerTypeElement == null) {
            return null;
        }
        TypeMirror loggerTypeElementAsType = loggerTypeElement.asType();
        if (loggerTypeElementAsType == null || loggerTypeElementAsType.getKind() != TypeKind.DECLARED) {
            return null;
        }
        ArrayList<TypeMirror> customLoggersList = new ArrayList<TypeMirror>();
        if (NoLoggers.isCustomEnabled(ctx.getPreferences()) && (customLoggerClasses = NoLoggers.getCustomLoggers(ctx.getPreferences())) != null) {
            for (String className : customLoggerClasses) {
                TypeMirror customTypeMirror;
                TypeElement customTypeElement = ctx.getInfo().getElements().getTypeElement(className);
                if (customTypeElement == null || (customTypeMirror = customTypeElement.asType()) == null || customTypeMirror.getKind() != TypeKind.DECLARED) continue;
                customLoggersList.add(customTypeMirror);
            }
        }
        LinkedList<VariableElement> loggerFields = new LinkedList<VariableElement>();
        List<VariableElement> fields = ElementFilter.fieldsIn(cls.getEnclosedElements());
        for (VariableElement f : fields) {
            if (f.getKind() != ElementKind.FIELD) continue;
            if (f.asType().equals(loggerTypeElementAsType)) {
                loggerFields.add(f);
                continue;
            }
            if (!customLoggersList.contains(f.asType())) continue;
            loggerFields.add(f);
        }
        if (loggerFields.size() == 0) {
            return Collections.singleton(ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)NbBundle.getMessage(NoLoggers.class, (String)"MSG_NoLoggers_checkNoLoggers", (Object)cls), (Fix[])new Fix[]{new NoLoggersFix(NbBundle.getMessage(NoLoggers.class, (String)"MSG_NoLoggers_checkNoLoggers_Fix", (Object)cls), TreePathHandle.create((Element)cls, (CompilationInfo)ctx.getInfo())).toEditorFix()}));
        }
        return null;
    }

    private static boolean isCustomEnabled(Preferences p) {
        return p.getBoolean("custom-loggers", false);
    }

    private static List<String> getCustomLoggers(Preferences p) {
        String loggers = p.get("custom-loggers-list", null);
        if (loggers == null) {
            return null;
        }
        ArrayList<String> loggersList = new ArrayList<String>();
        String[] tmpArray = loggers.split(",");
        loggersList.addAll(Arrays.asList(tmpArray));
        return loggersList;
    }

    private static final class NoLoggersFix
    extends JavaFix {
        private final String description;

        public NoLoggersFix(String description, TreePathHandle loggerFieldHandle) {
            super(loggerFieldHandle);
            this.description = description;
        }

        public String getText() {
            return this.description;
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            TreeMaker m = wc.getTreeMaker();
            ClassTree classTree = (ClassTree)tp.getLeaf();
            Element cls = wc.getTrees().getElement(tp);
            if (cls == null) {
                return;
            }
            String loggerFieldName = null;
            List<VariableElement> fields = ElementFilter.fieldsIn(cls.getEnclosedElements());
            if (!NoLoggersFix.contains(fields, "LOG")) {
                loggerFieldName = "LOG";
            } else if (!NoLoggersFix.contains(fields, "LOGGER")) {
                loggerFieldName = "LOGGER";
            } else {
                for (int i = 1; i < Integer.MAX_VALUE; ++i) {
                    String n = "LOG" + i;
                    if (NoLoggersFix.contains(fields, n)) continue;
                    loggerFieldName = n;
                    break;
                }
            }
            if (loggerFieldName == null) {
                return;
            }
            HashSet<Modifier> mods = new HashSet<Modifier>();
            mods.add(Modifier.PRIVATE);
            mods.add(Modifier.STATIC);
            mods.add(Modifier.FINAL);
            ModifiersTree mt = m.Modifiers(mods);
            TypeElement loggerTypeElement = wc.getElements().getTypeElement("java.util.logging.Logger");
            if (loggerTypeElement == null) {
                return;
            }
            ExpressionTree loggerClassQualIdent = m.QualIdent((Element)loggerTypeElement);
            MemberSelectTree getLogger = m.MemberSelect(loggerClassQualIdent, (CharSequence)"getLogger");
            MethodInvocationTree initializer = m.MethodInvocation(Collections.emptyList(), (ExpressionTree)getLogger, Collections.singletonList(m.MethodInvocation(Collections.emptyList(), (ExpressionTree)m.MemberSelect(m.QualIdent(cls), (CharSequence)"class.getName"), Collections.emptyList())));
            VariableTree nueLogger = m.Variable(mt, (CharSequence)loggerFieldName, (Tree)loggerClassQualIdent, (ExpressionTree)initializer);
            ClassTree nueClassTree = m.addClassMember(classTree, (Tree)nueLogger);
            wc.rewrite((Tree)classTree, (Tree)nueClassTree);
        }

        private static boolean contains(Collection<VariableElement> fields, String name) {
            for (VariableElement f : fields) {
                if (!f.getSimpleName().contentEquals(name)) continue;
                return true;
            }
            return false;
        }
    }

    public static final class NoLoggersCustomizer
    implements CustomizerProvider {
        public JComponent getCustomizer(Preferences prefs) {
            return new LoggerHintsCustomizer(prefs);
        }
    }
}

