/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.hyperlink;

import java.io.IOException;
import java.util.Map;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.editor.SpringXMLConfigEditorUtils;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkEnv;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkProcessor;
import org.netbeans.modules.spring.java.JavaUtils;
import org.netbeans.modules.spring.java.Public;
import org.netbeans.modules.spring.java.Static;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class FactoryMethodHyperlinkProcessor
extends HyperlinkProcessor {
    @Override
    public void process(HyperlinkEnv env) {
        Map<String, String> beanAttributes = env.getBeanAttributes();
        SpringBean mergedBean = SpringXMLConfigEditorUtils.getMergedBean(beanAttributes, env.getFileObject());
        if (mergedBean == null) {
            return;
        }
        Static staticFlag = Static.YES;
        final String[] className = new String[]{mergedBean.getClassName()};
        if (mergedBean.getFactoryBean() != null) {
            final String factoryBeanName = mergedBean.getFactoryBean();
            FileObject fo = env.getFileObject();
            if (fo == null) {
                return;
            }
            SpringConfigModel model = SpringConfigModel.forFileObject(fo);
            if (model != null) {
                try {
                    model.runReadAction(new Action<SpringBeans>(){

                        @Override
                        public void run(SpringBeans beans) {
                            SpringBean bean = beans.findBean(factoryBeanName);
                            if (bean == null) {
                                className[0] = null;
                                return;
                            }
                            className[0] = bean.getClassName();
                        }
                    });
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                    className[0] = null;
                }
            } else {
                className[0] = null;
            }
            staticFlag = Static.NO;
        }
        if (className[0] != null) {
            String methodName = mergedBean.getFactoryMethod();
            JavaUtils.openMethodInEditor(env.getFileObject(), className[0], methodName, -1, Public.DONT_CARE, staticFlag);
        }
    }
}

