/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.attribute;

import com.sun.source.tree.Tree;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.j2ee.jpa.model.AttributeWrapper;
import org.netbeans.modules.j2ee.jpa.verification.JPAEntityAttributeCheck;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Utilities;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Version;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class ValidVersionType
extends JPAEntityAttributeCheck {
    private static Collection<String> validVersionTypes = new TreeSet<String>(Arrays.asList("java.lang.Short", "java.lang.Integer", "java.lang.Long", "short", "int", "long", "java.sql.Timestamp"));

    @Override
    public Collection<ErrorDescription> check(JPAProblemContext ctx, HintContext hc, AttributeWrapper attrib) {
        if (attrib.getModelElement() instanceof Version) {
            TreeUtilities treeUtils = ctx.getCompilationInfo().getTreeUtilities();
            Types types = ctx.getCompilationInfo().getTypes();
            TypeMirror attrType = attrib.getType();
            for (String typeName : validVersionTypes) {
                TypeMirror type = treeUtils.parseType(typeName, ctx.getJavaClass());
                if (type == null || !types.isSameType(attrType, type)) continue;
                return null;
            }
            Tree elementTree = ctx.getCompilationInfo().getTrees().getTree(attrib.getJavaElement());
            Utilities.TextSpan underlineSpan = Utilities.getUnderlineSpan(ctx.getCompilationInfo(), elementTree);
            ErrorDescription error = ErrorDescriptionFactory.forSpan((HintContext)hc, (int)underlineSpan.getStartOffset(), (int)underlineSpan.getEndOffset(), (String)NbBundle.getMessage(ValidVersionType.class, (String)"MSG_InvalidVersionType"), (Fix[])new Fix[0]);
            return Collections.singleton(error);
        }
        return null;
    }
}

