/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.configurations;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.codehaus.plexus.util.StringUtils;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.ProjectProfileHandler;
import org.netbeans.modules.maven.configurations.ConfigurationPersistenceUtils;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.customizer.CustomizerProviderImpl;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class M2ConfigProvider
implements ProjectConfigurationProvider<M2Configuration> {
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final NbMavenProjectImpl project;
    private final M2Configuration DEFAULT;
    private SortedSet<M2Configuration> profiles = null;
    private SortedSet<M2Configuration> shared = null;
    private SortedSet<M2Configuration> nonshared = null;
    private M2Configuration active;
    private String initialActive;
    private final AtomicBoolean initialActiveLoaded = new AtomicBoolean(false);
    private final AuxiliaryConfiguration aux;
    private final ProjectProfileHandler profileHandler;
    private final PropertyChangeListener propertyChange;
    private static final RequestProcessor RP = new RequestProcessor(M2ConfigProvider.class.getName(), 10);

    public M2ConfigProvider(NbMavenProjectImpl proj, AuxiliaryConfiguration aux, ProjectProfileHandler prof) {
        this.project = proj;
        this.aux = aux;
        this.profileHandler = prof;
        this.active = this.DEFAULT = M2Configuration.createDefault(this.project.getProjectDirectory());
        this.propertyChange = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("MavenProject".equals(evt.getPropertyName())) {
                    M2ConfigProvider m2ConfigProvider = M2ConfigProvider.this;
                    synchronized (m2ConfigProvider) {
                        M2ConfigProvider.this.profiles = null;
                        M2ConfigProvider.this.shared = null;
                        M2ConfigProvider.this.nonshared = null;
                        M2ConfigProvider.this.initialActive = M2ConfigProvider.this.active != null ? M2ConfigProvider.this.active.getId() : null;
                        M2ConfigProvider.this.active = M2ConfigProvider.this.DEFAULT;
                    }
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            M2ConfigProvider.this.checkActiveAgainstAll(M2ConfigProvider.this.getConfigurations(), false);
                            M2ConfigProvider.this.firePropertyChange();
                        }
                    });
                }
            }
        };
    }

    private String getInitialActive() {
        if (this.initialActiveLoaded.compareAndSet(false, true)) {
            this.initialActive = ConfigurationPersistenceUtils.readActiveConfigurationName(this.aux);
        }
        return this.initialActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkActiveAgainstAll(Collection<M2Configuration> confs, boolean async) {
        String id;
        assert (!Thread.holdsLock(this));
        boolean found = false;
        M2ConfigProvider m2ConfigProvider = this;
        synchronized (m2ConfigProvider) {
            id = this.active.getId();
        }
        for (M2Configuration conf : confs) {
            if (!conf.getId().equals(id)) continue;
            found = true;
            break;
        }
        if (!found) {
            Runnable dothis = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    M2Configuration _active;
                    M2ConfigProvider m2ConfigProvider = M2ConfigProvider.this;
                    synchronized (m2ConfigProvider) {
                        _active = M2ConfigProvider.this.active;
                    }
                    try {
                        M2ConfigProvider.this.doSetActiveConfiguration(M2ConfigProvider.this.DEFAULT, _active);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            };
            if (async) {
                RP.post(dothis);
            } else {
                dothis.run();
            }
        }
    }

    private synchronized Collection<M2Configuration> getConfigurations(boolean skipProfiles) {
        if (this.profiles == null && !skipProfiles) {
            this.profiles = this.createProfilesList();
        }
        if (this.shared == null) {
            this.shared = ConfigurationPersistenceUtils.readConfigurations(this.aux, this.project.getProjectDirectory(), true);
        }
        if (this.nonshared == null) {
            this.nonshared = ConfigurationPersistenceUtils.readConfigurations(this.aux, this.project.getProjectDirectory(), false);
        }
        TreeSet<M2Configuration> toRet = new TreeSet<M2Configuration>();
        toRet.add(this.DEFAULT);
        toRet.addAll(this.shared);
        toRet.addAll(this.nonshared);
        if (!skipProfiles) {
            Iterator it = this.profiles.iterator();
            while (it.hasNext()) {
                M2Configuration c = (M2Configuration)it.next();
                if (!toRet.contains(c)) {
                    toRet.add(c);
                    continue;
                }
                it.remove();
            }
        }
        return toRet;
    }

    public synchronized Collection<M2Configuration> getConfigurations() {
        return this.getConfigurations(false);
    }

    public M2Configuration getDefaultConfig() {
        return this.DEFAULT;
    }

    public synchronized Collection<M2Configuration> getProfileConfigurations() {
        this.getConfigurations();
        return this.profiles;
    }

    public synchronized Collection<M2Configuration> getSharedConfigurations() {
        this.getConfigurations();
        return this.shared;
    }

    public synchronized Collection<M2Configuration> getNonSharedConfigurations() {
        this.getConfigurations();
        return this.nonshared;
    }

    public boolean hasCustomizer() {
        return true;
    }

    public void customize() {
        CustomizerProviderImpl prv = (CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class);
        prv.showCustomizer("CONFIGURATION");
    }

    public boolean configurationsAffectAction(String action) {
        return !"delete".equals(action) && !"copy".equals(action) && !"move".equals(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public M2Configuration getActiveConfiguration() {
        M2Configuration _active;
        Collection<M2Configuration> confs;
        M2ConfigProvider m2ConfigProvider = this;
        synchronized (m2ConfigProvider) {
            confs = this.getConfigurations(false);
            String initAct = this.getInitialActive();
            if (initAct != null) {
                for (M2Configuration conf : confs) {
                    if (!initAct.equals(conf.getId())) continue;
                    this.active = conf;
                    initAct = null;
                    break;
                }
                if (initAct != null) {
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                M2ConfigProvider.this.doSetActiveConfiguration(M2ConfigProvider.this.DEFAULT, null);
                            }
                            catch (Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    });
                }
                this.initialActive = null;
            }
            _active = this.active;
        }
        this.checkActiveAgainstAll(confs, true);
        return _active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigurations(List<M2Configuration> shared, List<M2Configuration> nonshared, boolean includeProfiles) {
        M2ConfigProvider.writeAuxiliaryData(this.aux, true, shared);
        M2ConfigProvider.writeAuxiliaryData(this.aux, false, nonshared);
        M2ConfigProvider m2ConfigProvider = this;
        synchronized (m2ConfigProvider) {
            this.shared = new TreeSet<M2Configuration>(shared);
            this.nonshared = new TreeSet<M2Configuration>(nonshared);
            if (this.active != null) {
                M2Configuration newActive;
                if (shared.contains(this.active)) {
                    this.active = newActive = shared.get(shared.indexOf(this.active));
                }
                if (nonshared.contains(this.active)) {
                    this.active = newActive = nonshared.get(nonshared.indexOf(this.active));
                }
            }
            this.profiles = null;
        }
        this.firePropertyChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveConfiguration(M2Configuration configuration) throws IllegalArgumentException, IOException {
        M2Configuration _active;
        M2ConfigProvider m2ConfigProvider = this;
        synchronized (m2ConfigProvider) {
            if (this.active == configuration || this.active != null && this.active.equals(configuration)) {
                return;
            }
            _active = this.active;
        }
        this.doSetActiveConfiguration(configuration, _active);
        NbMavenProject.fireMavenProjectReload(this.project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSetActiveConfiguration(M2Configuration newone, M2Configuration old) throws IllegalArgumentException, IOException {
        M2Configuration _active;
        M2ConfigProvider m2ConfigProvider = this;
        synchronized (m2ConfigProvider) {
            this.active = newone;
            M2ConfigProvider.writeAuxiliaryData(this.aux, "activated", this.active.getId());
            _active = this.active;
        }
        assert (!Thread.holdsLock(this));
        this.support.firePropertyChange("activeConfiguration", old, _active);
    }

    private SortedSet<M2Configuration> createProfilesList() {
        List<String> profs = this.profileHandler.getAllProfiles();
        TreeSet<M2Configuration> config = new TreeSet<M2Configuration>();
        for (String prof : profs) {
            M2Configuration c = new M2Configuration(prof, this.project.getProjectDirectory());
            c.setActivatedProfiles(Collections.singletonList(prof));
            config.add(c);
        }
        return config;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener lst) {
        if (this.support.getPropertyChangeListeners().length == 0) {
            this.project.getProjectWatcher().addPropertyChangeListener(this.propertyChange);
        }
        this.support.addPropertyChangeListener(lst);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener lst) {
        this.support.removePropertyChangeListener(lst);
        if (this.support.getPropertyChangeListeners().length == 0) {
            this.project.getProjectWatcher().removePropertyChangeListener(this.propertyChange);
        }
    }

    private void firePropertyChange() {
        this.support.firePropertyChange("configurations", null, null);
    }

    public static void writeAuxiliaryData(AuxiliaryConfiguration conf, String property, String value) {
        Element enEl;
        NodeList list;
        Element el = conf.getConfigurationFragment("config-data", "http://www.netbeans.org/ns/maven-config-data/1", false);
        if (el == null) {
            el = XMLUtil.createDocument((String)"config-data", (String)"http://www.netbeans.org/ns/maven-config-data/1", null, null).getDocumentElement();
        }
        if ((list = el.getElementsByTagNameNS("http://www.netbeans.org/ns/maven-config-data/1", property)).getLength() > 0) {
            enEl = (Element)list.item(0);
        } else {
            enEl = el.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/maven-config-data/1", property);
            el.appendChild(enEl);
        }
        enEl.setTextContent(value);
        conf.putConfigurationFragment(el, false);
    }

    private static void writeAuxiliaryData(AuxiliaryConfiguration conf, boolean shared, List<M2Configuration> configs) {
        Element enEl;
        NodeList list;
        if (configs.isEmpty()) {
            conf.removeConfigurationFragment("config-data", "http://www.netbeans.org/ns/maven-config-data/1", shared);
            return;
        }
        Element el = conf.getConfigurationFragment("config-data", "http://www.netbeans.org/ns/maven-config-data/1", shared);
        if (el == null) {
            el = XMLUtil.createDocument((String)"config-data", (String)"http://www.netbeans.org/ns/maven-config-data/1", null, null).getDocumentElement();
        }
        if ((list = el.getElementsByTagNameNS("http://www.netbeans.org/ns/maven-config-data/1", "configurations")).getLength() > 0) {
            enEl = (Element)list.item(0);
            NodeList nl = enEl.getChildNodes();
            int len = nl.getLength();
            for (int i = 0; i < len; ++i) {
                enEl.removeChild(nl.item(0));
            }
        } else {
            enEl = el.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/maven-config-data/1", "configurations");
            el.appendChild(enEl);
        }
        for (M2Configuration config : configs) {
            Element child = enEl.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/maven-config-data/1", "configuration");
            child.setAttribute("id", config.getId());
            child.setAttribute("profiles", StringUtils.join(config.getActivatedProfiles().iterator(), (String)" "));
            for (Map.Entry<String, String> entry : config.getProperties().entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key == null || value == null) continue;
                Element prop = enEl.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/maven-config-data/1", "property");
                prop.setAttribute("name", key);
                prop.setTextContent(value);
                child.appendChild(prop);
            }
            enEl.appendChild(child);
        }
        conf.putConfigurationFragment(el, shared);
    }
}

