/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals;

import java.io.IOException;
import java.security.AccessController;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.SaslExtensions;
import org.apache.kafka.common.security.auth.SaslExtensionsCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;

public class OAuthBearerSaslClientCallbackHandler
implements AuthenticateCallbackHandler {
    private boolean configured = false;

    public boolean configured() {
        return this.configured;
    }

    @Override
    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        if (!"OAUTHBEARER".equals(saslMechanism)) {
            throw new IllegalArgumentException(String.format("Unexpected SASL mechanism: %s", saslMechanism));
        }
        this.configured = true;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (!this.configured()) {
            throw new IllegalStateException("Callback handler not configured");
        }
        for (Callback callback : callbacks) {
            if (callback instanceof OAuthBearerTokenCallback) {
                this.handleCallback((OAuthBearerTokenCallback)callback);
                continue;
            }
            if (callback instanceof SaslExtensionsCallback) {
                OAuthBearerSaslClientCallbackHandler.handleCallback((SaslExtensionsCallback)callback, Subject.getSubject(AccessController.getContext()));
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    @Override
    public void close() {
    }

    private void handleCallback(OAuthBearerTokenCallback callback) throws IOException {
        Set privateCredentials;
        if (callback.token() != null) {
            throw new IllegalArgumentException("Callback had a token already");
        }
        Subject subject = Subject.getSubject(AccessController.getContext());
        Set<Object> set = privateCredentials = subject != null ? subject.getPrivateCredentials(OAuthBearerToken.class) : Collections.emptySet();
        if (privateCredentials.size() != 1) {
            throw new IOException(String.format("Unable to find OAuth Bearer token in Subject's private credentials (size=%d)", privateCredentials.size()));
        }
        callback.token((OAuthBearerToken)privateCredentials.iterator().next());
    }

    private static void handleCallback(SaslExtensionsCallback extensionsCallback, Subject subject) {
        if (subject != null && !subject.getPublicCredentials(SaslExtensions.class).isEmpty()) {
            SaslExtensions extensions = subject.getPublicCredentials(SaslExtensions.class).iterator().next();
            extensionsCallback.extensions(extensions);
        }
    }
}

