/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFrame;
import org.python.core.PyObject;
import org.python.core.PyTraceback$PyExposer;
import org.python.core.PyType;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.core.util.RelativeFile;
import org.python.expose.ExposedType;

@ExposedType(name="traceback", isBaseType=false)
public class PyTraceback
extends PyObject
implements Traverseproc {
    public static final PyType TYPE;
    public PyObject tb_next;
    public PyFrame tb_frame;
    public int tb_lineno;

    public PyTraceback(PyTraceback next, PyFrame frame) {
        super(TYPE);
        this.tb_next = next;
        this.tb_frame = frame;
        this.tb_lineno = frame.f_code.getline(frame);
    }

    private String tracebackInfo() {
        if (this.tb_frame == null || this.tb_frame.f_code == null) {
            return String.format("  (no code object) at line %s\n", this.tb_lineno);
        }
        String line = null;
        if (this.tb_frame.f_code.co_filename != null) {
            line = this.getLine(this.tb_frame.f_code.co_filename, this.tb_lineno);
        }
        return String.format("  File \"%.500s\", line %d, in %.500s\n%s", this.tb_frame.f_code.co_filename, this.tb_lineno, this.tb_frame.f_code.co_name, line == null ? "" : "    " + line);
    }

    private String getLine(String filename, int lineno) {
        PyFile pyFile;
        RelativeFile file = new RelativeFile(filename);
        try {
            if (!file.isFile() || !file.canRead()) {
                return null;
            }
        }
        catch (SecurityException e) {
            return null;
        }
        try {
            pyFile = new PyFile(this.tb_frame.f_code.co_filename, "U", -1);
        }
        catch (PyException pye) {
            return null;
        }
        String line = null;
        int i = 0;
        try {
            for (i = 0; i < this.tb_lineno && !(line = pyFile.readline().asString()).equals(""); ++i) {
            }
        }
        catch (PyException pyException) {
            // empty catch block
        }
        try {
            pyFile.close();
        }
        catch (PyException pyException) {
            // empty catch block
        }
        if (line != null && i == this.tb_lineno) {
            char c;
            for (i = 0; i < line.length() && ((c = line.charAt(i)) == ' ' || c == '\t' || c == '\f'); ++i) {
            }
            if (!(line = line.substring(i)).endsWith("\n")) {
                line = line + "\n";
            }
        } else {
            line = null;
        }
        return line;
    }

    public void dumpStack(StringBuilder buf) {
        buf.append(this.tracebackInfo());
        if (this.tb_next != null && this.tb_next != this) {
            ((PyTraceback)this.tb_next).dumpStack(buf);
        } else if (this.tb_next == this) {
            buf.append("circularity detected!" + this + this.tb_next);
        }
    }

    public String dumpStack() {
        StringBuilder buf = new StringBuilder();
        buf.append("Traceback (most recent call last):\n");
        this.dumpStack(buf);
        return buf.toString();
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal;
        if (this.tb_next != null && (retVal = visit.visit(this.tb_next, arg)) != 0) {
            return retVal;
        }
        return this.tb_frame == null ? 0 : visit.visit(this.tb_frame, arg);
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (ob == this.tb_next || ob == this.tb_frame);
    }

    static {
        PyType.addBuilder(PyTraceback.class, new PyTraceback$PyExposer());
        TYPE = PyType.fromClass(PyTraceback.class);
    }
}

