### WARNING: This file is auto-generated by the asana-api-meta repo. Do not
### edit it manually.

module Asana
  module Resources
    # With the introduction of "comment-only" projects in Asana, a user's membership
    # in a project comes with associated permissions. These permissions (whether a
    # user has full access to the project or comment-only access) are accessible
    # through the project memberships endpoints described here.
    class ProjectMembership < Resource


      attr_reader :id

      attr_reader :user

      attr_reader :project

      attr_reader :write_access

      class << self
        # Returns the plural name of the resource.
        def plural_name
          'project_memberships'
        end

        # Returns the compact project membership records for the project.
        #
        # project - [Id] The project for which to fetch memberships.
        # user - [String] If present, the user to filter the memberships to.
        # per_page - [Integer] the number of records to fetch per page.
        # options - [Hash] the request I/O options.
        def get_many(client, project: required("project"), user: nil, per_page: 20, options: {})
          params = { user: user, limit: per_page }.reject { |_,v| v.nil? || Array(v).empty? }
          Collection.new(parse(client.get("/projects/#{project}/project_memberships", params: params, options: options)), type: Resource, client: client)
        end

        # Returns the project membership record.
        #
        # project - [Id] Globally unique identifier for the project membership.
        #
        # options - [Hash] the request I/O options.
        def get_single(client, project: required("project"), options: {})

          Resource.new(parse(client.get("/project_memberships/#{project}", options: options)).first, client: client)
        end
      end

    end
  end
end
